/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities.config;

import com.gregtechceu.gtceu.GTCEu;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;

@Config(id="gtmutils")
public class UtilConfig {
    public static UtilConfig INSTANCE;
    public static ConfigHolder<UtilConfig> CONFIG_HOLDER;
    @Configurable
    public FeatureConfigs features = new FeatureConfigs();

    public static void init() {
        CONFIG_HOLDER = Configuration.registerConfig(UtilConfig.class, (IConfigFormatHandler)ConfigFormats.yaml());
        INSTANCE = (UtilConfig)CONFIG_HOLDER.getConfigInstance();
    }

    public static boolean coolantEnabled() {
        return UtilConfig.INSTANCE.features.pterbCoolantBaseDrain != 0 || UtilConfig.INSTANCE.features.pterbCoolantIOMultiplier != 0.0f || GTCEu.isDataGen();
    }

    public static class FeatureConfigs {
        @Configurable
        @Configurable.Comment(value={"Whether the Sterile Cleaning Maintenance Hatch is enabled."})
        public boolean sterileHatchEnabled = false;
        @Configurable
        @Configurable.Comment(value={"Whether the 64A energy converters are enabled."})
        public boolean converters64aEnabled = true;
        @Configurable
        @Configurable.Comment(value={"Whether the Omni-breaker is enabled."})
        public boolean omnibreakerEnabled = true;
        @Configurable
        @Configurable.Comment(value={"What tier the Omni-breaker is, if enabled. (ULV = 0, LV = 1, MV = 2, ...)", "(Unless the default recipe is overridden, can only support LV to IV!)"})
        public int omnibreakerTier = 5;
        @Configurable
        @Configurable.Comment(value={"The energy capacity of the Omni-breaker."})
        public long omnibreakerEnergyCapacity = 40960000L;
        @Configurable
        @Configurable.Comment(value={"Whether the Wireless Active Transformer is enabled."})
        public boolean pterbEnabled = true;
        @Configurable
        @Configurable.Comment(value={"Whether placed Parallel Hatches should be automatically set to their maximum parallels."})
        public boolean parallelHatchAutoConfigure = false;
        @Configurable
        @Configurable.Comment(value={"Base amount of WAT coolant to drain every second.", "(Setting both this amount and the IO multiplier to 0 disables the coolant mechanic.)"})
        public int pterbCoolantBaseDrain = 0;
        @Configurable
        @Configurable.Comment(value={"Multiplier over IO amount for additional coolant drain.", "(Setting both this and the base drain amount to 0 disables the coolant mechanic.)"})
        public float pterbCoolantIOMultiplier = 0.0f;
        @Configurable
        @Configurable.Comment(value={"Whether the coins/credits are enabled."})
        public boolean coinsEnabled = false;
        @Configurable
        @Configurable.Comment(value={"Whether the custom MV tools are enabled."})
        public boolean customMVToolsEnabled = false;
        @Configurable
        @Configurable.Comment(value={"Whether the custom HV tools are enabled."})
        public boolean customHVToolsEnabled = false;
        @Configurable
        @Configurable.Comment(value={"Whether the custom EV tools are enabled."})
        public boolean customEVToolsEnabled = false;
        @Configurable
        @Configurable.Comment(value={"Whether the custom IV tools are enabled."})
        public boolean customIVToolsEnabled = false;
        @Configurable
        @Configurable.Comment(value={"Whether the custom LuV tools are enabled."})
        public boolean customLuVToolsEnabled = false;
        @Configurable
        @Configurable.Comment(value={"Whether the custom ZPM tools are enabled."})
        public boolean customZPMToolsEnabled = false;
    }
}

