/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities.saveddata;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.LaserHatchPartMachine;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class PTERBSavedData
extends SavedData {
    public Map<Integer, List<Pair<ResourceLocation, BlockPos>>> energyInputs = new HashMap<Integer, List<Pair<ResourceLocation, BlockPos>>>();
    public Map<Integer, List<Pair<ResourceLocation, BlockPos>>> energyOutputs = new HashMap<Integer, List<Pair<ResourceLocation, BlockPos>>>();
    public static String DATA_NAME = "pterb_energy";
    public static String ENERGY_INPUT_FREQUENCIES = "pterb_energy_input_frequencies";
    public static String ENERGY_OUTPUT_FREQUENCIES = "pterb_energy_output_frequencies";
    private final ServerLevel serverLevel;

    private PTERBSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    private PTERBSavedData(ServerLevel serverLevel, CompoundTag tag) {
        this(serverLevel);
        CompoundTag energyInputsTag = tag.m_128469_("energy_inputs");
        CompoundTag energyOutputsTag = tag.m_128469_("energy_outputs");
        ListTag energyInputFrequencies = energyInputsTag.m_128437_(ENERGY_INPUT_FREQUENCIES, 10);
        for (Tag t1 : energyInputFrequencies) {
            CompoundTag freqCompoundTag = (CompoundTag)t1;
            int freq = freqCompoundTag.m_128451_("frequency");
            ListTag inputs = freqCompoundTag.m_128437_("inputs", 10);
            List<Pair<ResourceLocation, BlockPos>> energyInputPairs = PTERBSavedData.getEnergyPairs(inputs);
            this.energyInputs.put(freq, energyInputPairs);
        }
        ListTag energyOutputFrequencies = energyOutputsTag.m_128437_(ENERGY_OUTPUT_FREQUENCIES, 10);
        for (Tag t1 : energyOutputFrequencies) {
            CompoundTag freqCompoundTag = (CompoundTag)t1;
            int freq = freqCompoundTag.m_128451_("frequency");
            ListTag outputs = freqCompoundTag.m_128437_("outputs", 10);
            List<Pair<ResourceLocation, BlockPos>> energyOutputPairs = PTERBSavedData.getEnergyPairs(outputs);
            this.energyOutputs.put(freq, energyOutputPairs);
        }
    }

    @NotNull
    private static List<Pair<ResourceLocation, BlockPos>> getEnergyPairs(ListTag tags) {
        ArrayList<Pair<ResourceLocation, BlockPos>> energyPairs = new ArrayList<Pair<ResourceLocation, BlockPos>>();
        for (Tag t2 : tags) {
            CompoundTag energyTag = (CompoundTag)t2;
            String dimensionNamespace = energyTag.m_128461_("dimension_namespace");
            String dimensionPath = energyTag.m_128461_("dimension_path");
            ResourceLocation dimension = new ResourceLocation(dimensionNamespace, dimensionPath);
            int x = energyTag.m_128451_("block_pos_x");
            int y = energyTag.m_128451_("block_pos_y");
            int z = energyTag.m_128451_("block_pos_z");
            BlockPos pos = new BlockPos(x, y, z);
            energyPairs.add((Pair<ResourceLocation, BlockPos>)new Pair((Object)dimension, (Object)pos));
        }
        return energyPairs;
    }

    public static PTERBSavedData getOrCreate(ServerLevel serverLevel) {
        return (PTERBSavedData)serverLevel.m_8895_().m_164861_(tag -> new PTERBSavedData(serverLevel, (CompoundTag)tag), () -> new PTERBSavedData(serverLevel), DATA_NAME);
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        CompoundTag energyInputsTag = new CompoundTag();
        CompoundTag energyOutputsTag = new CompoundTag();
        ListTag energyInputFrequencies = new ListTag();
        for (Integer freq : this.energyInputs.keySet()) {
            CompoundTag freqCompoundTag = new CompoundTag();
            freqCompoundTag.m_128405_("frequency", freq.intValue());
            List<Pair<ResourceLocation, BlockPos>> energyInputPairs = this.energyInputs.get(freq);
            ListTag inputs = PTERBSavedData.getEnergyTags(energyInputPairs);
            freqCompoundTag.m_128365_("inputs", (Tag)inputs);
            energyInputFrequencies.add((Object)freqCompoundTag);
        }
        energyInputsTag.m_128365_(ENERGY_INPUT_FREQUENCIES, (Tag)energyInputFrequencies);
        nbt.m_128365_("energy_inputs", (Tag)energyInputsTag);
        ListTag energyOutputFrequencies = new ListTag();
        for (Integer freq : this.energyInputs.keySet()) {
            CompoundTag freqCompoundTag = new CompoundTag();
            freqCompoundTag.m_128405_("frequency", freq.intValue());
            List<Pair<ResourceLocation, BlockPos>> energyInputPairs = this.energyInputs.get(freq);
            ListTag inputs = PTERBSavedData.getEnergyTags(energyInputPairs);
            freqCompoundTag.m_128365_("outputs", (Tag)inputs);
            energyOutputFrequencies.add((Object)freqCompoundTag);
        }
        energyOutputsTag.m_128365_(ENERGY_OUTPUT_FREQUENCIES, (Tag)energyOutputFrequencies);
        nbt.m_128365_("energy_outputs", (Tag)energyOutputsTag);
        return nbt;
    }

    @NotNull
    private static ListTag getEnergyTags(List<Pair<ResourceLocation, BlockPos>> pairs) {
        ListTag tags = new ListTag();
        for (Pair<ResourceLocation, BlockPos> pair : pairs) {
            CompoundTag energyTag = new CompoundTag();
            ResourceLocation dimension = (ResourceLocation)pair.getFirst();
            energyTag.m_128359_("dimension_namespace", dimension.m_135827_());
            energyTag.m_128359_("dimension_path", dimension.m_135815_());
            BlockPos pos = (BlockPos)pair.getSecond();
            energyTag.m_128405_("block_pos_x", pos.m_123341_());
            energyTag.m_128405_("block_pos_y", pos.m_123342_());
            energyTag.m_128405_("block_pos_z", pos.m_123343_());
            tags.add((Object)energyTag);
        }
        return tags;
    }

    public void addEnergyInputs(int freq, List<IMultiPart> parts) {
        List inputPairs = this.energyInputs.computeIfAbsent(freq, f -> new ArrayList());
        boolean changed = false;
        for (IMultiPart part : parts) {
            BlockPos pos;
            if (!(part instanceof MetaMachine)) continue;
            MetaMachine machine = (MetaMachine)part;
            ServerLevel level = (ServerLevel)machine.getLevel();
            assert (level != null);
            ResourceLocation dimension = level.m_46472_().m_135782_();
            Pair pair = new Pair((Object)dimension, (Object)(pos = machine.getPos()));
            if (inputPairs.contains(pair)) continue;
            inputPairs.add(pair);
            changed = true;
        }
        if (changed) {
            this.m_77762_();
        }
        this.energyInputs.put(freq, inputPairs);
    }

    public void removeEnergyInputs(int freq, List<IMultiPart> parts) {
        List inputPairs = this.energyInputs.computeIfAbsent(freq, f -> new ArrayList());
        boolean changed = false;
        for (IMultiPart part : parts) {
            BlockPos pos;
            if (!(part instanceof MetaMachine)) continue;
            MetaMachine machine = (MetaMachine)part;
            ServerLevel level = (ServerLevel)machine.getLevel();
            assert (level != null);
            ResourceLocation dimension = level.m_46472_().m_135782_();
            Pair pair = new Pair((Object)dimension, (Object)(pos = machine.getPos()));
            if (!inputPairs.remove(pair)) continue;
            changed = true;
        }
        if (changed) {
            this.m_77762_();
        }
        this.energyInputs.put(freq, inputPairs);
    }

    public void addEnergyOutputs(int freq, List<IMultiPart> parts) {
        List outputPairs = this.energyOutputs.computeIfAbsent(freq, f -> new ArrayList());
        boolean changed = false;
        for (IMultiPart part : parts) {
            BlockPos pos;
            if (!(part instanceof MetaMachine)) continue;
            MetaMachine machine = (MetaMachine)part;
            ServerLevel level = (ServerLevel)machine.getLevel();
            assert (level != null);
            ResourceLocation dimension = level.m_46472_().m_135782_();
            Pair pair = new Pair((Object)dimension, (Object)(pos = machine.getPos()));
            if (outputPairs.contains(pair)) continue;
            outputPairs.add(pair);
            changed = true;
        }
        if (changed) {
            this.m_77762_();
        }
        this.energyOutputs.put(freq, outputPairs);
    }

    public void removeEnergyOutputs(int freq, List<IMultiPart> parts) {
        List outputPairs = this.energyOutputs.computeIfAbsent(freq, f -> new ArrayList());
        boolean changed = false;
        for (IMultiPart part : parts) {
            BlockPos pos;
            if (!(part instanceof MetaMachine)) continue;
            MetaMachine machine = (MetaMachine)part;
            ServerLevel level = (ServerLevel)machine.getLevel();
            assert (level != null);
            ResourceLocation dimension = level.m_46472_().m_135782_();
            Pair pair = new Pair((Object)dimension, (Object)(pos = machine.getPos()));
            if (!outputPairs.remove(pair)) continue;
            changed = true;
        }
        if (changed) {
            this.m_77762_();
        }
        this.energyOutputs.put(freq, outputPairs);
    }

    public void saveDataToCache() {
        if (this.m_77764_()) {
            this.serverLevel.m_8895_().m_164855_(DATA_NAME, (SavedData)this);
            this.serverLevel.m_8895_().m_78151_();
            this.m_77760_(false);
        }
    }

    public EnergyContainerList getWirelessEnergyInputs(int freq) {
        List inputPairs = this.energyInputs.computeIfAbsent(freq, f -> new ArrayList());
        ArrayList<Object> energyContainerList = new ArrayList<Object>();
        for (Pair pair : inputPairs) {
            EnergyHatchPartMachine hatch;
            ServerLevel dimension = this.serverLevel.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceLocation)pair.getFirst())));
            if (dimension == null) continue;
            MetaMachine machine = MetaMachine.getMachine((BlockGetter)dimension, (BlockPos)((BlockPos)pair.getSecond()));
            if (machine instanceof EnergyHatchPartMachine) {
                hatch = (EnergyHatchPartMachine)machine;
                energyContainerList.add(hatch.energyContainer);
            }
            if (!(machine instanceof LaserHatchPartMachine)) continue;
            hatch = (LaserHatchPartMachine)machine;
            for (RecipeHandlerList handlerList : hatch.getRecipeHandlers()) {
                List<IEnergyContainer> containers = handlerList.getCapability((RecipeCapability)EURecipeCapability.CAP).stream().filter(IEnergyContainer.class::isInstance).map(IEnergyContainer.class::cast).toList();
                energyContainerList.addAll(containers);
            }
        }
        return new EnergyContainerList(energyContainerList);
    }

    public EnergyContainerList getWirelessEnergyOutputs(int freq) {
        List outputPairs = this.energyOutputs.computeIfAbsent(freq, f -> new ArrayList());
        ArrayList<Object> energyContainerList = new ArrayList<Object>();
        for (Pair pair : outputPairs) {
            EnergyHatchPartMachine hatch;
            ServerLevel dimension = this.serverLevel.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceLocation)pair.getFirst())));
            if (dimension == null) continue;
            MetaMachine machine = MetaMachine.getMachine((BlockGetter)dimension, (BlockPos)((BlockPos)pair.getSecond()));
            if (machine instanceof EnergyHatchPartMachine) {
                hatch = (EnergyHatchPartMachine)machine;
                energyContainerList.add(hatch.energyContainer);
            }
            if (!(machine instanceof LaserHatchPartMachine)) continue;
            hatch = (LaserHatchPartMachine)machine;
            for (RecipeHandlerList handlerList : hatch.getRecipeHandlers()) {
                List<IEnergyContainer> containers = handlerList.getCapability((RecipeCapability)EURecipeCapability.CAP).stream().filter(IEnergyContainer.class::isInstance).map(IEnergyContainer.class::cast).toList();
                energyContainerList.addAll(containers);
            }
        }
        return new EnergyContainerList(energyContainerList);
    }
}

