/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialRegistryEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.PostMaterialEvent;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neganote.gtutilities.client.renderer.UtilShaders;
import net.neganote.gtutilities.common.data.UtilPlaceholders;
import net.neganote.gtutilities.common.item.UtilItems;
import net.neganote.gtutilities.common.item.UtilToolItems;
import net.neganote.gtutilities.common.machine.UtilMachines;
import net.neganote.gtutilities.common.materials.UtilMaterials;
import net.neganote.gtutilities.common.tools.UtilToolConnection;
import net.neganote.gtutilities.config.UtilConfig;
import net.neganote.gtutilities.datagen.UtilDatagen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gtmutils")
public class GregTechModernUtilities {
    public static final String MOD_ID = "gtmutils";
    public static final Logger LOGGER = LogManager.getLogger();
    public static GTRegistrate REGISTRATE = GTRegistrate.create((String)"gtmutils");
    public static RegistryEntry<CreativeModeTab> UTIL_CREATIVE_TAB = null;

    public GregTechModernUtilities() {
        GregTechModernUtilities.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        if (GTCEu.isClientSide()) {
            modEventBus.addListener(this::clientSetup);
            modEventBus.register(UtilShaders.class);
        }
        modEventBus.addListener(this::addMaterialRegistries);
        modEventBus.addListener(this::addMaterials);
        modEventBus.addListener(this::modifyMaterials);
        modEventBus.addGenericListener(GTRecipeType.class, this::registerRecipeTypes);
        modEventBus.addGenericListener(MachineDefinition.class, this::registerMachines);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void init() {
        UtilConfig.init();
        UTIL_CREATIVE_TAB = UtilConfig.INSTANCE.features.omnibreakerEnabled ? REGISTRATE.defaultCreativeTab(MOD_ID, builder -> builder.m_257501_((CreativeModeTab.DisplayItemsGenerator)new GTCreativeModeTabs.RegistrateDisplayItemsGenerator(MOD_ID, REGISTRATE)).m_257941_((Component)REGISTRATE.addLang("itemGroup", GregTechModernUtilities.id("creative_tab"), "GregTech Modern Utilities")).m_257737_(() -> UtilItems.OMNIBREAKER.asStack()).m_257652_()).register() : REGISTRATE.defaultCreativeTab(MOD_ID, builder -> builder.m_257501_((CreativeModeTab.DisplayItemsGenerator)new GTCreativeModeTabs.RegistrateDisplayItemsGenerator(MOD_ID, REGISTRATE)).m_257941_((Component)REGISTRATE.addLang("itemGroup", GregTechModernUtilities.id("creative_tab"), "GregTech Modern Utilities")).m_257737_(() -> ((ItemEntry)GTItems.INTEGRATED_CIRCUIT_HV).asStack()).m_257652_()).register();
        UtilItems.init();
        UtilToolItems.init();
        REGISTRATE.registerRegistrate();
        UtilDatagen.init();
        UtilPlaceholders.init();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            LOGGER.info("Hello from common setup! This is *after* registries are done, so we can do this:");
            LOGGER.info("Look, I found a {}!", (Object)Items.f_42415_);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (UtilConfig.INSTANCE.features.omnibreakerEnabled) {
                ItemProperties.register((Item)((Item)UtilItems.OMNIBREAKER.get()), (ResourceLocation)GregTechModernUtilities.id("omnibreaker_name"), (itemStack, clientLevel, livingEntity, i) -> {
                    String hoverName = itemStack.m_41786_().getString().toLowerCase();
                    if (hoverName.equals("monibreaker") || hoverName.equals("moni-breaker")) {
                        return 1.0f;
                    }
                    if (hoverName.equals("meownibreaker") || hoverName.equals("meowni-breaker")) {
                        return 2.0f;
                    }
                    return 0.0f;
                });
            }
        });
    }

    private void addMaterialRegistries(MaterialRegistryEvent event) {
        GTCEuAPI.materialManager.createRegistry(MOD_ID);
    }

    private void addMaterials(MaterialEvent event) {
        UtilMaterials.register();
    }

    private void modifyMaterials(PostMaterialEvent event) {
        UtilToolConnection.modifyMaterials();
    }

    private void registerRecipeTypes(GTCEuAPI.RegisterEvent<ResourceLocation, GTRecipeType> event) {
    }

    private void registerMachines(GTCEuAPI.RegisterEvent<ResourceLocation, MachineDefinition> event) {
        UtilMachines.init();
    }
}

