/*
 * Decompiled with CFR 0.152.
 */
package net.gamemode3.pickup.inventory;

import java.util.Optional;
import net.gamemode3.pickup.inventory.BundleHelper;
import net.gamemode3.pickup.inventory.ShulkerBoxHelper;
import net.gamemode3.pickup.mixin.PlayerInventoryInvoker;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_3545;
import net.minecraft.class_9835;

public class PlayerInventoryHelper {
    public static int OFFHAND_SLOT = 45;

    public static class_9835 createOffhandSetPacket(class_1657 player) {
        return new class_9835(OFFHAND_SLOT, player.method_6079());
    }

    public static Optional<class_3545<Integer, class_3545<Integer, class_1799>>> tryExtractStackFromContainer(class_1661 inventory, class_1799 stack, boolean enableShulkerBox, boolean enableBundle) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            Optional<class_3545<Integer, class_1799>> extractedItemInfo;
            class_1799 containerStack = inventory.method_5438(i);
            if (enableShulkerBox && containerStack.method_31573(class_3489.field_54293)) {
                extractedItemInfo = ShulkerBoxHelper.tryExtractFromShulkerBox(stack, containerStack);
                if (!extractedItemInfo.isPresent()) continue;
                class_3545<Integer, class_1799> extractedItem = extractedItemInfo.get();
                return Optional.of(new class_3545((Object)i, extractedItem));
            }
            if (!enableBundle || !containerStack.method_31573(class_3489.field_54294) || !(extractedItemInfo = BundleHelper.tryExtractFromBundle(stack, containerStack)).isPresent()) continue;
            class_3545<Integer, class_1799> extractedItem = extractedItemInfo.get();
            return Optional.of(new class_3545((Object)i, extractedItem));
        }
        return Optional.empty();
    }

    public static boolean tryFillEmptySlot(class_1661 inventory, class_1799 stack) {
        int emptySlot = inventory.method_7376();
        if (emptySlot != -1) {
            stack.method_7939(((PlayerInventoryInvoker)inventory).invokeAddStack(emptySlot, stack));
            return stack.method_7947() < stack.method_7914();
        }
        return false;
    }

    public static class_3545<Integer, class_1799> findHotbarStackToReplace(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            class_1799 hotbarStack = playerInventory.method_5438(i);
            if (!hotbarStack.method_7960()) continue;
            return new class_3545((Object)i, (Object)hotbarStack);
        }
        int selectedSlot = playerInventory.method_67532();
        class_1799 selectedStack = playerInventory.method_5438(selectedSlot);
        return new class_3545((Object)selectedSlot, (Object)selectedStack);
    }

    public static boolean tryPutIntoContainer(class_1661 playerInventory, int containerSlotInInventory, int itemSlotInContainer, class_1799 stack) {
        class_1799 containerStack = playerInventory.method_5438(containerSlotInInventory);
        if (containerStack.method_31573(class_3489.field_54293)) {
            return ShulkerBoxHelper.tryPutIntoShulkerBox(stack, containerStack, itemSlotInContainer);
        }
        if (containerStack.method_31573(class_3489.field_54294)) {
            return BundleHelper.tryAddIntoBundle(stack, containerStack);
        }
        return false;
    }
}

