package net.gamemode3.pickup.mixin;

import net.gamemode3.pickup.config.ModConfig;
import net.gamemode3.pickup.inventory.ContainerHelper;
import net.gamemode3.pickup.inventory.PlayerInventoryExtension;
import net.gamemode3.pickup.inventory.PlayerInventoryHelper;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_9835;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.Optional;

@Mixin(class_1661.class)
public abstract class PlayerInventoryMixin implements PlayerInventoryExtension {
    @Shadow
    @Final
    public class_1657 player;

    @Shadow
    protected abstract int addStack(class_1799 stack);

    @Shadow
    public abstract int getEmptySlot();

    @Shadow
    @Final
    private class_2371<class_1799> main;

    @Shadow
    public abstract void setStack(int slot, class_1799 stack);

    @Shadow
    public abstract class_1799 getStack(int slot);

    @Shadow
    public abstract int getSelectedSlot();

    @Shadow
    public abstract class_1799 getSelectedStack();

    @Shadow
    public abstract class_9835 createSlotSetPacket(int slot);

    @Inject(method = "insertStack(ILnet/minecraft/item/ItemStack;)Z", at = @At("HEAD"), cancellable = true)
    private void insertStack(int slot, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.method_7960()) {
            cir.setReturnValue(false);
            return;
        }
        try {
            int initialStackCount = stack.method_7947();
            if (slot != -1) {
                Thread.dumpStack();
                class_1799 slotStack = this.getStack(slot);
                if (slotStack.method_7960()) {
                    this.setStack(slot, stack.method_7972());
                    stack.method_7939(0);
                    cir.setReturnValue(true);
                    return;
                }
                if (!class_1799.method_31577(slotStack, stack)) {
                    cir.setReturnValue(false);
                    return;
                }
                int freeSpace = slotStack.method_7914() - slotStack.method_7947();
                int amountToAdd = Math.min(freeSpace, stack.method_7947());
                slotStack.method_7933(amountToAdd);
                stack.method_7934(amountToAdd);
                cir.setReturnValue(stack.method_7947() < initialStackCount);
                return;
            }

            boolean stackChanged = true;
            while (!stack.method_7960() && stackChanged) {
                int previousCount = stack.method_7947();
                stack.method_7939(this.addStack(stack));
                stackChanged = stack.method_7947() < previousCount;
            }

            if (!stackChanged && this.player.method_56992()) {
                stack.method_7939(0);
                cir.setReturnValue(true);
                return;
            }
            cir.setReturnValue(stackChanged);
        } catch (Throwable e) {
            class_128 crashReport = class_128.method_560(e, "Adding item to inventory");
            class_129 crashReportSection = crashReport.method_562("Item being added");
            crashReportSection.method_578("Item ID", class_1792.method_7880(stack.method_7909()));
            crashReportSection.method_578("Item data", stack.method_7919());
            crashReportSection.method_577("Item name", (() -> stack.method_7964().getString()));
            throw new class_148(crashReport);
        }
    }

    @Inject(method = "addStack(Lnet/minecraft/item/ItemStack;)I", at = @At("HEAD"), cancellable = true)
    private void addStack(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        class_3545<Integer, Integer> result = addStackGetSlot(stack);
        cir.setReturnValue(result.method_15442());
    }

    /**
     * @param stack The stack to add to the inventory.
     * @return A pair where the first element is the remaining stack count
     * and the second element is the slot index where the stack was added.
     * If the slot index is -1, it means the stack was added to the off-hand.
     */
    @Unique
    private class_3545<Integer, Integer> addStackGetSlot(class_1799 stack) {
        Optional<Integer> stackingInfo;
        if (ModConfig.getAlwaysStackIntoEquippedContainer()) {
            stackingInfo = tryStackIntoEquippedContainer(stack);
            if (stackingInfo.isPresent()) {
                return new class_3545<>(stack.method_7947(), stackingInfo.get());
            }
        }
        if (ModConfig.getAlwaysPickUpIntoEquippedContainer()) {
            stackingInfo = tryPickUpIntoEquippedContainer(stack);
            if (stackingInfo.isPresent()) {
                return new class_3545<>(stack.method_7947(), stackingInfo.get());
            }
        }

        stackingInfo = tryStackIntoInventory(stack);
        if (stackingInfo.isPresent()) {
            return new class_3545<>(stack.method_7947(), stackingInfo.get());
        }

        if (ModConfig.getStackIntoContainers()) {
            stackingInfo = tryStackIntoContainer(stack);
            if (stackingInfo.isPresent()) {
                return new class_3545<>(stack.method_7947(), stackingInfo.get());
            }
        }

        stackingInfo = tryFillEmptySlot(stack);
        if (stackingInfo.isPresent()) {
            return new class_3545<>(stack.method_7947(), stackingInfo.get());
        }

        if (ModConfig.getPickUpIntoContainers()) {
            stackingInfo = tryPickUpIntoContainer(stack);
            if (stackingInfo.isPresent()) {
                return new class_3545<>(stack.method_7947(), stackingInfo.get());
            }
        }

        return new class_3545<>(stack.method_7947(), -2); // No slots available
    }

    @Inject(method = "offer", at = @At("HEAD"), cancellable = true)
    private void offer(class_1799 stack, boolean notifiesClient, CallbackInfo ci) {
        boolean stackChanged = true;
        while (!stack.method_7960() && stackChanged) {
            int previousCount = stack.method_7947();
            class_3545<Integer, Integer> result = this.addStackGetSlot(stack);


            stack.method_7939(result.method_15442());
            stackChanged = stack.method_7947() < previousCount;
            if (stackChanged && notifiesClient && this.player instanceof class_3222 serverPlayerEntity) {
                int slot = result.method_15441();
                if (slot >= 0) {
                    serverPlayerEntity.field_13987.method_14364(this.createSlotSetPacket(slot));
                } else if (slot == -1) {
                    serverPlayerEntity.field_13987.method_14364(PlayerInventoryHelper.createOffhandSetPacket(this.player));
                }
            }
        }

        if (!stackChanged && this.player.method_56992()) {
            stack.method_7939(0);
            return;
        }

        if (!stack.method_7960()) {
            this.player.method_7328(stack, true);
        }

        ci.cancel();
    }

    @Unique
    private Optional<Integer> tryStackIntoEquippedContainer(class_1799 stack) {
        boolean enableShulkers = ModConfig.getAlwaysStackIntoEquippedShulkerBox();
        boolean enableBundles = ModConfig.getAlwaysStackIntoEquippedBundle();

        class_1799 mainHandStack = this.getSelectedStack();
        if (ContainerHelper.tryStackIntoContainer(stack, mainHandStack, enableShulkers, enableBundles)) {
            int mainHandSlot = this.getSelectedSlot();
            return Optional.of(mainHandSlot);
        }
        class_1799 offHandStack = this.player.method_6079();
        if (ContainerHelper.tryStackIntoContainer(stack, offHandStack, enableShulkers, enableBundles)) {
            return Optional.of(-1);
        }
        return Optional.empty();
    }

    @Unique
    private Optional<Integer> tryPickUpIntoEquippedContainer(class_1799 stack) {
        boolean enableShulkers = ModConfig.getAlwaysPickUpIntoEquippedShulkerBox();
        boolean enableBundles = ModConfig.getAlwaysPickUpIntoEquippedBundle();

        class_1799 mainHandStack = this.getSelectedStack();
        if (ContainerHelper.tryPickUpIntoContainer(stack, mainHandStack, enableShulkers, enableBundles)) {
            int mainHandSlot = this.getSelectedSlot();
            return Optional.of(mainHandSlot);
        }

        class_1799 offHandStack = this.player.method_6079();
        if (ContainerHelper.tryPickUpIntoContainer(stack, offHandStack, enableShulkers, enableBundles)) {
            return Optional.of(-1);
        }
        return Optional.empty();
    }

    @Unique
    private Optional<Integer> tryPickUpIntoContainer(class_1799 stack) {
        boolean enableShulkers = ModConfig.getPickUpIntoShulkerBox();
        boolean enableBundles = ModConfig.getPickUpIntoBundle();

        class_1799 mainHandStack = this.getSelectedStack();
        if (ContainerHelper.tryPickUpIntoContainer(stack, mainHandStack, enableShulkers, enableBundles)) {
            return Optional.of(this.getSelectedSlot());
        }

        class_1799 offHandStack = this.player.method_6079();
        if (ContainerHelper.tryPickUpIntoContainer(stack, offHandStack, enableShulkers, enableBundles)) return Optional.of(-1);

        for (int i = 0; i < this.main.size(); i++) {
            class_1799 containerStack = this.main.get(i);
            if (ContainerHelper.tryPickUpIntoContainer(stack, containerStack, enableShulkers, enableBundles)) return Optional.of(i);
        }

        return Optional.empty();
    }

    @Unique
    private Optional<Integer> tryStackIntoInventory(class_1799 stack) {
        class_1799 selectedStack = this.getSelectedStack();
        if (addStackToOther(stack, selectedStack)) {
            return Optional.of(this.getSelectedSlot());
        }
        class_1799 offHandStack = this.player.method_6079();
        if (addStackToOther(stack, offHandStack)) {
            return Optional.of(-1);
        }

        for (int i = 0; i < this.main.size(); i++) {
            class_1799 existingStack = this.main.get(i);
            if (!addStackToOther(stack, existingStack)) continue;
            this.main.set(i, existingStack);
            return Optional.of(i);
        }
        return Optional.empty();
    }

    @Unique
    private static boolean addStackToOther(class_1799 stack, class_1799 existingStack) {
        if (existingStack.method_7960()) return false;

        if (!class_1799.method_31577(stack, existingStack)) {
            return false;
        }
        int freeSpace = existingStack.method_7914() - existingStack.method_7947();
        if (freeSpace <= 0) {
            return false;
        }
        int amountToAdd = Math.min(freeSpace, stack.method_7947());
        existingStack.method_7933(amountToAdd);
        stack.method_7934(amountToAdd);
        return true;
    }

    @Unique
    private Optional<Integer> tryFillEmptySlot(class_1799 stack) {
        int emptySlot = this.getEmptySlot();
        if (emptySlot != -1) {
            this.setStack(emptySlot, stack.method_7972());
            stack.method_7939(0);
            return Optional.of(emptySlot);
        }
        return Optional.empty();
    }

    @Unique
    private Optional<Integer> tryStackIntoContainer(class_1799 stack) {
        boolean enableShulkers = ModConfig.getStackIntoShulkerBox();
        boolean enableBundles = ModConfig.getStackIntoBundle();

        class_1799 mainHandStack = this.getSelectedStack();
        if (ContainerHelper.tryStackIntoContainer(stack, mainHandStack, enableShulkers, enableBundles)) {
            return Optional.of(this.getSelectedSlot());
        }

        class_1799 offHandStack = this.player.method_6079();
        if (ContainerHelper.tryStackIntoContainer(stack, offHandStack, enableShulkers, enableBundles)) {
            return Optional.of(-1);
        }

        for (int i = 0; i < this.main.size(); i++) {
            class_1799 containerStack = this.main.get(i);
            if (ContainerHelper.tryStackIntoContainer(stack, containerStack, enableShulkers, enableBundles)) {
                return Optional.of(i);
            }
        }

        return Optional.empty();
    }

    // ====== GHOST SLOTS ======

    @Unique
    private final List<class_1792> ghostSlots = class_2371.method_10213(class_1661.field_30638, class_1802.field_8713);

    public class_1792 pick_up$getGhostItem(int slot) {
        if (slot < 0 || slot >= ghostSlots.size()) {
            return class_1802.field_8162;
        }
        return ghostSlots.get(slot);
    }

    public boolean pick_up$setGhostItem(int slot, class_1792 item) {
        if (slot < 0 || slot >= ghostSlots.size()) {
            return false;
        }
        ghostSlots.set(slot, item);
        return true;
    }
}