package net.gamemode3.pickup.inventory;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_5537;
import net.minecraft.class_9276;
import net.minecraft.class_9334;

public class BundleHelper {
    public static boolean tryAddIntoBundle(class_1799 stack, class_1799 bundleStack) {
        System.out.println("Trying to pick up into bundle: " + bundleStack);
        class_9276 bundleContentsComponent = bundleStack.method_58695(
                class_9334.field_49650,
                class_9276.field_49289
        );
        class_9276.class_9277 builder = new class_9276.class_9277(bundleContentsComponent);
        int addedItems = builder.method_57432(stack);

        bundleStack.method_57379(class_9334.field_49650, builder.method_57435());
        //                this.onContentChanged(player);
        return addedItems > 0;
    }

    public static boolean tryStackIntoBundle(class_1799 stack, class_1799 bundleStack) {
        // check if the bundle contains a stack of the same item
        boolean hasSameItem = findItemInBundle(bundleStack, stack) != -1;

        if (hasSameItem) {
            return tryAddIntoBundle(stack, bundleStack);
        }
        return false;
    }

    public static int findItemInBundle(class_1799 bundleStack, class_1799 stack) {
        int selectedSlot = class_5537.method_61643(bundleStack);
        for (int i = 0; i < class_5537.method_61645(bundleStack); i++) {
            class_5537.method_61637(bundleStack, i);
            class_1799 bundleContent = class_5537.method_61644(bundleStack);
            if (bundleContent.method_7960()) continue;
            if (class_1799.method_31577(bundleContent, stack)) {
                class_5537.method_61637(bundleStack, selectedSlot);
                return i;
            }
        }
        // make sure we don't mess nothin' up innit
        class_5537.method_61637(bundleStack, selectedSlot);
        return -1;
    }

    public static Optional<class_3545<Integer, class_1799>> tryExtractFromBundle(class_1799 stack, class_1799 bundleStack) {
        int stackIndex = findItemInBundle(bundleStack, stack);
        if (stackIndex == -1) {
            return Optional.empty(); // Item not found in bundle
        }
        int selectedSlot = class_5537.method_61643(bundleStack);
        class_5537.method_61637(bundleStack, stackIndex);
        class_1799 bundleContent = class_5537.method_61644(bundleStack);
        class_9276 bundleContentsComponent = Objects.requireNonNull(bundleStack.method_58694(class_9334.field_49650));
        class_9276.class_9277 builder = new class_9276.class_9277(bundleContentsComponent);
        builder.method_57430();
        bundleStack.method_57379(class_9334.field_49650, builder.method_57435());
        if (selectedSlot > stackIndex) selectedSlot--;
        class_5537.method_61637(bundleStack, selectedSlot);
        return Optional.of(new class_3545<>(stackIndex, bundleContent));
    }
}
