package net.gamemode3.pickup.inventory;

import static net.gamemode3.pickup.inventory.BundleHelper.tryAddIntoBundle;
import static net.gamemode3.pickup.inventory.BundleHelper.tryStackIntoBundle;
import static net.gamemode3.pickup.inventory.ShulkerBoxHelper.tryAddIntoShulkerBox;
import static net.gamemode3.pickup.inventory.ShulkerBoxHelper.tryStackIntoShulkerBox;

import net.minecraft.class_1799;
import net.minecraft.class_3489;

public class ContainerHelper {

    public static boolean tryStackIntoContainer(class_1799 stack, class_1799 containerStack, boolean useShulkerBoxes, boolean useBundles) {
        if (containerStack.method_7960()) return false;

        if (containerStack.method_31573(class_3489.field_54293) && useShulkerBoxes) {
            return tryStackIntoShulkerBox(stack, containerStack);
        }
        if (containerStack.method_31573(class_3489.field_54294) && useBundles) {
            return tryStackIntoBundle(stack, containerStack);
        }
        return false;
    }

//    public static boolean tryPickUpIntoContainer(ItemStack stack, ItemStack containerStack) {
//        return tryPickUpIntoContainer(stack, containerStack, ModConfig.getPickUpIntoShulkerBox(), ModConfig.getPickUpIntoBundle());
//    }

    public static boolean tryPickUpIntoContainer(class_1799 stack, class_1799 containerStack, boolean useShulkerBoxes, boolean useBundles) {
        if (containerStack.method_7960()) return false;

        if (containerStack.method_31573(class_3489.field_54293) && useShulkerBoxes) {
            return tryAddIntoShulkerBox(stack, containerStack);
        }
        if (containerStack.method_31573(class_3489.field_54294) && useBundles) {
            return tryAddIntoBundle(stack, containerStack);
        }
        return false;
    }
}
