package net.gamemode3.pickup.mixin;

import net.gamemode3.pickup.config.ModConfig;
import net.gamemode3.pickup.inventory.PlayerInventoryHelper;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2735;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3545;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;

@Mixin(class_3244.class)
public class ServerPlayNetworkHandlerMixin {
    @Shadow public class_3222 player;

    @Inject(method="onPickItem", at=@At("HEAD"), cancellable = true)
    private void onPickItem(class_1799 stack, CallbackInfo ci) {
        if (stack.method_45435(this.player.method_37908().method_45162())) {
            class_1661 playerInventory = this.player.method_31548();
            int i = playerInventory.method_7395(stack);
            if (i != -1) {
                if (class_1661.method_7380(i)) {
                    playerInventory.method_61496(i);
                } else {
                    playerInventory.method_7365(i);
                }
            } else {
                boolean enableShulkerBox = ModConfig.getPickFromShulkerBox();
                boolean enableBundle = ModConfig.getPickFromBundle();
                Optional<class_3545<Integer, class_3545<Integer, class_1799>>> extractedItemInfo = PlayerInventoryHelper.tryExtractStackFromContainer(playerInventory, stack, enableShulkerBox, enableBundle);

                if (extractedItemInfo.isPresent()) {
                    class_3545<Integer, class_3545<Integer, class_1799>> extractedItem = extractedItemInfo.get();
                    int containerSlotInInventory = extractedItem.method_15442();
                    class_3545<Integer, class_1799> containerItem = extractedItem.method_15441();
                    int itemSlotInContainer = containerItem.method_15442();
                    class_1799 extractedItemStack = containerItem.method_15441().method_7972();

                    class_3545<Integer, class_1799> hotbarReplaceInfo = PlayerInventoryHelper.findHotbarStackToReplace(playerInventory);
                    Integer hotbarReplaceIndex = hotbarReplaceInfo.method_15442();
                    class_1799 previousHotbarStack = hotbarReplaceInfo.method_15441();

                    if (previousHotbarStack.method_7960()) {
                        playerInventory.method_5447(hotbarReplaceIndex, extractedItemStack);
                        playerInventory.method_61496(hotbarReplaceIndex);
                    } else {
                        boolean success = PlayerInventoryHelper.tryFillEmptySlot(playerInventory, previousHotbarStack);
                        if (!success) {
                            success = PlayerInventoryHelper.tryPutIntoContainer(playerInventory, containerSlotInInventory, itemSlotInContainer, previousHotbarStack);
                        }
                        if (!success) {
                            if (!PlayerInventoryHelper.tryPutIntoContainer(playerInventory, containerSlotInInventory, itemSlotInContainer, extractedItemStack)) {
                                // Can't put the item back where it came from, that should not happen
                                throw new RuntimeException("Failed to put item back into container: " + extractedItemStack);
                            }
                            if (this.player.method_56992()) {
                                playerInventory.method_65126(stack);
                            }

                        }
                        else {
                            playerInventory.method_5447(hotbarReplaceIndex, extractedItemStack);
                            playerInventory.method_61496(hotbarReplaceIndex);
                        }
                    }

                } else if (this.player.method_56992()) {
                    playerInventory.method_65126(stack);
                }
            }

            this.player.field_13987.method_14364(new class_2735(playerInventory.method_67532()));
            this.player.field_7498.method_7623();
            ci.cancel();
        }
    }
}
