/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.misc.Delayed26WayDistancePropagator3D;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiSection;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4157;
import net.minecraft.class_4180;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_9172;
import net.minecraft.class_9240;
import net.minecraft.class_9820;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4153.class})
public abstract class PoiManagerMixin
extends class_4180<Object, Object>
implements ChunkSystemPoiManager {
    @Unique
    private class_3218 world;
    @Unique
    private final Delayed26WayDistancePropagator3D villageDistanceTracker = new Delayed26WayDistancePropagator3D();
    @Unique
    private static final int POI_DATA_SOURCE = 7;

    public PoiManagerMixin(class_9172 simpleRegionStorage, Codec<Object> codec, Function<Object, Object> function, BiFunction<Object, Runnable, Object> biFunction, Function<Runnable, Object> function2, class_5455 registryAccess, class_9820 chunkIOErrorReporter, class_5539 levelHeightAccessor) {
        super(simpleRegionStorage, codec, function, biFunction, function2, registryAccess, chunkIOErrorReporter, levelHeightAccessor);
    }

    @Shadow
    abstract boolean method_19133(long var1);

    @Shadow
    public abstract void method_19510(class_4076 var1, class_2826 var2);

    @Unique
    private static int convertBetweenLevels(int level) {
        return 7 - level;
    }

    @Unique
    private void updateDistanceTracking(long section) {
        if (this.method_19133(section)) {
            this.villageDistanceTracker.setSource(section, 7);
        } else {
            this.villageDistanceTracker.removeSource(section);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/class_9240;Ljava/nio/file/Path;Lcom/mojang/datafixers/DataFixer;ZLnet/minecraft/class_5455;Lnet/minecraft/class_9820;Lnet/minecraft/class_5539;)V"}, at={@At(value="RETURN")})
    private void initHook(class_9240 regionStorageInfo, Path path, DataFixer dataFixer, boolean bl, class_5455 registryAccess, class_9820 chunkIOErrorReporter, class_5539 levelHeightAccessor, CallbackInfo ci) {
        this.world = (class_3218)levelHeightAccessor;
    }

    @Overwrite
    public int method_19118(class_4076 pos) {
        this.villageDistanceTracker.propagateUpdates();
        return PoiManagerMixin.convertBetweenLevels(this.villageDistanceTracker.getLevel(CoordinateUtils.getChunkSectionKey(pos)));
    }

    @Overwrite
    public void method_19290(BooleanSupplier shouldKeepTicking) {
        this.villageDistanceTracker.propagateUpdates();
    }

    @Overwrite
    public void method_19288(long pos) {
        int chunkZ;
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        PoiChunk chunk = manager.getPoiChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkSectionZ(pos), false);
        if (chunk != null) {
            chunk.setDirty(true);
        }
        this.updateDistanceTracking(pos);
    }

    @Overwrite
    public void method_19291(long pos) {
        this.updateDistanceTracking(pos);
    }

    public Optional<Object> method_19293(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((class_1937)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        PoiChunk ret = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        return ret == null ? Optional.empty() : ret.getSectionForVanilla(chunkY);
    }

    public Optional<Object> method_19294(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((class_1937)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager;
        if (chunkY >= WorldUtil.getMinSection((class_1937)this.world) && chunkY <= WorldUtil.getMaxSection((class_1937)this.world)) {
            PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
            if (ret != null) {
                return ret.getSectionForVanilla(chunkY);
            }
            return manager.loadPoiChunk(chunkX, chunkZ).getSectionForVanilla(chunkY);
        }
        return Optional.empty();
    }

    protected Object method_19295(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((class_1937)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager;
        PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        if (ret != null) {
            return ret.getOrCreateSection(chunkY);
        }
        return manager.loadPoiChunk(chunkX, chunkZ).getOrCreateSection(chunkY);
    }

    @Override
    public final class_3218 moonrise$getWorld() {
        return this.world;
    }

    @Override
    public final void moonrise$onUnload(long coordinate) {
        int chunkX = CoordinateUtils.getChunkX(coordinate);
        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
        int minY = WorldUtil.getMinSection((class_1937)this.world);
        int maxY = WorldUtil.getMaxSection((class_1937)this.world);
        TickThread.ensureTickThread((class_1937)this.world, chunkX, chunkZ, "Unloading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            long sectionPos = class_4076.method_18685((int)chunkX, (int)sectionY, (int)chunkZ);
            this.updateDistanceTracking(sectionPos);
        }
    }

    @Override
    public final void moonrise$loadInPoiChunk(PoiChunk poiChunk) {
        int chunkX = poiChunk.chunkX;
        int chunkZ = poiChunk.chunkZ;
        int minY = WorldUtil.getMinSection((class_1937)this.world);
        int maxY = WorldUtil.getMaxSection((class_1937)this.world);
        TickThread.ensureTickThread((class_1937)this.world, chunkX, chunkZ, "Loading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            class_4157 section = poiChunk.getSection(sectionY);
            if (section == null || ((ChunkSystemPoiSection)section).moonrise$isEmpty()) continue;
            this.method_19291(class_4076.method_18685((int)chunkX, (int)sectionY, (int)chunkZ));
        }
    }

    @Override
    public final void moonrise$checkConsistency(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int minY = WorldUtil.getMinSection((class_5539)chunk);
        int maxY = WorldUtil.getMaxSection((class_5539)chunk);
        class_2826[] sections = chunk.method_12006();
        for (int section = minY; section <= maxY; ++section) {
            this.method_19510(class_4076.method_18676((int)chunkX, (int)section, (int)chunkZ), sections[section - minY]);
        }
    }

    @Redirect(method={"method_22439(Lnet/minecraft/class_4538;Lnet/minecraft/class_2338;I)V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal=1))
    private <T> Stream<T> skipLoadedSet(Stream<T> instance, Predicate<? super T> predicate) {
        return instance;
    }
}

