/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_133;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_32;
import net.minecraft.class_3204;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5281;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5568;
import net.minecraft.class_5576;
import net.minecraft.class_5577;
import net.minecraft.class_5579;
import net.minecraft.class_6880;
import net.minecraft.class_8565;
import net.minecraft.class_9240;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
abstract class ServerLevelMixin
extends class_1937
implements ChunkSystemServerLevel,
ChunkSystemLevelReader,
class_5281 {
    @Shadow
    private class_5579<class_1297> field_26935;
    @Shadow
    @Final
    private MinecraftServer field_13959;
    @Shadow
    @Final
    private class_3215 field_24624;
    @Unique
    private boolean markedClosing;
    @Unique
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    @Unique
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader((class_3218)this);
    @Unique
    private EntityDataController entityDataController;
    @Unique
    private PoiDataController poiDataController;
    @Unique
    private ChunkDataController chunkDataController;
    @Unique
    private ChunkTaskScheduler chunkTaskScheduler;
    @Unique
    private long lastMidTickFailure;
    @Unique
    private long tickedBlocksOrFluids;
    @Unique
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers((class_3218)this);
    @Unique
    private static final class_2818[] EMPTY_LEVEL_CHUNKS = new class_2818[0];
    @Unique
    private final ReferenceList<class_2818> loadedChunks = new ReferenceList<class_2818>(EMPTY_LEVEL_CHUNKS);
    @Unique
    private final ReferenceList<class_2818> tickingChunks = new ReferenceList<class_2818>(EMPTY_LEVEL_CHUNKS);
    @Unique
    private final ReferenceList<class_2818> entityTickingChunks = new ReferenceList<class_2818>(EMPTY_LEVEL_CHUNKS);

    protected ServerLevelMixin(class_5269 writableLevelData, class_5321<class_1937> resourceKey, class_5455 registryAccess, class_6880<class_2874> holder, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, bl, bl2, l, i);
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/class_32$class_5143;Lnet/minecraft/class_5268;Lnet/minecraft/class_5321;Lnet/minecraft/class_5363;ZJLjava/util/List;ZLnet/minecraft/class_8565;)V"}, at={@At(value="RETURN")})
    private void init(MinecraftServer minecraftServer, Executor executor, class_32.class_5143 levelStorageAccess, class_5268 serverLevelData, class_5321<class_1937> resourceKey, class_5363 levelStem, boolean bl, long l, List<class_5304> list, boolean bl2, class_8565 randomSequences, CallbackInfo ci) {
        this.field_26935 = null;
        this.moonrise$setEntityLookup(new ServerEntityLookup((class_3218)this, (class_5576<class_1297>)new class_3218.class_5526((class_3218)this)));
        this.chunkTaskScheduler = new ChunkTaskScheduler((class_3218)this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new class_9240(levelStorageAccess.method_27005(), resourceKey, "entities"), levelStorageAccess.method_27424(resourceKey).resolve("entities"), minecraftServer.method_27051()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController((class_3218)this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController((class_3218)this, this.chunkTaskScheduler);
    }

    @Override
    public final class_2818 moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.field_24624.method_21730(chunkX, chunkZ);
    }

    @Override
    public final class_2791 moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final class_2791 moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, class_2806 leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        ((ChunkSystemMinecraftServer)this.field_13959).moonrise$executeMidTickTasks();
    }

    @Override
    public final class_2791 moonrise$syncLoadNonFull(int chunkX, int chunkZ, class_2806 status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return 6;
    }

    @Override
    public final boolean moonrise$isMarkedClosing() {
        return this.markedClosing;
    }

    @Override
    public final void moonrise$setMarkedClosing(boolean value) {
        this.markedClosing = value;
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(class_2338 pos, int radiusBlocks, Priority priority, Consumer<List<class_2791>> onLoad) {
        this.moonrise$loadChunksAsync(pos.method_10263() - radiusBlocks >> 4, pos.method_10263() + radiusBlocks >> 4, pos.method_10260() - radiusBlocks >> 4, pos.method_10260() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(class_2338 pos, int radiusBlocks, class_2806 chunkStatus, Priority priority, Consumer<List<class_2791>> onLoad) {
        this.moonrise$loadChunksAsync(pos.method_10263() - radiusBlocks >> 4, pos.method_10263() + radiusBlocks >> 4, pos.method_10260() - radiusBlocks >> 4, pos.method_10260() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<class_2791>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, class_2806.field_12803, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, class_2806 chunkStatus, Priority priority, Consumer<List<class_2791>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, chunkStatus, priority, onLoad, null);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, class_2806 chunkStatus, Priority priority, Consumer<List<class_2791>> onLoad, Consumer<class_2791> onEachLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<class_2791> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.method_12004(), ticketLevel, holderIdentifier);
            }
            if (onEachLoad != null) {
                onEachLoad.accept((class_2791)chunk);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    if (onLoad != null) {
                        onLoad.accept(Collections.unmodifiableList(ret));
                    }
                }
                finally {
                    int len = ret.size();
                    for (int i = 0; i < len; ++i) {
                        class_1923 chunkPos = ((class_2791)ret.get(i)).method_12004();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunkTaskScheduler.scheduleChunkLoad(cx, cz, chunkStatus, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<class_2818> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<class_2818> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<class_2818> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        class_3215 chunkSource = this.field_24624;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.method_12123(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean method_8393(int x, int z) {
        return this.moonrise$getFullChunkIfLoaded(x, z) != null;
    }

    public class_2791 method_8402(int x, int z, class_2806 status, boolean load) {
        return this.field_24624.method_12121(x, z, status, load);
    }

    public class_2818 method_8497(int x, int z) {
        return (class_2818)this.field_24624.method_12121(x, z, class_2806.field_12803, true);
    }

    @Redirect(method={"method_31420(Lnet/minecraft/class_8921;Lnet/minecraft/class_3695;Lnet/minecraft/class_1297;)V", "*"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3204;method_38630(J)Z"))
    private boolean shortCircuitTickCheck(class_3204 instance, long chunk) {
        return true;
    }

    @Redirect(method={"method_18765(Ljava/util/function/BooleanSupplier;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31809()V"))
    private void redirectEntityManagerTick(class_5579<class_1297> instance) {
    }

    @Overwrite
    public boolean method_39425(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    @Redirect(method={"method_14176(Lnet/minecraft/class_3536;ZZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31836()V"))
    private void redirectSaveAll(class_5579<class_1297> instance) {
    }

    @Redirect(method={"method_14176(Lnet/minecraft/class_3536;ZZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31829()V"))
    private void redirectAutoSave(class_5579<class_1297> instance) {
    }

    @Redirect(method={"method_14175(Lnet/minecraft/class_1297;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31818(Lnet/minecraft/class_5568;)Z"))
    private <T extends class_5568> boolean redirectAddEntityEntity(class_5579<T> instance, T entity) {
        return this.moonrise$getEntityLookup().addNewEntity((class_1297)entity);
    }

    @Overwrite
    public boolean method_30736(class_1297 entity) {
        Stream<UUID> stream = entity.method_24204().map(class_1297::method_5667);
        if (stream.anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.method_30771(entity);
        return true;
    }

    @Redirect(method={"method_21625(Ljava/nio/file/Path;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31845()Ljava/lang/String;"))
    private String redirectDebugStats(class_5579<class_1297> instance) {
        return this.moonrise$getEntityLookup().getDebugInfo();
    }

    @Redirect(method={"method_21625(Ljava/nio/file/Path;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3898;method_21619(Ljava/io/Writer;)V"))
    private void redirectChunkMapDebug(class_3898 instance, Writer writer) {
    }

    @Redirect(method={"method_21625(Ljava/nio/file/Path;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31826(Ljava/io/Writer;)V"))
    private void redirectEntityManagerDebug(class_5579<class_1297> instance, Writer writer) {
    }

    @Redirect(method={"method_31268()Ljava/lang/String;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31845()Ljava/lang/String;"))
    private String redirectWatchdogStats1(class_5579<class_1297> instance) {
        return this.moonrise$getEntityLookup().getDebugInfo();
    }

    @Redirect(method={"method_31268()Ljava/lang/String;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31841()Lnet/minecraft/class_5577;"))
    private class_5577<class_1297> redirectWatchdogStats2(class_5579<class_1297> instance) {
        return this.moonrise$getEntityLookup();
    }

    @Redirect(method={"method_31592()Lnet/minecraft/class_5577;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31841()Lnet/minecraft/class_5577;"))
    private class_5577<class_1297> redirectGetEntities(class_5579<class_1297> instance) {
        return this.moonrise$getEntityLookup();
    }

    @Redirect(method={"method_31423(Ljava/util/stream/Stream;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31828(Ljava/util/stream/Stream;)V"))
    private void redirectLegacyChunkEntities(class_5579<class_1297> instance, Stream<class_1297> stream) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(stream.toList(), null);
    }

    @Redirect(method={"method_31426(Ljava/util/stream/Stream;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31835(Ljava/util/stream/Stream;)V"))
    private void redirectWorldGenChunkEntities(class_5579<class_1297> instance, Stream<class_1297> stream) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(stream.toList(), null);
    }

    @Inject(method={"method_72270(Lnet/minecraft/class_1923;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectWaitForEntities(class_1923 chunkPos, int radius, CallbackInfo ci) {
        List chunks = class_1923.method_19280((class_1923)chunkPos, (int)radius).toList();
        this.field_13959.method_18857(() -> {
            for (class_1923 chunkpos : chunks) {
                if (this.method_37116(chunkpos.method_8324())) continue;
                return false;
            }
            return true;
        });
        ci.cancel();
    }

    @Redirect(method={"close()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;close()V"))
    private void redirectClose(class_5579<class_1297> instance) {
    }

    @Redirect(method={"method_31419()Ljava/lang/String;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31845()Ljava/lang/String;"))
    private String redirectGatherChunkSourceStats(class_5579<class_1297> instance) {
        return this.moonrise$getEntityLookup().getDebugInfo();
    }

    @Overwrite
    public boolean method_37116(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    @Overwrite
    public boolean method_37117(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    @Overwrite
    public boolean method_37118(class_2338 pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Overwrite
    public boolean method_66588(class_1923 pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Redirect(method={"method_67505(Lnet/minecraft/class_1923;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_40021(Lnet/minecraft/class_1923;)Z"))
    private <T extends class_5568> boolean redirectCanEntitiesSpawnTickCheck(class_5579<T> instance, class_1923 pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @WrapOperation(method={"method_8538(Lnet/minecraft/class_128;)Lnet/minecraft/class_129;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_129;method_577(Ljava/lang/String;Lnet/minecraft/class_133;)Lnet/minecraft/class_129;")})
    private class_129 redirectCrashCount(class_129 instance, String s, class_133<String> string, Operation<class_129> original) {
        return (class_129)original.call(new Object[]{instance, s, () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount())});
    }

    @Inject(method={"method_14171(Lnet/minecraft/class_2338;Lnet/minecraft/class_3611;)V"}, at={@At(value="RETURN")})
    private void midTickFluids(CallbackInfo ci) {
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            return;
        }
        ((ChunkSystemMinecraftServer)this.field_13959).moonrise$executeMidTickTasks();
    }

    @Inject(method={"method_14189(Lnet/minecraft/class_2338;Lnet/minecraft/class_2248;)V"}, at={@At(value="RETURN")})
    private void midTickBlock(CallbackInfo ci) {
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            return;
        }
        ((ChunkSystemMinecraftServer)this.field_13959).moonrise$executeMidTickTasks();
    }
}

