/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.fabric;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.BaseChunkSystemHooks;
import ca.spottedleaf.moonrise.common.util.ConfigHolder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongArrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1508;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2839;
import net.minecraft.class_2852;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5575;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9310;
import net.minecraft.class_9761;
import org.slf4j.Logger;

public final class FabricHooks
extends BaseChunkSystemHooks
implements PlatformHooks {
    private static final boolean HAS_FABRIC_LIFECYCLE_EVENTS = FabricLoader.getInstance().isModLoaded("fabric-lifecycle-events-v1");
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getBrand() {
        return "Moonrise";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public int getLightEmission(class_2680 blockState, class_1922 world, class_2338 pos) {
        return blockState.method_26213();
    }

    @Override
    public Predicate<class_2680> maybeHasLightEmission() {
        return state -> state.method_26213() != 0;
    }

    @Override
    public boolean hasCurrentlyLoadingChunk() {
        return false;
    }

    @Override
    public class_2818 getCurrentlyLoadingChunk(class_9761 holder) {
        return null;
    }

    @Override
    public void setCurrentlyLoading(class_9761 holder, class_2818 levelChunk) {
    }

    @Override
    public void chunkFullStatusComplete(class_2818 newChunk, class_2839 original) {
        if (HAS_FABRIC_LIFECYCLE_EVENTS) {
            ((ServerChunkEvents.Load)ServerChunkEvents.CHUNK_LOAD.invoker()).onChunkLoad((class_3218)newChunk.method_12200(), newChunk);
            if (!(original instanceof class_2821)) {
                ((ServerChunkEvents.Generate)ServerChunkEvents.CHUNK_GENERATE.invoker()).onChunkGenerate((class_3218)newChunk.method_12200(), newChunk);
            }
        }
    }

    @Override
    public boolean allowAsyncTicketUpdates() {
        return false;
    }

    @Override
    public void onChunkHolderTicketChange(class_3218 world, class_3193 holder, int oldLevel, int newLevel) {
    }

    @Override
    public void chunkUnloadFromWorld(class_2818 chunk) {
        if (HAS_FABRIC_LIFECYCLE_EVENTS) {
            ((ServerChunkEvents.Unload)ServerChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload((class_3218)chunk.method_12200(), chunk);
        }
    }

    @Override
    public void chunkSyncSave(class_3218 world, class_2791 chunk, class_2852 data) {
    }

    @Override
    public void onChunkWatch(class_3218 world, class_2818 chunk, class_3222 player) {
    }

    @Override
    public void onChunkUnWatch(class_3218 world, class_1923 chunk, class_3222 player) {
    }

    @Override
    public void addToGetEntities(class_1937 world, class_1297 entity, class_238 boundingBox, Predicate<? super class_1297> predicate, List<class_1297> into) {
        Collection parts = world.method_65097();
        if (parts.isEmpty()) {
            return;
        }
        for (class_1508 part : parts) {
            if (part == entity || !part.method_5829().method_994(boundingBox) || predicate != null && !predicate.test((class_1297)part)) continue;
            into.add((class_1297)part);
        }
    }

    @Override
    public <T extends class_1297> void addToGetEntities(class_1937 world, class_5575<class_1297, T> entityTypeTest, class_238 boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        if (into.size() >= maxCount) {
            return;
        }
        Collection parts = world.method_65097();
        if (parts.isEmpty()) {
            return;
        }
        for (class_1508 part : parts) {
            class_1297 casted;
            if (!part.method_5829().method_994(boundingBox) || (casted = (class_1297)entityTypeTest.method_31796((Object)part)) == null || predicate != null && !predicate.test(casted)) continue;
            into.add(casted);
            if (into.size() < maxCount) continue;
            break;
        }
    }

    @Override
    public void entityMove(class_1297 entity, long oldSection, long newSection) {
    }

    @Override
    public boolean screenEntity(class_3218 world, class_1297 entity, boolean fromDisk, boolean event) {
        return true;
    }

    @Override
    public boolean configFixMC224294() {
        return ConfigHolder.getConfig().bugFixes.fixMC224294;
    }

    @Override
    public boolean configAutoConfigSendDistance() {
        return ConfigHolder.getConfig().chunkLoading.advanced.autoConfigSendDistance;
    }

    @Override
    public double configPlayerMaxLoadRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxLoadRate;
    }

    @Override
    public double configPlayerMaxGenRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxGenRate;
    }

    @Override
    public double configPlayerMaxSendRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxSendRate;
    }

    @Override
    public int configPlayerMaxConcurrentLoads() {
        return ConfigHolder.getConfig().chunkLoading.advanced.playerMaxConcurrentChunkLoads;
    }

    @Override
    public int configPlayerMaxConcurrentGens() {
        return ConfigHolder.getConfig().chunkLoading.advanced.playerMaxConcurrentChunkGenerates;
    }

    @Override
    public long configAutoSaveInterval(class_3218 world) {
        return ConfigHolder.getConfig().chunkSaving.autoSaveInterval.getTimeTicks();
    }

    @Override
    public int configMaxAutoSavePerTick(class_3218 world) {
        return ConfigHolder.getConfig().chunkSaving.maxAutoSaveChunksPerTick;
    }

    @Override
    public boolean configFixMC159283() {
        return ConfigHolder.getConfig().bugFixes.fixMC159283;
    }

    @Override
    public boolean forceNoSave(class_2791 chunk) {
        return false;
    }

    @Override
    public class_2487 convertNBT(DSL.TypeReference type, DataFixer dataFixer, class_2487 nbt, int fromVersion, int toVersion) {
        return (class_2487)dataFixer.update(type, new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt), fromVersion, toVersion).getValue();
    }

    @Override
    public boolean hasMainChunkLoadHook() {
        return false;
    }

    @Override
    public void mainChunkLoad(class_2791 chunk, class_2852 chunkData) {
    }

    @Override
    public List<class_1297> modifySavedEntities(class_3218 world, int chunkX, int chunkZ, List<class_1297> entities) {
        return entities;
    }

    @Override
    public void unloadEntity(class_1297 entity) {
        entity.method_31745(class_1297.class_5529.field_27000);
    }

    @Override
    public void postLoadProtoChunk(class_3218 world, class_2839 chunk) {
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(chunk.method_71412(), LOGGER);){
            class_9310.method_60552((class_3218)world, (class_11368.class_11370)class_11352.method_71416((class_8942)scopedCollector, (class_7225.class_7874)world.method_30349(), (List)chunk.method_12295()));
        }
    }

    @Override
    public int modifyEntityTrackingRange(class_1297 entity, int currentRange) {
        return currentRange;
    }

    @Override
    public long[] getCounterTypesUncached(class_3230 type) {
        if (type == class_3230.field_14031) {
            return new long[]{0L, 1L};
        }
        if (type.method_72274()) {
            return new long[]{1L};
        }
        return LongArrays.EMPTY_ARRAY;
    }

    @Override
    public boolean addTicketForEnderPearls(class_3218 world) {
        return true;
    }
}

