/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2165;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_4093;
import net.minecraft.class_8599;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
abstract class MinecraftServerMixin
extends class_4093<class_3738>
implements ChunkSystemMinecraftServer,
class_8599,
class_2165,
AutoCloseable {
    @Shadow
    @Final
    private class_8915 field_47142;
    @Shadow
    @Final
    private static Logger field_4546;
    @Unique
    private volatile Throwable chunkSystemCrash;
    @Unique
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    @Unique
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    @Unique
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    @Unique
    private long lastMidTickExecute;
    @Unique
    private long lastMidTickExecuteFailure;

    @Shadow
    public abstract Iterable<class_3218> method_3738();

    @Shadow
    public abstract boolean method_3723(boolean var1, boolean var2, boolean var3);

    @Shadow
    protected abstract boolean method_3866();

    public MinecraftServerMixin(String string) {
        super(string);
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    @Unique
    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (class_3218 world : this.method_3738()) {
            long currTime = System.nanoTime();
            if (currTime - ((ChunkSystemServerLevel)world).moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.method_14178().method_19492()) {
                ((ChunkSystemServerLevel)world).moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    @Overwrite
    private boolean method_20415() {
        if (super.method_16075()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        if (this.field_47142.method_54670() || this.method_3866()) {
            boolean ret = false;
            for (class_3218 world : this.method_3738()) {
                if (!world.method_14178().method_19492()) continue;
                ret = true;
            }
            return ret;
        }
        return false;
    }

    @Inject(method={"method_29741()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3748(Ljava/util/function/BooleanSupplier;)V", shift=At.Shift.AFTER)})
    private void hookChunkSystemCrash(CallbackInfo ci) {
        Throwable crash = this.chunkSystemCrash;
        if (crash != null) {
            this.chunkSystemCrash = null;
            throw new RuntimeException("Chunk system crash propagated to tick()", crash);
        }
    }

    @Redirect(method={"method_3782()V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;anyMatch(Ljava/util/function/Predicate;)Z", ordinal=0))
    private boolean doNotWaitChunkSystemShutdown(Stream<class_3218> instance, Predicate<? super class_3218> predicate) {
        for (class_3218 world : this.method_3738()) {
            world.method_14178().method_66012();
        }
        return false;
    }

    @Redirect(method={"method_3782()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3723(ZZZ)Z"))
    private boolean markClosed(MinecraftServer instance, boolean bl, boolean bl2, boolean bl3) {
        for (class_3218 world : this.method_3738()) {
            ((ChunkSystemServerLevel)world).moonrise$setMarkedClosing(true);
        }
        return this.method_3723(false, true, true);
    }

    @Redirect(method={"method_3782()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3218;close()V", ordinal=0))
    private void noOpClose(class_3218 instance) {
    }

    @Inject(method={"method_3782()V"}, at={@At(value="RETURN")})
    private void closeIOThreads(CallbackInfo ci) {
        field_4546.info("Waiting for all RegionFile I/O tasks to complete...");
        MoonriseRegionFileIO.flush((MinecraftServer)this);
        field_4546.info("All RegionFile I/O tasks to complete");
        if (this instanceof class_3176) {
            MoonriseCommon.haltExecutors();
        }
    }
}

