/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3194;
import net.minecraft.class_3204;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_8527;
import net.minecraft.class_8563;
import net.minecraft.class_9259;
import net.minecraft.class_9761;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3215.class})
abstract class ServerChunkCacheMixin
extends class_2802
implements ChunkSystemServerChunkCache {
    @Shadow
    @Final
    public class_3215.class_4212 field_18809;
    @Shadow
    @Final
    public class_3218 field_13945;
    @Shadow
    @Final
    private class_26 field_17708;
    @Unique
    private final ConcurrentLong2ReferenceChainedHashTable<class_2818> fullChunks = new ConcurrentLong2ReferenceChainedHashTable();

    ServerChunkCacheMixin() {
    }

    @Override
    public final void moonrise$setFullChunk(int chunkX, int chunkZ, class_2818 chunk) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (chunk == null) {
            this.fullChunks.remove(key);
        } else {
            this.fullChunks.put(key, chunk);
        }
    }

    @Override
    public final class_2818 moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Unique
    private class_2791 syncLoad(int chunkX, int chunkZ, class_2806 toStatus) {
        class_2791 ret;
        ChunkTaskScheduler chunkTaskScheduler = ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler();
        CompletableFuture completable = new CompletableFuture();
        chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, true, Priority.BLOCKING, completable::complete);
        if (!completable.isDone() && chunkTaskScheduler.hasShutdown()) {
            throw new IllegalStateException("Chunk system has shut down, cannot process chunk requests in world '" + WorldUtil.getWorldName((class_1937)this.field_13945) + "' at (" + chunkX + "," + chunkZ + ") status: " + String.valueOf(toStatus));
        }
        if (TickThread.isTickThreadFor((class_1937)this.field_13945, chunkX, chunkZ)) {
            ChunkTaskScheduler.pushChunkWait(this.field_13945, chunkX, chunkZ);
            this.field_18809.method_18857(completable::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ret = (class_2791)completable.join()) == null) {
            throw new IllegalStateException("Chunk not loaded when requested");
        }
        return ret;
    }

    @Unique
    private class_2791 getChunkFallback(int chunkX, int chunkZ, class_2806 toStatus, boolean load) {
        class_2818 loading;
        class_2791 ifPresent;
        ChunkTaskScheduler chunkTaskScheduler = ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        NewChunkHolder currentChunk = chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        class_2791 class_27912 = ifPresent = currentChunk == null ? null : currentChunk.getChunkIfPresent(toStatus);
        if (ifPresent != null && (toStatus != class_2806.field_12803 || currentChunk.isFullChunkReady())) {
            return ifPresent;
        }
        PlatformHooks platformHooks = PlatformHooks.get();
        if (platformHooks.hasCurrentlyLoadingChunk() && currentChunk != null && (loading = platformHooks.getCurrentlyLoadingChunk((class_9761)currentChunk.vanillaChunkHolder)) != null && TickThread.isTickThread()) {
            return loading;
        }
        return load ? this.syncLoad(chunkX, chunkZ, toStatus) : null;
    }

    @Overwrite
    public class_2791 method_12121(int chunkX, int chunkZ, class_2806 toStatus, boolean load) {
        if (toStatus == class_2806.field_12803) {
            class_2818 ret = this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (ret != null) {
                return ret;
            }
            return load ? this.getChunkFallback(chunkX, chunkZ, toStatus, load) : null;
        }
        return this.getChunkFallback(chunkX, chunkZ, toStatus, load);
    }

    @Overwrite
    public class_2818 method_21730(int chunkX, int chunkZ) {
        class_2818 ret = this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (!PlatformHooks.get().hasCurrentlyLoadingChunk()) {
            return ret;
        }
        if (ret != null || !TickThread.isTickThread()) {
            return ret;
        }
        NewChunkHolder holder = ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (holder == null) {
            return ret;
        }
        return PlatformHooks.get().getCurrentlyLoadingChunk((class_9761)holder.vanillaChunkHolder);
    }

    @Overwrite
    public boolean method_12123(int chunkX, int chunkZ) {
        return this.method_21730(chunkX, chunkZ) != null;
    }

    @Overwrite
    public CompletableFuture<class_9259<class_2791>> method_14134(int chunkX, int chunkZ, class_2806 toStatus, boolean create) {
        class_2791 ifPresent;
        boolean needsFullScheduling;
        TickThread.ensureTickThread((class_1937)this.field_13945, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = class_8563.method_51829((class_2806)toStatus);
        NewChunkHolder chunkHolder = ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = toStatus == class_2806.field_12803 && (chunkHolder == null || !chunkHolder.getChunkStatus().method_14014(class_3194.field_44855));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return class_3193.field_51867;
        }
        class_2791 class_27912 = ifPresent = chunkHolder == null ? null : chunkHolder.getChunkIfPresent(toStatus);
        if (needsFullScheduling || ifPresent == null) {
            CompletableFuture<class_9259<class_2791>> ret = new CompletableFuture<class_9259<class_2791>>();
            Consumer<class_2791> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(class_3193.field_51866);
                } else {
                    ret.complete(class_9259.method_57124((Object)chunk));
                }
            };
            ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, true, Priority.HIGHER, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(class_9259.method_57124((Object)ifPresent));
    }

    @Overwrite
    public class_8527 method_12246(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(class_2806.field_44633.method_16560());
    }

    @Overwrite
    public boolean method_16155() {
        return ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
    }

    @Overwrite
    public boolean method_37114(long los) {
        NewChunkHolder newChunkHolder = ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(los);
        return newChunkHolder != null && newChunkHolder.isTickingReady();
    }

    @Overwrite
    public void close() throws IOException {
        this.field_17708.close();
        ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().chunkHolderManager.close(true, true);
    }

    @Inject(method={"method_12127(Ljava/util/function/BooleanSupplier;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3215;method_14161()V")})
    private void tickHook(CallbackInfo ci) {
        ((ChunkSystemServerLevel)this.field_13945).moonrise$getPlayerChunkLoader().tick();
    }

    @Overwrite
    public void method_27907(long pos, Consumer<class_2818> consumer) {
        class_2818 fullChunk = this.fullChunks.get(pos);
        if (fullChunk != null) {
            consumer.accept(fullChunk);
        }
    }

    @Redirect(method={"method_17298(Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3215;method_16155()Z"))
    private boolean skipSaveTicketUpdates(class_3215 instance) {
        return false;
    }

    @Redirect(method={"method_61264(Lnet/minecraft/class_3695;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3193;method_16144()Lnet/minecraft/class_2818;"))
    private class_2818 redirectTickingChunk(class_3193 instance) {
        return instance.method_53682();
    }

    @Redirect(method={"method_67502(Lnet/minecraft/class_2818;JLjava/util/List;Lnet/minecraft/class_1948$class_5262;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3204;method_38630(J)Z"))
    private boolean shortTickThunder(class_3204 instance, long pos) {
        return true;
    }

    @Redirect(method={"method_67502(Lnet/minecraft/class_2818;JLjava/util/List;Lnet/minecraft/class_1948$class_5262;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_67505(Lnet/minecraft/class_1923;)Z"))
    private boolean onlyCheckWBForSpawning(class_3218 instance, class_1923 pos) {
        return instance.method_8621().method_11951(pos);
    }

    @Overwrite
    public CompletableFuture<?> method_72267(class_3230 ticketType, class_1923 chunkPos, int radius) {
        return ((ChunkSystemServerLevel)this.field_13945).moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAndLoadWithRadius(ticketType, chunkPos, radius, class_2806.field_12803, Priority.NORMAL);
    }
}

