/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity;

import ca.spottedleaf.moonrise.common.list.EntityList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.SWMRLong2ObjectHashTable;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3194;
import net.minecraft.class_3532;
import net.minecraft.class_5569;
import net.minecraft.class_5575;
import net.minecraft.class_5576;
import net.minecraft.class_5577;
import net.minecraft.class_5584;
import net.minecraft.class_7927;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityLookup
implements class_5577<class_1297> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityLookup.class);
    protected static final int REGION_SHIFT = 5;
    protected static final int REGION_MASK = 31;
    protected static final int REGION_SIZE = 32;
    public final class_1937 world;
    protected final SWMRLong2ObjectHashTable<ChunkSlicesRegion> regions = new SWMRLong2ObjectHashTable(128, 0.5f);
    protected final class_5576<class_1297> worldCallback;
    protected final ConcurrentLong2ReferenceChainedHashTable<class_1297> entityById = new ConcurrentLong2ReferenceChainedHashTable();
    protected final ConcurrentHashMap<UUID, class_1297> entityByUUID = new ConcurrentHashMap();
    protected final EntityList accessibleEntities = new EntityList();

    public EntityLookup(class_1937 world, class_5576<class_1297> worldCallback) {
        this.world = world;
        this.worldCallback = worldCallback;
    }

    protected abstract Boolean blockTicketUpdates();

    protected abstract void setBlockTicketUpdates(Boolean var1);

    protected abstract void checkThread(int var1, int var2, String var3);

    protected abstract void checkThread(class_1297 var1, String var2);

    protected abstract ChunkEntitySlices createEntityChunk(int var1, int var2, boolean var3);

    protected abstract void onEmptySlices(int var1, int var2);

    protected abstract void entitySectionChangeCallback(class_1297 var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract void addEntityCallback(class_1297 var1);

    protected abstract void removeEntityCallback(class_1297 var1);

    protected abstract void entityStartLoaded(class_1297 var1);

    protected abstract void entityEndLoaded(class_1297 var1);

    protected abstract void entityStartTicking(class_1297 var1);

    protected abstract void entityEndTicking(class_1297 var1);

    protected abstract boolean screenEntity(class_1297 var1, boolean var2, boolean var3);

    private static class_1297 maskNonAccessible(class_1297 entity) {
        if (entity == null) {
            return null;
        }
        class_5584 visibility = EntityLookup.getEntityStatus(entity);
        return visibility.method_31885() ? entity : null;
    }

    public class_1297 get(int id) {
        return EntityLookup.maskNonAccessible(this.entityById.get(id));
    }

    public class_1297 get(UUID id) {
        return EntityLookup.maskNonAccessible(id == null ? null : this.entityByUUID.get(id));
    }

    public boolean hasEntity(UUID uuid) {
        return this.get(uuid) != null;
    }

    public String getDebugInfo() {
        return "count_id:" + this.entityById.size() + ",count_uuid:" + this.entityByUUID.size() + ",count_accessible:" + this.getEntityCount() + ",region_count:" + this.regions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<class_1297> method_31803() {
        EntityList entityList = this.accessibleEntities;
        synchronized (entityList) {
            int len = this.accessibleEntities.size();
            class_1297[] cpy = (class_1297[])Arrays.copyOf(this.accessibleEntities.getRawData(), len, class_1297[].class);
            Objects.checkFromToIndex(0, len, cpy.length);
            return new ArrayIterable<class_1297>(cpy, 0, len);
        }
    }

    public Iterable<class_1297> getAllMapped() {
        return this.entityByUUID.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntityCount() {
        EntityList entityList = this.accessibleEntities;
        synchronized (entityList) {
            return this.accessibleEntities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_1297[] getAllCopy() {
        EntityList entityList = this.accessibleEntities;
        synchronized (entityList) {
            return (class_1297[])Arrays.copyOf(this.accessibleEntities.getRawData(), this.accessibleEntities.size(), class_1297[].class);
        }
    }

    public <U extends class_1297> void method_31806(class_5575<class_1297, U> filter, class_7927<U> action) {
        class_1297 casted;
        class_1297 entity;
        class_5584 visibility;
        Iterator<class_1297> iterator = this.entityById.valueIterator();
        while (!(!iterator.hasNext() || (visibility = EntityLookup.getEntityStatus(entity = iterator.next())).method_31885() && (casted = (class_1297)filter.method_31796((Object)entity)) != null && action.accept((Object)casted).method_47543())) {
        }
    }

    public void method_31807(class_238 box, Consumer<class_1297> action) {
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        this.getEntities((class_1297)null, box, entities, null);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            action.accept((class_1297)entities.get(i));
        }
    }

    public <U extends class_1297> void method_31805(class_5575<class_1297, U> filter, class_238 box, class_7927<U> action) {
        class_1297 casted;
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        this.getEntities((class_1297)null, box, entities, null);
        int len = entities.size();
        for (int i = 0; !(i >= len || (casted = (class_1297)filter.method_31796((Object)((class_1297)entities.get(i)))) != null && action.accept((Object)casted).method_47543()); ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityStatusChange(class_1297 entity, ChunkEntitySlices slices, class_5584 oldVisibility, class_5584 newVisibility, boolean moved, boolean created, boolean destroyed) {
        boolean entityStatusUpdateBefore;
        this.checkThread(entity, "Entity status change must only happen on the main thread");
        if (((ChunkSystemEntity)entity).moonrise$isUpdatingSectionStatus()) {
            LOGGER.error("Cannot recursively update entity chunk status for entity " + String.valueOf(entity), new Throwable());
            return;
        }
        boolean bl = entityStatusUpdateBefore = slices == null ? false : slices.startPreventingStatusUpdates();
        if (entityStatusUpdateBefore) {
            LOGGER.error("Cannot update chunk status for entity " + String.valueOf(entity) + " since entity chunk (" + slices.chunkX + "," + slices.chunkZ + ") is receiving update", new Throwable());
            return;
        }
        try {
            Boolean ticketBlockBefore = this.blockTicketUpdates();
            try {
                ((ChunkSystemEntity)entity).moonrise$setUpdatingSectionStatus(true);
                try {
                    if (created && this.worldCallback != null) {
                        this.worldCallback.method_31802((Object)entity);
                    }
                    if (oldVisibility == newVisibility) {
                        if (moved && newVisibility.method_31885() && this.worldCallback != null) {
                            this.worldCallback.method_43029((Object)entity);
                        }
                        return;
                    }
                    if (newVisibility.ordinal() > oldVisibility.ordinal()) {
                        if (!oldVisibility.method_31885() && newVisibility.method_31885()) {
                            this.entityStartLoaded(entity);
                            EntityList entityList = this.accessibleEntities;
                            synchronized (entityList) {
                                this.accessibleEntities.add(entity);
                            }
                            if (this.worldCallback != null) {
                                this.worldCallback.method_31798((Object)entity);
                            }
                        }
                        if (!oldVisibility.method_31883() && newVisibility.method_31883()) {
                            this.entityStartTicking(entity);
                            if (this.worldCallback != null) {
                                this.worldCallback.method_31800((Object)entity);
                            }
                        }
                    } else {
                        if (oldVisibility.method_31883() && !newVisibility.method_31883()) {
                            this.entityEndTicking(entity);
                            if (this.worldCallback != null) {
                                this.worldCallback.method_31799((Object)entity);
                            }
                        }
                        if (oldVisibility.method_31885() && !newVisibility.method_31885()) {
                            this.entityEndLoaded(entity);
                            EntityList entityList = this.accessibleEntities;
                            synchronized (entityList) {
                                this.accessibleEntities.remove(entity);
                            }
                            if (this.worldCallback != null) {
                                this.worldCallback.method_31797((Object)entity);
                            }
                        }
                    }
                    if (moved && newVisibility.method_31885() && this.worldCallback != null) {
                        this.worldCallback.method_43029((Object)entity);
                    }
                    if (destroyed && this.worldCallback != null) {
                        this.worldCallback.method_31801((Object)entity);
                    }
                }
                finally {
                    ((ChunkSystemEntity)entity).moonrise$setUpdatingSectionStatus(false);
                }
            }
            finally {
                this.setBlockTicketUpdates(ticketBlockBefore);
            }
        }
        finally {
            if (slices != null) {
                slices.stopPreventingStatusUpdates(false);
            }
        }
    }

    public void chunkStatusChange(int x, int z, class_3194 newStatus) {
        this.getChunk(x, z).updateStatus(newStatus, this);
    }

    public void addLegacyChunkEntities(List<class_1297> entities, class_1923 forChunk) {
        this.addEntityChunk(entities, forChunk, true);
    }

    public void addEntityChunkEntities(List<class_1297> entities, class_1923 forChunk) {
        this.addEntityChunk(entities, forChunk, true);
    }

    public void addWorldGenChunkEntities(List<class_1297> entities, class_1923 forChunk) {
        this.addEntityChunk(entities, forChunk, false);
    }

    protected void addRecursivelySafe(class_1297 root, boolean fromDisk) {
        if (!this.addEntity(root, fromDisk, true)) {
            root.method_5848();
            return;
        }
        for (class_1297 passenger : root.method_5685()) {
            this.addRecursivelySafe(passenger, fromDisk);
        }
    }

    protected void addEntityChunk(List<class_1297> entities, class_1923 forChunk, boolean fromDisk) {
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            class_1297 entity = entities.get(i);
            if (entity.method_5765()) continue;
            if (forChunk != null && !entity.method_31476().equals((Object)forChunk)) {
                LOGGER.warn("Root entity " + String.valueOf(entity) + " is outside of serialized chunk " + String.valueOf(forChunk));
                continue;
            }
            class_243 rootPosition = entity.method_73189();
            for (class_1297 passenger : entity.method_5736()) {
                if (forChunk == null || passenger.method_31476().equals((Object)forChunk)) continue;
                passenger.method_23327(rootPosition.field_1352, rootPosition.field_1351, rootPosition.field_1350);
            }
            this.addRecursivelySafe(entity, fromDisk);
        }
    }

    public boolean addNewEntity(class_1297 entity) {
        return this.addNewEntity(entity, true);
    }

    public boolean addNewEntity(class_1297 entity, boolean event) {
        return this.addEntity(entity, false, event);
    }

    public static class_5584 getEntityStatus(class_1297 entity) {
        if (entity.method_31747()) {
            return class_5584.field_27291;
        }
        class_3194 entityStatus = ((ChunkSystemEntity)entity).moonrise$getChunkStatus();
        return class_5584.method_31884((class_3194)(entityStatus == null ? class_3194.field_19334 : entityStatus));
    }

    protected boolean addEntity(class_1297 entity, boolean fromDisk, boolean event) {
        class_2338 pos = entity.method_24515();
        int sectionX = pos.method_10263() >> 4;
        int sectionY = class_3532.method_15340((int)(pos.method_10264() >> 4), (int)WorldUtil.getMinSection(this.world), (int)WorldUtil.getMaxSection(this.world));
        int sectionZ = pos.method_10260() >> 4;
        this.checkThread(sectionX, sectionZ, "Cannot add entity off-main thread");
        if (entity.method_31481()) {
            LOGGER.warn("Refusing to add removed entity: " + String.valueOf(entity));
            return false;
        }
        if (((ChunkSystemEntity)entity).moonrise$isUpdatingSectionStatus()) {
            LOGGER.warn("Entity " + String.valueOf(entity) + " is currently prevented from being added/removed to world since it is processing section status updates", new Throwable());
            return false;
        }
        if (!this.screenEntity(entity, fromDisk, event)) {
            return false;
        }
        class_1297 currentlyMapped = this.entityById.putIfAbsent(entity.method_5628(), entity);
        if (currentlyMapped != null) {
            LOGGER.warn("Entity id already exists: " + entity.method_5628() + ", mapped to " + String.valueOf(currentlyMapped) + ", can't add " + String.valueOf(entity));
            return false;
        }
        currentlyMapped = this.entityByUUID.putIfAbsent(entity.method_5667(), entity);
        if (currentlyMapped != null) {
            this.entityById.remove(entity.method_5628(), entity);
            LOGGER.warn("Entity uuid already exists: " + String.valueOf(entity.method_5667()) + ", mapped to " + String.valueOf(currentlyMapped) + ", can't add " + String.valueOf(entity));
            return false;
        }
        ((ChunkSystemEntity)entity).moonrise$setSectionX(sectionX);
        ((ChunkSystemEntity)entity).moonrise$setSectionY(sectionY);
        ((ChunkSystemEntity)entity).moonrise$setSectionZ(sectionZ);
        ChunkEntitySlices slices = this.getOrCreateChunk(sectionX, sectionZ);
        if (!slices.addEntity(entity, sectionY)) {
            LOGGER.warn("Entity " + String.valueOf(entity) + " added to world '" + WorldUtil.getWorldName(this.world) + "', but was already contained in entity chunk (" + sectionX + "," + sectionZ + ")");
        }
        entity.method_31744((class_5569)new EntityCallback(entity));
        this.addEntityCallback(entity);
        this.entityStatusChange(entity, slices, class_5584.field_27289, EntityLookup.getEntityStatus(entity), false, !fromDisk, false);
        return true;
    }

    public boolean canRemoveEntity(class_1297 entity) {
        int sectionZ;
        if (((ChunkSystemEntity)entity).moonrise$isUpdatingSectionStatus()) {
            return false;
        }
        int sectionX = ((ChunkSystemEntity)entity).moonrise$getSectionX();
        ChunkEntitySlices slices = this.getChunk(sectionX, sectionZ = ((ChunkSystemEntity)entity).moonrise$getSectionZ());
        return slices == null || !slices.isPreventingStatusUpdates();
    }

    protected void removeEntity(class_1297 entity) {
        int sectionX = ((ChunkSystemEntity)entity).moonrise$getSectionX();
        int sectionY = ((ChunkSystemEntity)entity).moonrise$getSectionY();
        int sectionZ = ((ChunkSystemEntity)entity).moonrise$getSectionZ();
        this.checkThread(sectionX, sectionZ, "Cannot remove entity off-main");
        if (!entity.method_31481()) {
            throw new IllegalStateException("Only call Entity#setRemoved to remove an entity");
        }
        ChunkEntitySlices slices = this.getChunk(sectionX, sectionZ);
        if (slices == null) {
            LOGGER.warn("Cannot remove entity " + String.valueOf(entity) + " from null entity slices (" + sectionX + "," + sectionZ + ")");
        } else {
            if (slices.isPreventingStatusUpdates()) {
                throw new IllegalStateException("Attempting to remove entity " + String.valueOf(entity) + " from entity slices (" + sectionX + "," + sectionZ + ") that is receiving status updates");
            }
            if (!slices.removeEntity(entity, sectionY)) {
                LOGGER.warn("Failed to remove entity " + String.valueOf(entity) + " from entity slices (" + sectionX + "," + sectionZ + ")");
            }
        }
        ((ChunkSystemEntity)entity).moonrise$setSectionX(Integer.MIN_VALUE);
        ((ChunkSystemEntity)entity).moonrise$setSectionY(Integer.MIN_VALUE);
        ((ChunkSystemEntity)entity).moonrise$setSectionZ(Integer.MIN_VALUE);
        class_1297 currentlyMapped = this.entityById.remove(entity.method_5628(), entity);
        if (currentlyMapped != entity) {
            LOGGER.warn("Failed to remove entity " + String.valueOf(entity) + " by id, current entity mapped: " + String.valueOf(currentlyMapped));
        }
        class_1297[] currentlyMappedArr = new class_1297[1];
        this.entityByUUID.compute(entity.method_5667(), (keyInMap, valueInMap) -> {
            currentlyMappedArr[0] = valueInMap;
            if (valueInMap != entity) {
                return valueInMap;
            }
            return null;
        });
        if (currentlyMappedArr[0] != entity) {
            LOGGER.warn("Failed to remove entity " + String.valueOf(entity) + " by uuid, current entity mapped: " + String.valueOf(currentlyMappedArr[0]));
        }
        if (slices != null && slices.isEmpty()) {
            this.onEmptySlices(sectionX, sectionZ);
        }
    }

    protected ChunkEntitySlices moveEntity(class_1297 entity) {
        this.checkThread(entity, "Cannot move entity off-main");
        int sectionX = ((ChunkSystemEntity)entity).moonrise$getSectionX();
        int sectionY = ((ChunkSystemEntity)entity).moonrise$getSectionY();
        int sectionZ = ((ChunkSystemEntity)entity).moonrise$getSectionZ();
        class_2338 newPos = entity.method_24515();
        int newSectionX = newPos.method_10263() >> 4;
        int newSectionY = class_3532.method_15340((int)(newPos.method_10264() >> 4), (int)WorldUtil.getMinSection(this.world), (int)WorldUtil.getMaxSection(this.world));
        int newSectionZ = newPos.method_10260() >> 4;
        if (newSectionX == sectionX && newSectionY == sectionY && newSectionZ == sectionZ) {
            return null;
        }
        this.checkThread(newSectionX, newSectionZ, "Cannot move entity off-main");
        this.checkThread(sectionX, sectionZ, "Cannot move entity off-main");
        ChunkEntitySlices old = this.getChunk(sectionX, sectionZ);
        ChunkEntitySlices slices = this.getOrCreateChunk(newSectionX, newSectionZ);
        if (!old.removeEntity(entity, sectionY)) {
            LOGGER.warn("Could not remove entity " + String.valueOf(entity) + " from its old chunk section (" + sectionX + "," + sectionY + "," + sectionZ + ") since it was not contained in the section");
        }
        if (!slices.addEntity(entity, newSectionY)) {
            LOGGER.warn("Could not add entity " + String.valueOf(entity) + " to its new chunk section (" + newSectionX + "," + newSectionY + "," + newSectionZ + ") as it is already contained in the section");
        }
        ((ChunkSystemEntity)entity).moonrise$setSectionX(newSectionX);
        ((ChunkSystemEntity)entity).moonrise$setSectionY(newSectionY);
        ((ChunkSystemEntity)entity).moonrise$setSectionZ(newSectionZ);
        if (old.isEmpty()) {
            this.onEmptySlices(sectionX, sectionZ);
        }
        this.entitySectionChangeCallback(entity, sectionX, sectionY, sectionZ, newSectionX, newSectionY, newSectionZ);
        return slices;
    }

    public void getEntities(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate) {
        int minChunkX = class_3532.method_15357((double)box.field_1323) - 2 >> 4;
        int minChunkZ = class_3532.method_15357((double)box.field_1321) - 2 >> 4;
        int maxChunkX = class_3532.method_15357((double)box.field_1320) + 2 >> 4;
        int maxChunkZ = class_3532.method_15357((double)box.field_1324) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.method_14014(class_3194.field_44855)) continue;
                        chunk.getEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getHardCollidingEntities(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate) {
        int minChunkX = class_3532.method_15357((double)box.field_1323) - 2 >> 4;
        int minChunkZ = class_3532.method_15357((double)box.field_1321) - 2 >> 4;
        int maxChunkX = class_3532.method_15357((double)box.field_1320) + 2 >> 4;
        int maxChunkZ = class_3532.method_15357((double)box.field_1324) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.method_14014(class_3194.field_44855)) continue;
                        chunk.getHardCollidingEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends class_1297> void getEntities(class_1299<?> type, class_238 box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = class_3532.method_15357((double)box.field_1323) - 2 >> 4;
        int minChunkZ = class_3532.method_15357((double)box.field_1321) - 2 >> 4;
        int maxChunkX = class_3532.method_15357((double)box.field_1320) + 2 >> 4;
        int maxChunkZ = class_3532.method_15357((double)box.field_1324) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.method_14014(class_3194.field_44855)) continue;
                        chunk.getEntities(type, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends class_1297> void getEntities(Class<? extends T> clazz, class_1297 except, class_238 box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = class_3532.method_15357((double)box.field_1323) - 2 >> 4;
        int minChunkZ = class_3532.method_15357((double)box.field_1321) - 2 >> 4;
        int maxChunkX = class_3532.method_15357((double)box.field_1320) + 2 >> 4;
        int maxChunkZ = class_3532.method_15357((double)box.field_1324) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.method_14014(class_3194.field_44855)) continue;
                        chunk.getEntities(clazz, except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getEntities(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate, int maxCount) {
        int minChunkX = class_3532.method_15357((double)box.field_1323) - 2 >> 4;
        int minChunkZ = class_3532.method_15357((double)box.field_1321) - 2 >> 4;
        int maxChunkX = class_3532.method_15357((double)box.field_1320) + 2 >> 4;
        int maxChunkZ = class_3532.method_15357((double)box.field_1324) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.method_14014(class_3194.field_44855) || !chunk.getEntities(except, box, into, predicate, maxCount)) continue;
                        return;
                    }
                }
            }
        }
    }

    public <T extends class_1297> void getEntities(class_1299<?> type, class_238 box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        int minChunkX = class_3532.method_15357((double)box.field_1323) - 2 >> 4;
        int minChunkZ = class_3532.method_15357((double)box.field_1321) - 2 >> 4;
        int maxChunkX = class_3532.method_15357((double)box.field_1320) + 2 >> 4;
        int maxChunkZ = class_3532.method_15357((double)box.field_1324) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.method_14014(class_3194.field_44855) || !chunk.getEntities(type, box, into, predicate, maxCount)) continue;
                        return;
                    }
                }
            }
        }
    }

    public <T extends class_1297> void getEntities(Class<? extends T> clazz, class_1297 except, class_238 box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        int minChunkX = class_3532.method_15357((double)box.field_1323) - 2 >> 4;
        int minChunkZ = class_3532.method_15357((double)box.field_1321) - 2 >> 4;
        int maxChunkX = class_3532.method_15357((double)box.field_1320) + 2 >> 4;
        int maxChunkZ = class_3532.method_15357((double)box.field_1324) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.method_14014(class_3194.field_44855) || !chunk.getEntities(clazz, except, box, into, predicate, maxCount)) continue;
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entitySectionLoad(int chunkX, int chunkZ, ChunkEntitySlices slices) {
        this.checkThread(chunkX, chunkZ, "Cannot load in entity section off-main");
        EntityLookup entityLookup = this;
        synchronized (entityLookup) {
            ChunkEntitySlices curr = this.getChunk(chunkX, chunkZ);
            if (curr != null) {
                this.removeChunk(chunkX, chunkZ);
                curr.mergeInto(slices);
                this.addChunk(chunkX, chunkZ, slices);
            } else {
                this.addChunk(chunkX, chunkZ, slices);
            }
        }
    }

    public void entitySectionUnload(int chunkX, int chunkZ) {
        this.checkThread(chunkX, chunkZ, "Cannot unload entity section off-main");
        this.removeChunk(chunkX, chunkZ);
    }

    public ChunkEntitySlices getChunk(int chunkX, int chunkZ) {
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null) {
            return null;
        }
        return region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5);
    }

    public ChunkEntitySlices getOrCreateChunk(int chunkX, int chunkZ) {
        ChunkEntitySlices ret;
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null || (ret = region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5)) == null) {
            return this.createEntityChunk(chunkX, chunkZ, true);
        }
        return ret;
    }

    public ChunkSlicesRegion getRegion(int regionX, int regionZ) {
        long key = CoordinateUtils.getChunkKey(regionX, regionZ);
        return this.regions.get(key);
    }

    protected synchronized void removeChunk(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = this.regions.get(key);
        int remaining = region.remove(relIndex);
        if (remaining == 0) {
            this.regions.remove(key);
        }
    }

    public synchronized void addChunk(int chunkX, int chunkZ, ChunkEntitySlices slices) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = this.regions.get(key);
        if (region != null) {
            region.add(relIndex, slices);
        } else {
            region = new ChunkSlicesRegion();
            region.add(relIndex, slices);
            this.regions.put(key, region);
        }
    }

    protected static final class ArrayIterable<T>
    implements Iterable<T> {
        private final T[] array;
        private final int off;
        private final int length;

        public ArrayIterable(T[] array, int off, int length) {
            this.array = array;
            this.off = off;
            this.length = length;
            if (length > array.length) {
                throw new IllegalArgumentException("Length must be no greater-than the array length");
            }
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayIterator<T>(this.array, this.off, this.length);
        }

        protected static final class ArrayIterator<T>
        implements Iterator<T> {
            private final T[] array;
            private int off;
            private final int length;

            public ArrayIterator(T[] array, int off, int length) {
                this.array = array;
                this.off = off;
                this.length = length;
            }

            @Override
            public boolean hasNext() {
                return this.off < this.length;
            }

            @Override
            public T next() {
                if (this.off >= this.length) {
                    throw new NoSuchElementException();
                }
                return this.array[this.off++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected final class EntityCallback
    implements class_5569 {
        public final class_1297 entity;

        public EntityCallback(class_1297 entity) {
            this.entity = entity;
        }

        public void method_31749() {
            class_1297 entity = this.entity;
            class_5584 oldVisibility = EntityLookup.getEntityStatus(entity);
            ChunkEntitySlices newSlices = EntityLookup.this.moveEntity(this.entity);
            if (newSlices == null) {
                return;
            }
            class_5584 newVisibility = EntityLookup.getEntityStatus(entity);
            EntityLookup.this.entityStatusChange(entity, newSlices, oldVisibility, newVisibility, true, false, false);
        }

        public void method_31750(class_1297.class_5529 reason) {
            class_1297 entity = this.entity;
            EntityLookup.this.checkThread(entity, "Cannot remove entity off-main");
            class_5584 tickingState = EntityLookup.getEntityStatus(entity);
            EntityLookup.this.removeEntity(entity);
            EntityLookup.this.entityStatusChange(entity, null, tickingState, class_5584.field_27289, false, false, reason.method_31486());
            EntityLookup.this.removeEntityCallback(entity);
            this.entity.method_31744((class_5569)NoOpCallback.INSTANCE);
        }
    }

    public static final class ChunkSlicesRegion {
        private final ChunkEntitySlices[] slices = new ChunkEntitySlices[1024];
        private int sliceCount;

        public ChunkEntitySlices get(int index) {
            return this.slices[index];
        }

        public int remove(int index) {
            ChunkEntitySlices slices = this.slices[index];
            if (slices == null) {
                throw new IllegalStateException();
            }
            this.slices[index] = null;
            return --this.sliceCount;
        }

        public void add(int index, ChunkEntitySlices slices) {
            ChunkEntitySlices curr = this.slices[index];
            if (curr != null) {
                throw new IllegalStateException();
            }
            this.slices[index] = slices;
            ++this.sliceCount;
        }
    }

    protected static final class NoOpCallback
    implements class_5569 {
        public static final NoOpCallback INSTANCE = new NoOpCallback();

        protected NoOpCallback() {
        }

        public void method_31749() {
        }

        public void method_31750(class_1297.class_5529 reason) {
        }
    }
}

