/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.list;

import it.unimi.dsi.fastutil.shorts.Short2ShortOpenHashMap;
import java.util.Arrays;

public final class ShortList {
    private final Short2ShortOpenHashMap map = new Short2ShortOpenHashMap();
    private static final short[] EMPTY_LIST = new short[0];
    private short[] byIndex;
    private short count;

    public ShortList() {
        this.map.defaultReturnValue((short)Short.MIN_VALUE);
        this.byIndex = EMPTY_LIST;
    }

    public int size() {
        return this.count;
    }

    public short getRaw(int index) {
        return this.byIndex[index];
    }

    public void setMinCapacity(int len) {
        short[] byIndex = this.byIndex;
        if (byIndex.length < len) {
            this.byIndex = Arrays.copyOf(byIndex, len);
        }
    }

    public boolean add(short value) {
        short count = this.count;
        short currIndex = this.map.putIfAbsent(value, count);
        if (currIndex != Short.MIN_VALUE) {
            return false;
        }
        short[] list = this.byIndex;
        if (list.length == count) {
            list = this.byIndex = Arrays.copyOf(list, (int)Math.max(4L, (long)count * 2L));
        }
        list[count] = value;
        this.count = (short)(count + 1);
        return true;
    }

    public boolean remove(short value) {
        short index = this.map.remove(value);
        if (index == Short.MIN_VALUE) {
            return false;
        }
        short endIndex = this.count = (short)(this.count - 1);
        short end = this.byIndex[endIndex];
        if (index != endIndex) {
            this.map.put(end, index);
        }
        this.byIndex[index] = end;
        this.byIndex[endIndex] = 0;
        return true;
    }

    public void clear() {
        this.count = 0;
        this.map.clear();
    }
}

