/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.scheduler;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.list.COWArrayList;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;

public final class ScheduledTaskThreadPool {
    public static final long DEADLINE_NOT_SET = Long.MIN_VALUE;
    private final ThreadFactory threadFactory;
    private final COWArrayList<TickThreadRunner> coreThreads = new COWArrayList<TickThreadRunner>(TickThreadRunner.class);
    private final COWArrayList<TickThreadRunner> aliveThreads = new COWArrayList<TickThreadRunner>(TickThreadRunner.class);
    private boolean shutdown;

    public ScheduledTaskThreadPool(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        if (threadFactory == null) {
            throw new NullPointerException("Null thread factory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        TickThreadRunner[] tickThreadRunnerArray = this;
        synchronized (this) {
            this.shutdown = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (TickThreadRunner tickThreadRunner : this.coreThreads.getArray()) {
            }
            return;
        }
    }

    public boolean join(long msToWait) {
        try {
            return this.join(msToWait, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean joinInterruptable(long msToWait) throws InterruptedException {
        return this.join(msToWait, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean join(long msToWait, boolean interruptable) throws InterruptedException {
        long nsToWait = msToWait * 1000000L;
        long start = System.nanoTime();
        long deadline = start + nsToWait;
        boolean interrupted = false;
        try {
            for (TickThreadRunner runner : this.aliveThreads.getArray()) {
                Thread thread = null;
                while (thread.isAlive()) {
                    long current = System.nanoTime();
                    if (current - deadline >= 0L && msToWait > 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        thread.join(msToWait <= 0L ? 0L : Math.max(1L, (deadline - current) / 1000000L));
                    }
                    catch (InterruptedException ex) {
                        if (interruptable) {
                            throw ex;
                        }
                        interrupted = true;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void schedule(SchedulableTick tick) {
    }

    public void notifyTasks(SchedulableTick tick) {
    }

    public boolean cancel(SchedulableTick tick) {
        throw new UnsupportedOperationException();
    }

    private static final class TickThreadRunner
    implements Runnable {
        private final ScheduledTaskThreadPool scheduler;
        private final long id;

        public TickThreadRunner(ScheduledTaskThreadPool scheduler, long id) {
            this.scheduler = scheduler;
            this.id = id;
        }

        private void begin() {
        }

        private void doRun() {
            while (this.mainLoop()) {
            }
        }

        private boolean mainLoop() {
            throw new UnsupportedOperationException();
        }

        private void die() {
        }

        @Override
        public void run() {
            try {
                this.begin();
                this.doRun();
            }
            finally {
                this.die();
            }
        }
    }

    public static abstract class SchedulableTick {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        public final long id = ID_GENERATOR.getAndIncrement();
        private long scheduledStart = Long.MIN_VALUE;
        private static final int STATE_UNSCHEDULED = 1;
        private volatile int state = 1;
        private static final VarHandle STATE_HANDLE = ConcurrentUtil.getVarHandle(SchedulableTick.class, "state", Integer.TYPE);

        private int getStateVolatile() {
            return STATE_HANDLE.getVolatile(this);
        }

        private void setStateVolatile(int value) {
            STATE_HANDLE.setVolatile(this, value);
        }

        private int compareAndExchangeStateVolatile(int expect, int update) {
            return STATE_HANDLE.compareAndExchange(this, expect, update);
        }

        protected final long getScheduledStart() {
            return this.scheduledStart;
        }

        protected final void setScheduledStart(long value) {
            this.scheduledStart = value;
        }

        public abstract boolean runTick();

        public abstract boolean hasTasks();

        public abstract boolean runTasks(BooleanSupplier var1);

        public String toString() {
            return "SchedulableTick:{class=" + this.getClass().getName() + ",state=" + this.state + ",}";
        }
    }
}

