/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.scheduler;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.set.LinkedSortedSet;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.TimeUtil;
import java.lang.invoke.VarHandle;
import java.util.BitSet;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;

@Deprecated
public final class SchedulerThreadPool {
    public static final long DEADLINE_NOT_SET = Long.MIN_VALUE;
    private static final Comparator<SchedulableTick> TICK_COMPARATOR_BY_TIME = (t1, t2) -> {
        int timeCompare = TimeUtil.compareTimes(t1.scheduledStart, t2.scheduledStart);
        if (timeCompare != 0) {
            return timeCompare;
        }
        return Long.signum(t1.id - t2.id);
    };
    private final TickThreadRunner[] runners;
    private final Thread[] threads;
    private final LinkedSortedSet<SchedulableTick> awaiting = new LinkedSortedSet<SchedulableTick>(TICK_COMPARATOR_BY_TIME);
    private final PriorityQueue<SchedulableTick> queued = new PriorityQueue<SchedulableTick>(TICK_COMPARATOR_BY_TIME);
    private final BitSet idleThreads;
    private final Object scheduleLock = new Object();
    private volatile boolean halted;

    public SchedulerThreadPool(int threads, ThreadFactory threadFactory) {
        BitSet idleThreads = new BitSet(threads);
        for (int i = 0; i < threads; ++i) {
            idleThreads.set(i);
        }
        this.idleThreads = idleThreads;
        TickThreadRunner[] runners = new TickThreadRunner[threads];
        Thread[] t = new Thread[threads];
        for (int i = 0; i < threads; ++i) {
            runners[i] = new TickThreadRunner(i, this);
            t[i] = threadFactory.newThread(runners[i]);
        }
        this.threads = t;
        this.runners = runners;
    }

    public void start() {
        for (Thread thread : this.threads) {
            thread.start();
        }
    }

    public boolean halt(boolean sync, long maxWaitNS) {
        this.halted = true;
        for (Thread thread : this.threads) {
            LockSupport.unpark(thread);
        }
        long time = System.nanoTime();
        if (sync) {
            long failures = 9L;
            while (true) {
                boolean allDead = true;
                for (Thread thread : this.threads) {
                    if (!thread.isAlive()) continue;
                    allDead = false;
                    break;
                }
                if (allDead) {
                    return true;
                }
                if (System.nanoTime() - time >= maxWaitNS) {
                    return false;
                }
                failures = ConcurrentUtil.linearLongBackoff(failures, 500000L, 50000000L);
            }
        }
        return true;
    }

    public Thread[] getThreads() {
        return (Thread[])this.threads.clone();
    }

    private void insertFresh(SchedulableTick task) {
        TickThreadRunner[] runners = this.runners;
        int firstIdleThread = this.idleThreads.nextSetBit(0);
        if (firstIdleThread != -1) {
            this.idleThreads.clear(firstIdleThread);
            TickThreadRunner runner = runners[firstIdleThread];
            task.awaitingLink = this.awaiting.addLast(task);
            runner.acceptTask(task);
            return;
        }
        SchedulableTick last = this.awaiting.last();
        if (last != null && TICK_COMPARATOR_BY_TIME.compare(task, last) < 0) {
            this.awaiting.pollLast();
            last.awaitingLink = null;
            task.awaitingLink = this.awaiting.addLast(task);
            this.queued.add(last);
            TickThreadRunner runner = last.ownedBy;
            runner.replaceTask(task);
            return;
        }
        this.queued.add(task);
    }

    private void takeTask(TickThreadRunner runner, SchedulableTick tick) {
        if (!this.awaiting.remove(tick.awaitingLink)) {
            throw new IllegalStateException("Task is not in awaiting");
        }
        tick.awaitingLink = null;
    }

    private SchedulableTick returnTask(TickThreadRunner runner, SchedulableTick reschedule) {
        SchedulableTick ret;
        if (reschedule != null) {
            this.queued.add(reschedule);
        }
        if ((ret = this.queued.poll()) == null) {
            this.idleThreads.set(runner.id);
        } else {
            ret.awaitingLink = this.awaiting.addLast(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SchedulableTick task) {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (!task.tryMarkScheduled()) {
                throw new IllegalStateException("Task " + String.valueOf(task) + " is already scheduled or cancelled");
            }
            task.schedulerOwnedBy = this;
            this.insertFresh(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTickStartToMax(SchedulableTick task, long newStart) {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (TimeUtil.compareTimes(newStart, task.getScheduledStart()) <= 0) {
                return false;
            }
            if (this.queued.remove(task)) {
                task.setScheduledStart(newStart);
                this.queued.add(task);
                return true;
            }
            if (task.awaitingLink != null) {
                this.awaiting.remove(task.awaitingLink);
                task.awaitingLink = null;
                task.setScheduledStart(newStart);
                this.queued.add(task);
                TickThreadRunner runner = task.ownedBy;
                SchedulableTick replace = this.queued.poll();
                if (replace != task) {
                    runner.replaceTask(replace);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean tryRetire(SchedulableTick task) {
        if (task.schedulerOwnedBy != this) {
            return null;
        }
        Object object = this.scheduleLock;
        synchronized (object) {
            if (this.queued.remove(task)) {
                return Boolean.TRUE;
            }
            if (task.awaitingLink != null) {
                this.awaiting.remove(task.awaitingLink);
                task.awaitingLink = null;
                TickThreadRunner runner = task.ownedBy;
                SchedulableTick replace = this.queued.poll();
                if (replace == null) {
                    this.idleThreads.set(runner.id);
                    runner.forceIdle();
                } else {
                    runner.replaceTask(replace);
                }
                return Boolean.TRUE;
            }
            return task.tryMarkCancelled() ? Boolean.FALSE : null;
        }
    }

    public void notifyTasks(SchedulableTick task) {
    }

    private static final class TickThreadRunner
    implements Runnable {
        private static final int STATE_IDLE = 0;
        private static final int STATE_AWAITING_TICK = 1;
        private static final int STATE_EXECUTING_TICK = 2;
        public final int id;
        public final SchedulerThreadPool scheduler;
        private volatile Thread thread;
        private volatile TickThreadRunnerState state = new TickThreadRunnerState(null, 0);
        private static final VarHandle STATE_HANDLE = ConcurrentUtil.getVarHandle(TickThreadRunner.class, "state", TickThreadRunnerState.class);

        private void setStatePlain(TickThreadRunnerState state) {
            STATE_HANDLE.set(this, state);
        }

        private void setStateOpaque(TickThreadRunnerState state) {
            STATE_HANDLE.setOpaque(this, state);
        }

        private void setStateVolatile(TickThreadRunnerState state) {
            STATE_HANDLE.setVolatile(this, state);
        }

        public TickThreadRunner(int id, SchedulerThreadPool scheduler) {
            this.id = id;
            this.scheduler = scheduler;
        }

        private Thread getRunnerThread() {
            return this.thread;
        }

        private void acceptTask(SchedulableTick task) {
            if (task.ownedBy != null) {
                throw new IllegalStateException("Already owned by another runner");
            }
            task.ownedBy = this;
            TickThreadRunnerState state = this.state;
            if (state.state != 0) {
                throw new IllegalStateException("Cannot accept task in state " + String.valueOf(state));
            }
            this.setStateVolatile(new TickThreadRunnerState(task, 1));
            LockSupport.unpark(this.getRunnerThread());
        }

        private void replaceTask(SchedulableTick task) {
            TickThreadRunnerState state = this.state;
            if (state.state != 1) {
                throw new IllegalStateException("Cannot replace task in state " + String.valueOf(state));
            }
            if (task.ownedBy != null) {
                throw new IllegalStateException("Already owned by another runner");
            }
            task.ownedBy = this;
            state.stateTarget.ownedBy = null;
            this.setStateVolatile(new TickThreadRunnerState(task, 1));
            LockSupport.unpark(this.getRunnerThread());
        }

        private void forceIdle() {
            TickThreadRunnerState state = this.state;
            if (state.state != 1) {
                throw new IllegalStateException("Cannot replace task in state " + String.valueOf(state));
            }
            state.stateTarget.ownedBy = null;
            this.setStateOpaque(new TickThreadRunnerState(null, 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean takeTask(TickThreadRunnerState state, SchedulableTick task) {
            Object object = this.scheduler.scheduleLock;
            synchronized (object) {
                if (this.state != state) {
                    return false;
                }
                this.setStatePlain(new TickThreadRunnerState(task, 2));
                this.scheduler.takeTask(this, task);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void returnTask(SchedulableTick task, boolean reschedule) {
            Object object = this.scheduler.scheduleLock;
            synchronized (object) {
                task.ownedBy = null;
                SchedulableTick newWait = this.scheduler.returnTask(this, reschedule && task.isScheduled() ? task : null);
                if (newWait == null) {
                    this.setStatePlain(new TickThreadRunnerState(null, 0));
                } else {
                    if (newWait.ownedBy != null) {
                        throw new IllegalStateException("Already owned by another runner");
                    }
                    newWait.ownedBy = this;
                    this.setStatePlain(new TickThreadRunnerState(newWait, 1));
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            this.thread = Thread.currentThread();
            block5: while (true) {
                startState = this.state;
                startStateType = startState.state;
                startStateTask = startState.stateTarget;
                if (this.scheduler.halted) {
                    return;
                }
                switch (startStateType) {
                    case 0: {
                        do {
                            if (this.state.state != 0) continue block5;
                            Thread.interrupted();
                            LockSupport.park();
                        } while (!this.scheduler.halted);
                        return;
                    }
                    case 1: {
                        deadline = startStateTask.getScheduledStart();
                        do {
                            if (this.state != startState) continue block5;
                            Thread.interrupted();
                            diff = deadline - System.nanoTime();
                            if (diff <= 0L) ** GOTO lbl28
                            LockSupport.parkNanos(startState, diff);
                        } while (!this.scheduler.halted);
                        return;
lbl28:
                        // 1 sources

                        if (!this.takeTask(startState, startStateTask)) continue block5;
                        reschedule = startStateTask.runTick();
                        this.returnTask(startStateTask, reschedule);
                        continue block5;
                    }
                    case 2: {
                        throw new IllegalStateException("Tick execution must be set by runner thread, not by any other thread");
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown state: " + String.valueOf(startState));
        }

        private record TickThreadRunnerState(SchedulableTick stateTarget, int state) {
        }
    }

    @Deprecated
    public static abstract class SchedulableTick {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        public final long id = ID_GENERATOR.getAndIncrement();
        private static final int SCHEDULE_STATE_NOT_SCHEDULED = 0;
        private static final int SCHEDULE_STATE_SCHEDULED = 1;
        private static final int SCHEDULE_STATE_CANCELLED = 2;
        private final AtomicInteger scheduled = new AtomicInteger();
        private SchedulerThreadPool schedulerOwnedBy;
        private long scheduledStart = Long.MIN_VALUE;
        private TickThreadRunner ownedBy;
        private LinkedSortedSet.Link<SchedulableTick> awaitingLink;

        private boolean tryMarkScheduled() {
            return this.scheduled.compareAndSet(0, 1);
        }

        private boolean tryMarkCancelled() {
            return this.scheduled.compareAndSet(1, 2);
        }

        private boolean isScheduled() {
            return this.scheduled.get() == 1;
        }

        protected final long getScheduledStart() {
            return this.scheduledStart;
        }

        protected final void setScheduledStart(long value) {
            this.scheduledStart = value;
        }

        public abstract boolean runTick();

        public abstract boolean hasTasks();

        public abstract Boolean runTasks(BooleanSupplier var1);

        public String toString() {
            return "SchedulableTick:{class=" + this.getClass().getName() + ",scheduled_state=" + this.scheduled.get() + ",}";
        }
    }
}

