/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.collection;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CollectionTypeAdapter
extends TypeAdapter<Collection<Object>, List<Object>> {
    public static final CollectionTypeAdapter INSTANCE = new CollectionTypeAdapter();

    @Override
    public Collection<Object> deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Collection field must specify generic type");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type elementType = parameterizedType.getActualTypeArguments()[0];
        if (input instanceof Collection) {
            Collection collection = (Collection)input;
            ArrayList<Object> ret = new ArrayList<Object>(collection.size());
            for (Object v : collection) {
                ret.add(registry.deserialize(v, elementType));
            }
            return ret;
        }
        throw new IllegalArgumentException("Not a collection type: " + String.valueOf(input.getClass()));
    }

    @Override
    public List<Object> serialize(TypeAdapterRegistry registry, Collection<Object> value, Type type) {
        Class<?> clazz;
        ArrayList<Object> ret = new ArrayList<Object>(value.size());
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = parameterizedType.getActualTypeArguments()[0];
        } else {
            clazz = null;
        }
        Class<?> elementType = clazz;
        for (Object v : value) {
            ret.add(registry.serialize(v, elementType == null ? v.getClass() : elementType));
        }
        return ret;
    }
}

