/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={RegionFile.ChunkBuffer.class})
abstract class ChunkBufferMixin
extends ByteArrayOutputStream
implements ChunkSystemChunkBuffer {
    @Shadow
    @Final
    private ChunkPos pos;
    @Unique
    private boolean writeOnClose = true;

    ChunkBufferMixin() {
    }

    @Override
    public final boolean moonrise$getWriteOnClose() {
        return this.writeOnClose;
    }

    @Override
    public final void moonrise$setWriteOnClose(boolean value) {
        this.writeOnClose = value;
    }

    @Override
    public final void moonrise$write(RegionFile regionFile) throws IOException {
        regionFile.write(this.pos, ByteBuffer.wrap(this.buf, 0, this.count));
    }

    @Redirect(method={"close"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/RegionFile;write(Lnet/minecraft/world/level/ChunkPos;Ljava/nio/ByteBuffer;)V"))
    private void redirectClose(RegionFile instance, ChunkPos chunkPos, ByteBuffer byteBuffer) throws IOException {
        if (this.writeOnClose) {
            instance.write(chunkPos, byteBuffer);
        }
    }
}

