/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemChunkMap;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
abstract class ChunkMapMixin
extends SimpleRegionStorage
implements ChunkSystemChunkMap,
ChunkHolder.PlayerProvider,
GeneratingChunkMap {
    @Shadow
    @Final
    public ServerLevel level;
    @Shadow
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap;
    @Shadow
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunkMap;
    @Shadow
    private ChunkTaskDispatcher worldgenTaskDispatcher;
    @Shadow
    private ChunkTaskDispatcher lightTaskDispatcher;
    @Shadow
    private int serverViewDistance;
    @Shadow
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> pendingUnloads;
    @Shadow
    private List<ChunkGenerationTask> pendingGenerationTasks;
    @Shadow
    private Queue<Runnable> unloadQueue;
    @Shadow
    private LongSet chunksToEagerlySave;
    @Shadow
    private AtomicInteger activeChunkWrites;

    public ChunkMapMixin(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, DataFixTypes dataFixType) {
        super(info, folder, fixerUpper, sync, dataFixType);
    }

    @Override
    public final void moonrise$writeFinishCallback(ChunkPos pos) throws IOException {
        this.markChunkDone(pos);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void constructor(ServerLevel p_214836_, LevelStorageSource.LevelStorageAccess p_214837_, DataFixer p_214838_, StructureTemplateManager p_214839_, Executor p_214840_, BlockableEventLoop p_214841_, LightChunkGetter p_214842_, ChunkGenerator p_214843_, ChunkStatusUpdateListener p_214845_, Supplier p_214846_, TicketStorage p_394462_, int p_214847_, boolean p_214848_, CallbackInfo ci) {
        this.updatingChunkMap = null;
        this.visibleChunkMap = null;
        this.pendingUnloads = null;
        this.worldgenTaskDispatcher = null;
        this.lightTaskDispatcher = null;
        this.pendingGenerationTasks = null;
        this.unloadQueue = null;
        this.chunksToEagerlySave = null;
        this.activeChunkWrites = null;
        this.worker = new IOWorker(new RegionStorageInfo(p_214837_.getLevelId(), p_214836_.dimension(), "chunk"), p_214837_.getDimensionPath(p_214836_.dimension()).resolve("region"), p_214848_){

            public boolean isOldChunkAround(ChunkPos chunkPos, int i) {
                throw new UnsupportedOperationException();
            }

            public CompletableFuture<Void> store(ChunkPos chunkPos, @Nullable CompoundTag compoundTag) {
                throw new UnsupportedOperationException();
            }

            public CompletableFuture<Optional<CompoundTag>> loadAsync(ChunkPos chunkPos) {
                CompletableFuture<Optional<CompoundTag>> future = new CompletableFuture<Optional<CompoundTag>>();
                MoonriseRegionFileIO.loadDataAsync(ChunkMapMixin.this.level, chunkPos.x, chunkPos.z, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, (tag, throwable) -> {
                    if (throwable != null) {
                        future.completeExceptionally((Throwable)throwable);
                    } else {
                        future.complete(Optional.ofNullable(tag));
                    }
                }, false);
                return future;
            }

            public CompletableFuture<Void> synchronize(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public CompletableFuture<Void> scanChunk(ChunkPos chunkPos, StreamTagVisitor streamTagVisitor) {
                throw new UnsupportedOperationException();
            }

            public void close() throws IOException {
                throw new UnsupportedOperationException();
            }

            public RegionStorageInfo storageInfo() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Overwrite
    public void setChunkUnsaved(ChunkPos pos) {
    }

    @Overwrite
    public boolean isChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        return ((ChunkSystemServerLevel)this.level).moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ);
    }

    @Overwrite
    public boolean isChunkOnTrackedBorder(ServerPlayer player, int chunkX, int chunkZ) {
        return ((ChunkSystemServerLevel)this.level).moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ, true);
    }

    @Overwrite
    public ChunkHolder getUpdatingChunkIfPresent(long pos) {
        NewChunkHolder holder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Overwrite
    public ChunkHolder getVisibleChunkIfPresent(long pos) {
        NewChunkHolder holder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Overwrite
    public IntSupplier getChunkQueueLevel(long pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder centerChunk, int margin, IntFunction<ChunkStatus> distanceToStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<List<ChunkAccess>>> prepareEntityTickingChunk(ChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public ChunkHolder updateChunkScheduling(long pos, int level, ChunkHolder holder, int newLevel) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void onLevelChange(ChunkPos chunkPos, IntSupplier intSupplier, int i, IntConsumer intConsumer) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    @Overwrite
    public void saveAllChunks(boolean flush) {
        boolean shutdown = ((ChunkSystemServerLevel)this.level).moonrise$isMarkedClosing();
        if (!shutdown) {
            ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(flush, false, false, false);
        } else {
            ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.close(true, true);
        }
    }

    @Overwrite
    public boolean hasWork() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void processUnloads(BooleanSupplier shouldKeepTicking) {
        ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.processUnloads();
        ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.autoSave();
    }

    @Overwrite
    public void saveChunksEagerly(BooleanSupplier hasTime) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void scheduleUnload(long pos, ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean promoteChunkMap() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> scheduleChunkLoad(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public GenerationChunkHolder acquireGeneration(long pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void releaseGeneration(GenerationChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> applyStep(GenerationChunkHolder generationChunkHolder, ChunkStep chunkStep, StaticCache2D<GenerationChunkHolder> staticCache2D) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus chunkStatus, ChunkPos chunkPos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void runGenerationTasks() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void onChunkReadyToSend(ChunkHolder holder, LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public Stream<ChunkHolder> allChunksWithAtLeastStatus(ChunkStatus status) {
        int i = ChunkLevel.byStatus((ChunkStatus)status);
        return ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders().stream().filter(holder -> holder.getTicketLevel() <= i);
    }

    @Overwrite
    public boolean saveChunkIfNeeded(ChunkHolder chunkHolder, long time) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean save(ChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean isExistingChunkFull(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void setServerViewDistance(int watchDistance) {
        int clamped = Mth.clamp((int)watchDistance, (int)2, (int)MoonriseConstants.MAX_VIEW_DISTANCE);
        if (clamped == this.serverViewDistance) {
            return;
        }
        this.serverViewDistance = clamped;
        ((ChunkSystemServerLevel)this.level).moonrise$getPlayerChunkLoader().setLoadDistance(this.serverViewDistance + 1);
    }

    @Overwrite
    public int getPlayerViewDistance(ServerPlayer player) {
        return PlatformHooks.get().getSendViewDistance(player);
    }

    @Overwrite
    public void markChunkPendingToSend(ServerPlayer player, ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public static void dropChunk(ServerPlayer player, ChunkPos pos) {
    }

    @Overwrite
    public void dumpChunks(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"collectSpawningChunks"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectLinkedOpenHashMap;get(J)Ljava/lang/Object;"))
    private <V> V redirectChunkHolderGetForSpawning(Long2ObjectLinkedOpenHashMap<V> instance, long key) {
        return (V)this.getVisibleChunkIfPresent(key);
    }

    @Redirect(method={"method_67499", "lambda$forEachBlockTickingChunk$37"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectLinkedOpenHashMap;get(J)Ljava/lang/Object;"))
    private <V> V redirectChunkHolderGetForBlockTicking(Long2ObjectLinkedOpenHashMap<V> instance, long key) {
        return (V)this.getVisibleChunkIfPresent(key);
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos pos) {
        CompletableFuture<Optional<CompoundTag>> ret = new CompletableFuture<Optional<CompoundTag>>();
        MoonriseRegionFileIO.loadDataAsync(this.level, pos.x, pos.z, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, (data, thr) -> {
            if (thr != null) {
                ret.completeExceptionally((Throwable)thr);
            } else {
                ret.complete(Optional.ofNullable(data));
            }
        }, false);
        return ret;
    }

    public CompletableFuture<Void> write(ChunkPos pos, Supplier<CompoundTag> tag) {
        MoonriseRegionFileIO.scheduleSave(this.level, pos.x, pos.z, tag.get(), MoonriseRegionFileIO.RegionFileType.CHUNK_DATA);
        return null;
    }

    public CompletableFuture<Void> synchronize(boolean flush) {
        try {
            MoonriseRegionFileIO.flush(this.level);
            if (flush) {
                MoonriseRegionFileIO.flushRegionStorages(this.level);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    @Redirect(method={"updatePlayerStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;updateChunkTracking(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void avoidUpdateChunkTrackingInUpdate(ChunkMap instance, ServerPlayer serverPlayer) {
        PlatformHooks.get().addPlayerToDistanceMaps(this.level, serverPlayer);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;updateChunkTracking(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void skipChunkTrackingInTick(ChunkMap instance, ServerPlayer serverPlayer) {
    }

    @Redirect(method={"updatePlayerStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;applyChunkTrackingView(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ChunkTrackingView;)V"))
    private void avoidApplyChunkTrackingViewInUpdate(ChunkMap instance, ServerPlayer serverPlayer, ChunkTrackingView chunkTrackingView) {
        PlatformHooks.get().removePlayerFromDistanceMaps(this.level, serverPlayer);
    }

    @Inject(method={"move"}, at={@At(value="RETURN")})
    private void updateMapsHook(ServerPlayer player, CallbackInfo ci) {
        PlatformHooks.get().updateMaps(this.level, player);
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;updateChunkTracking(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void avoidSetChunkTrackingViewInMove(ChunkMap instance, ServerPlayer serverPlayer) {
    }

    @Overwrite
    public void updateChunkTracking(ServerPlayer player) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void applyChunkTrackingView(ServerPlayer player, ChunkTrackingView chunkFilter) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public List<ServerPlayer> getPlayers(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge) {
        ChunkHolder holder = this.getVisibleChunkIfPresent(chunkPos.toLong());
        if (holder == null) {
            return new ArrayList<ServerPlayer>();
        }
        return ((ChunkSystemChunkHolder)holder).moonrise$getPlayers(onlyOnWatchDistanceEdge);
    }

    @Overwrite
    public void waitForLightBeforeSending(ChunkPos centerPos, int radius) {
    }

    @Overwrite
    public int size() {
        return ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Overwrite
    public void forEachReadyToSendChunk(Consumer<LevelChunk> consumer) {
        for (ChunkHolder holder : ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders()) {
            LevelChunk chunkToSend = holder.getChunkToSend();
            if (chunkToSend == null) continue;
            consumer.accept(chunkToSend);
        }
    }
}

