/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.level.storage.ChunkSystemSectionStorage;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemSimpleRegionStorage;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionStorage.class})
abstract class SectionStorageMixin<R, P>
implements ChunkSystemSectionStorage,
AutoCloseable {
    @Shadow
    private SimpleRegionStorage simpleRegionStorage;
    @Unique
    private RegionFileStorage storage;

    SectionStorageMixin() {
    }

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.storage;
    }

    @Override
    public void moonrise$close() throws IOException {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.storage = ((ChunkSystemSimpleRegionStorage)this.simpleRegionStorage).moonrise$getRegionStorage();
        this.simpleRegionStorage = null;
    }

    @Overwrite
    public final CompletableFuture<Optional<SectionStorage.PackedChunk<P>>> tryRead(ChunkPos pos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    @Overwrite
    public void unpackChunk(ChunkPos chunkPos, SectionStorage.PackedChunk<P> packedChunk) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    @Overwrite
    private void writeChunk(ChunkPos chunkPos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    @Redirect(method={"close"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/SimpleRegionStorage;close()V"))
    private void redirectClose(SimpleRegionStorage instance) throws IOException {
        this.moonrise$close();
    }
}

