/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemSimpleRegionStorage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SimpleRegionStorage.class})
abstract class SimpleRegionStorageMixin
implements ChunkSystemSimpleRegionStorage,
AutoCloseable {
    @Shadow
    public IOWorker worker;
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private RegionFileStorage storage;

    SimpleRegionStorageMixin() {
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Ljava/nio/file/Path;Lcom/mojang/datafixers/DataFixer;ZLnet/minecraft/util/datafix/DataFixTypes;Ljava/util/function/Supplier;)V"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.storage = this.worker.storage;
        this.worker = null;
    }

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.storage;
    }

    @Overwrite
    public boolean isOldChunkAround(ChunkPos pos, int radius) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"upgradeChunkTag(Lnet/minecraft/nbt/CompoundTag;ILnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/LegacyTagFixer;applyFix(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"))
    private CompoundTag synchroniseLegacyDataUpgrade(LegacyTagFixer instance, CompoundTag compoundTag) {
        LegacyTagFixer legacyTagFixer = instance;
        synchronized (legacyTagFixer) {
            return instance.applyFix(compoundTag);
        }
    }

    @Redirect(method={"read"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/IOWorker;loadAsync(Lnet/minecraft/world/level/ChunkPos;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Optional<CompoundTag>> redirectLoad(IOWorker instance, ChunkPos chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.read(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    @Redirect(method={"write(Lnet/minecraft/world/level/ChunkPos;Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/IOWorker;store(Lnet/minecraft/world/level/ChunkPos;Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Void> redirectWrite(IOWorker instance, ChunkPos chunkPos, Supplier<CompoundTag> compoundTag) {
        try {
            this.storage.write(chunkPos, compoundTag.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"markChunkDone"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/LegacyTagFixer;markChunkDone(Lnet/minecraft/world/level/ChunkPos;)V"))
    private void synchroniseLegacyDataWrite(LegacyTagFixer instance, ChunkPos chunkPos) {
        LegacyTagFixer legacyTagFixer = instance;
        synchronized (legacyTagFixer) {
            instance.markChunkDone(chunkPos);
        }
    }

    @Overwrite
    public CompletableFuture<Void> synchronize(boolean flush) {
        try {
            this.storage.flush();
            return CompletableFuture.completedFuture(null);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
            return CompletableFuture.failedFuture(ex);
        }
    }

    @Override
    @Overwrite
    public void close() throws Exception {
        this.storage.close();
    }

    @Overwrite
    public ChunkScanAccess chunkScanner() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.scanChunk(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Overwrite
    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }
}

