/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_tick_iteration;

import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickConstants;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import it.unimi.dsi.fastutil.longs.LongIterator;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TriState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DistanceManager.class})
abstract class DistanceManagerMixin
implements ChunkTickDistanceManager {
    @Shadow
    public DistanceManager.FixedPlayerDistanceChunkTracker naturalSpawnChunkCounter;
    @Unique
    private final PositionCountingAreaMap<ServerPlayer> spawnChunkTracker = new PositionCountingAreaMap();
    @Unique
    private final PositionCountingAreaMap<ServerPlayer> narrowSpawnChunkTracker = new PositionCountingAreaMap();

    DistanceManagerMixin() {
    }

    @Override
    public final void moonrise$addPlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.add(player, pos.x(), pos.z(), 8);
        this.narrowSpawnChunkTracker.add(player, pos.x(), pos.z(), ChunkTickConstants.NARROW_SPAWN_TRACK_RANGE);
    }

    @Override
    public final void moonrise$removePlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.remove(player);
        this.narrowSpawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(ServerPlayer player, SectionPos oldPos, SectionPos newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
            this.narrowSpawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.x(), newPos.z(), 8);
            this.narrowSpawnChunkTracker.addOrUpdate(player, newPos.x(), newPos.z(), ChunkTickConstants.NARROW_SPAWN_TRACK_RANGE);
        }
    }

    @Override
    public final boolean moonrise$hasAnyNearbyNarrow(int chunkX, int chunkZ) {
        return this.narrowSpawnChunkTracker.hasObjectsNear(chunkX, chunkZ);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void destroyFields(CallbackInfo ci) {
        this.naturalSpawnChunkCounter = null;
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$FixedPlayerDistanceChunkTracker;update(JIZ)V"))
    private void skipSpawnTrackerAdd(DistanceManager.FixedPlayerDistanceChunkTracker instance, long pos, int i0, boolean b0) {
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$FixedPlayerDistanceChunkTracker;update(JIZ)V"))
    private void skipSpawnTrackerRemove(DistanceManager.FixedPlayerDistanceChunkTracker instance, long pos, int i0, boolean b0) {
    }

    @Overwrite
    public int getNaturalSpawnChunkCount() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    @Overwrite
    public TriState hasPlayersNearby(long pos) {
        if (this.narrowSpawnChunkTracker.hasObjectsNear(pos)) {
            return TriState.TRUE;
        }
        return this.spawnChunkTracker.hasObjectsNear(pos) ? TriState.DEFAULT : TriState.FALSE;
    }

    @Overwrite
    public LongIterator getSpawnCandidateChunks() {
        return this.spawnChunkTracker.getPositions().iterator();
    }
}

