/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_tick_iteration;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gamerules.GameRules;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerChunkCache.class})
abstract class ServerChunkCacheMixin
extends ChunkSource {
    @Shadow
    @Final
    public ServerLevel level;
    @Shadow
    @Final
    public ChunkMap chunkMap;
    @Unique
    private final SimpleThreadUnsafeRandom shuffleRandom = new SimpleThreadUnsafeRandom(0L);

    ServerChunkCacheMixin() {
    }

    @Redirect(method={"tickChunks(Lnet/minecraft/util/profiling/ProfilerFiller;J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Util;shuffle(Ljava/util/List;Lnet/minecraft/util/RandomSource;)V"))
    private <T> void useBetterRandom(List<T> list, RandomSource randomSource) {
        this.shuffleRandom.setSeed(randomSource.nextLong());
        Util.shuffle(list, (RandomSource)this.shuffleRandom);
    }

    @Redirect(method={"tickChunks(Lnet/minecraft/util/profiling/ProfilerFiller;J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;forEachBlockTickingChunk(Ljava/util/function/Consumer;)V"))
    private void iterateTickingChunksFaster(ChunkMap instance, Consumer<LevelChunk> consumer) {
        ServerLevel world = this.level;
        int randomTickSpeed = (Integer)world.getGameRules().get(GameRules.RANDOM_TICK_SPEED);
        ReferenceList<LevelChunk> entityTickingChunks = ((ChunkSystemServerLevel)world).moonrise$getEntityTickingChunks();
        LevelChunk[] raw = entityTickingChunks.getRawDataUnchecked();
        int size = entityTickingChunks.size();
        Objects.checkFromToIndex(0, size, raw.length);
        for (int i = 0; i < size; ++i) {
            world.tickChunk(raw[i], randomTickSpeed);
            if ((i & 7) != 0) continue;
            ((ChunkSystemMinecraftServer)this.level.getServer()).moonrise$executeMidTickTasks();
        }
    }
}

