/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={DiscreteVoxelShape.class})
abstract class DiscreteVoxelShapeMixin
implements CollisionDiscreteVoxelShape {
    @Unique
    private CachedShapeData cachedShapeData;

    DiscreteVoxelShapeMixin() {
    }

    @Override
    public final CachedShapeData moonrise$getOrCreateCachedShapeData() {
        long[] voxelSet;
        if (this.cachedShapeData != null) {
            return this.cachedShapeData;
        }
        DiscreteVoxelShape discreteVoxelShape = (DiscreteVoxelShape)this;
        int sizeX = discreteVoxelShape.getXSize();
        int sizeY = discreteVoxelShape.getYSize();
        int sizeZ = discreteVoxelShape.getZSize();
        int maxIndex = sizeX * sizeY * sizeZ;
        int longsRequired = maxIndex + 63 >>> 6;
        boolean isEmpty = discreteVoxelShape.isEmpty();
        if (discreteVoxelShape instanceof BitSetDiscreteVoxelShape) {
            BitSetDiscreteVoxelShape bitsetShape = (BitSetDiscreteVoxelShape)discreteVoxelShape;
            voxelSet = bitsetShape.storage.toLongArray();
            if (voxelSet.length < longsRequired) {
                voxelSet = Arrays.copyOf(voxelSet, longsRequired);
            }
        } else {
            voxelSet = new long[longsRequired];
            if (!isEmpty) {
                int mulX = sizeZ * sizeY;
                for (int x = 0; x < sizeX; ++x) {
                    for (int y = 0; y < sizeY; ++y) {
                        for (int z = 0; z < sizeZ; ++z) {
                            if (!discreteVoxelShape.isFull(x, y, z)) continue;
                            int index = z + y * sizeZ + x * mulX;
                            int n = index >>> 6;
                            voxelSet[n] = voxelSet[n] | 1L << index;
                        }
                    }
                }
            }
        }
        boolean hasSingleAABB = sizeX == 1 && sizeY == 1 && sizeZ == 1 && !isEmpty && (voxelSet[0] & 1L) != 0L;
        int minFullX = discreteVoxelShape.firstFull(Direction.Axis.X);
        int minFullY = discreteVoxelShape.firstFull(Direction.Axis.Y);
        int minFullZ = discreteVoxelShape.firstFull(Direction.Axis.Z);
        int maxFullX = discreteVoxelShape.lastFull(Direction.Axis.X);
        int maxFullY = discreteVoxelShape.lastFull(Direction.Axis.Y);
        int maxFullZ = discreteVoxelShape.lastFull(Direction.Axis.Z);
        this.cachedShapeData = new CachedShapeData(sizeX, sizeY, sizeZ, voxelSet, minFullX, minFullY, minFullZ, maxFullX, maxFullY, maxFullZ, isEmpty, hasSingleAABB);
        return this.cachedShapeData;
    }
}

