/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={LiquidBlockRenderer.class})
abstract class LiquidBlockRendererMixin {
    LiquidBlockRendererMixin() {
    }

    @Overwrite
    private static boolean isFaceOccludedByState(Direction direction, float height, BlockState state) {
        VoxelShape heightShape;
        if (height < 1.0E-7f) {
            return false;
        }
        boolean isOne = Math.abs(height - 1.0f) <= 1.0E-7f;
        double heightDouble = height;
        if (isOne || direction == Direction.DOWN) {
            heightShape = Shapes.block();
        } else {
            if (direction == Direction.UP) {
                return false;
            }
            heightShape = new ArrayVoxelShape(Shapes.block().shape, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)DoubleArrayList.wrap((double[])new double[]{0.0, heightDouble}), (DoubleList)CollisionUtil.ZERO_ONE);
        }
        VoxelShape occlusionShape = ((CollisionVoxelShape)state.getFaceOcclusionShape(direction.getOpposite())).moonrise$getFaceShapeClamped(direction.getOpposite());
        if (occlusionShape.isEmpty()) {
            return false;
        }
        if (heightShape == occlusionShape) {
            return true;
        }
        return !Shapes.joinIsNotEmpty((VoxelShape)heightShape, (VoxelShape)occlusionShape, (BooleanOp)BooleanOp.ONLY_FIRST);
    }
}

