/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.entity_tracker;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerTrackedEntity;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.DataFixer;
import java.nio.file.Path;
import java.util.Iterator;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
abstract class ChunkMapMixin
extends SimpleRegionStorage
implements ChunkHolder.PlayerProvider,
GeneratingChunkMap {
    @Shadow
    @Final
    public ServerLevel level;

    public ChunkMapMixin(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, DataFixTypes dataFixType) {
        super(info, folder, fixerUpper, sync, dataFixType);
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=0))
    private boolean skipMoveTrackerUpdate(Iterator<?> iterator) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=1))
    private boolean newTrackerTick(Iterator<?> iterator) {
        ServerEntityLookup entityLookup = (ServerEntityLookup)((ChunkSystemServerLevel)this.level).moonrise$getEntityLookup();
        ReferenceList<Entity> trackerEntities = entityLookup.trackerEntities;
        Entity[] trackerEntitiesRaw = trackerEntities.getRawDataUnchecked();
        int len = trackerEntities.size();
        for (int i = 0; i < len; ++i) {
            Entity entity = trackerEntitiesRaw[i];
            ChunkMap.TrackedEntity tracker = ((EntityTrackerEntity)entity).moonrise$getTrackedEntity();
            if (tracker == null) continue;
            ((EntityTrackerTrackedEntity)tracker).moonrise$tick(((ChunkSystemEntity)entity).moonrise$getChunkData().nearbyPlayers);
            if (!((EntityTrackerTrackedEntity)tracker).moonrise$hasPlayers() && !((ChunkSystemEntity)entity).moonrise$getChunkStatus().isOrAfter(FullChunkStatus.ENTITY_TICKING)) continue;
            tracker.serverEntity.sendChanges();
        }
        return false;
    }

    @Inject(method={"addEntity"}, at={@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;put(ILjava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)})
    private void addEntityTrackerField(Entity entity, CallbackInfo ci, @Local(ordinal=0) ChunkMap.TrackedEntity trackedEntity) {
        if (((EntityTrackerEntity)entity).moonrise$getTrackedEntity() != null) {
            throw new IllegalStateException("Entity is already tracked");
        }
        ((EntityTrackerEntity)entity).moonrise$setTrackedEntity(trackedEntity);
    }

    @Inject(method={"removeEntity"}, at={@At(value="RETURN")})
    private void removeEntityTrackerField(Entity entity, CallbackInfo ci) {
        ((EntityTrackerEntity)entity).moonrise$setTrackedEntity(null);
    }
}

