/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.getblock;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class}, priority=1100)
abstract class LevelMixin
implements LevelAccessor,
AutoCloseable {
    @Unique
    private int minY;
    @Unique
    private int height;
    @Unique
    private int maxY;
    @Unique
    private int minSectionY;
    @Unique
    private int maxSectionY;
    @Unique
    private int sectionsCount;

    LevelMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="CTOR_HEAD")})
    private void init(CallbackInfo ci, @Local(ordinal=0, argsOnly=true) Holder<DimensionType> dimensionTypeHolder) {
        DimensionType dimType = (DimensionType)dimensionTypeHolder.value();
        this.minY = dimType.minY();
        this.height = dimType.height();
        this.maxY = this.minY + this.height - 1;
        this.minSectionY = this.minY >> 4;
        this.maxSectionY = this.maxY >> 4;
        this.sectionsCount = this.maxSectionY - this.minSectionY + 1;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getSectionsCount() {
        return this.sectionsCount;
    }

    public int getMinSectionY() {
        return this.minSectionY;
    }

    public int getMaxSectionY() {
        return this.maxSectionY;
    }

    public boolean isInsideBuildHeight(int blockY) {
        return blockY >= this.minY && blockY <= this.maxY;
    }

    public boolean isOutsideBuildHeight(BlockPos pos) {
        return this.isOutsideBuildHeight(pos.getY());
    }

    public boolean isOutsideBuildHeight(int blockY) {
        return blockY < this.minY || blockY > this.maxY;
    }

    public int getSectionIndex(int blockY) {
        return (blockY >> 4) - this.minSectionY;
    }

    public int getSectionIndexFromSectionY(int sectionY) {
        return sectionY - this.minSectionY;
    }

    public int getSectionYFromSectionIndex(int sectionIdx) {
        return sectionIdx + this.minSectionY;
    }
}

