/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.poi_lookup;

import ca.spottedleaf.moonrise.patches.poi_lookup.PoiAccess;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PoiManager.class})
abstract class PoiManagerMixin
extends SectionStorage<PoiSection, PoiSection.Packed> {
    public PoiManagerMixin(SimpleRegionStorage simpleRegionStorage, Codec<PoiSection.Packed> codec, Function<PoiSection, PoiSection.Packed> function, BiFunction<PoiSection.Packed, Runnable, PoiSection> biFunction, Function<Runnable, PoiSection> function2, RegistryAccess registryAccess, ChunkIOErrorReporter chunkIOErrorReporter, LevelHeightAccessor levelHeightAccessor) {
        super(simpleRegionStorage, codec, function, biFunction, function2, registryAccess, chunkIOErrorReporter, levelHeightAccessor);
    }

    @Overwrite
    public Optional<BlockPos> find(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        BlockPos ret = PoiAccess.findAnyPoiPosition((PoiManager)this, typePredicate, posPredicate, pos, radius, occupationStatus, true);
        return Optional.ofNullable(ret);
    }

    @Overwrite
    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        BlockPos ret = PoiAccess.findClosestPoiDataPosition((PoiManager)this, typePredicate, null, pos, radius, radius * radius, occupationStatus, true);
        return Optional.ofNullable(ret);
    }

    @Overwrite
    public Optional<Pair<Holder<PoiType>, BlockPos>> findClosestWithType(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return Optional.ofNullable(PoiAccess.findClosestPoiDataTypeAndPosition((PoiManager)this, typePredicate, null, pos, radius, radius * radius, occupationStatus, true));
    }

    @Overwrite
    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        BlockPos ret = PoiAccess.findClosestPoiDataPosition((PoiManager)this, typePredicate, posPredicate, pos, radius, radius * radius, occupationStatus, true);
        return Optional.ofNullable(ret);
    }

    @Overwrite
    public Optional<BlockPos> take(Predicate<Holder<PoiType>> typePredicate, BiPredicate<Holder<PoiType>, BlockPos> biPredicate, BlockPos pos, int radius) {
        PoiRecord closest = PoiAccess.findClosestPoiDataRecord((PoiManager)this, typePredicate, biPredicate, pos, radius, (double)(radius * radius), PoiManager.Occupancy.HAS_SPACE, true);
        return Optional.ofNullable(closest).map(poi -> {
            poi.acquireTicket();
            return poi.getPos();
        });
    }

    @Overwrite
    public Optional<BlockPos> getRandom(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> positionPredicate, PoiManager.Occupancy occupationStatus, BlockPos pos, int radius, RandomSource random) {
        ArrayList<PoiRecord> list = new ArrayList<PoiRecord>();
        PoiAccess.findAnyPoiRecords((PoiManager)this, typePredicate, positionPredicate, pos, radius, occupationStatus, true, Integer.MAX_VALUE, list);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(((PoiRecord)list.get(random.nextInt(list.size()))).getPos());
    }

    @Overwrite
    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllWithType(Predicate<Holder<PoiType>> predicate, Predicate<BlockPos> predicate2, BlockPos blockPos, int i, PoiManager.Occupancy occupancy) {
        ArrayList<Pair<Holder<PoiType>, BlockPos>> ret = new ArrayList<Pair<Holder<PoiType>, BlockPos>>();
        PoiAccess.findAnyPoiPositions((PoiManager)this, predicate, predicate2, blockPos, i, occupancy, true, Integer.MAX_VALUE, ret);
        return ret.stream();
    }

    @Overwrite
    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllClosestFirstWithType(Predicate<Holder<PoiType>> predicate, Predicate<BlockPos> predicate2, BlockPos blockPos, int i, PoiManager.Occupancy occupancy) {
        ArrayList<Pair<Holder<PoiType>, BlockPos>> ret = new ArrayList<Pair<Holder<PoiType>, BlockPos>>();
        PoiAccess.findNearestPoiPositions((PoiManager)this, predicate, predicate2, blockPos, i, Double.MAX_VALUE, occupancy, true, Integer.MAX_VALUE, ret);
        return ret.stream();
    }
}

