/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.neoforge.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.neoforge.patches.collisions.FluidPushCalculation;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.IEntityExtension;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Entity.class})
abstract class EntityMixin
implements IEntityExtension {
    @Shadow
    private Level level;

    EntityMixin() {
    }

    @Shadow
    public abstract boolean touchingUnloadedChunk();

    @Shadow
    public abstract AABB getBoundingBox();

    @Shadow
    protected abstract void setFluidTypeHeight(FluidType var1, double var2);

    @Shadow
    public abstract Vec3 getDeltaMovement();

    @Shadow
    public abstract void setDeltaMovement(Vec3 var1);

    @Overwrite
    public void updateFluidHeightAndDoFluidPushing(boolean doFluidPushing) {
        if (this.touchingUnloadedChunk()) {
            return;
        }
        AABB boundingBox = this.getBoundingBox().deflate(0.001);
        Level world = this.level;
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = Mth.floor((double)boundingBox.minX);
        int minBlockY = Math.max(minSection << 4, Mth.floor((double)boundingBox.minY));
        int minBlockZ = Mth.floor((double)boundingBox.minZ);
        int maxBlockX = Mth.ceil((double)boundingBox.maxX) - 1;
        int maxBlockY = Math.min(WorldUtil.getMaxSection(world) << 4 | 0xF, Mth.ceil((double)boundingBox.maxY) - 1);
        int maxBlockZ = Mth.ceil((double)boundingBox.maxZ) - 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkSource chunkSource = world.getChunkSource();
        int chunkLenX = maxChunkX - minChunkX + 1;
        int chunkOffset = -(minChunkX + chunkLenX * minChunkZ);
        LevelChunkSection[][] sections = new LevelChunkSection[chunkLenX * (maxChunkZ - minChunkZ + 1)][];
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                sections[currChunkX + chunkLenX * currChunkZ + chunkOffset] = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false).getSections();
            }
        }
        Reference2ReferenceArrayMap calculations = new Reference2ReferenceArrayMap();
        for (int currX = minBlockX; currX <= maxBlockX; ++currX) {
            for (int currY = minBlockY; currY <= maxBlockY; ++currY) {
                for (int currZ = minBlockZ; currZ <= maxBlockZ; ++currZ) {
                    FluidState fluidState = ((BlockState)sections[(currX >> 4) + chunkLenX * (currZ >> 4) + chunkOffset][(currY >> 4) - minSection].states.get(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).getFluidState();
                    if (fluidState.isEmpty()) continue;
                    mutablePos.set(currX, currY, currZ);
                    double height = (float)mutablePos.getY() + fluidState.getHeight((BlockGetter)world, (BlockPos)mutablePos);
                    double diff = height - boundingBox.minY;
                    if (diff < 0.0) continue;
                    FluidType type = fluidState.getFluidType();
                    FluidPushCalculation calculation = (FluidPushCalculation)calculations.computeIfAbsent((Object)type, key -> new FluidPushCalculation());
                    double maxHeightDiff = calculation.maxHeightDiff = Math.max(calculation.maxHeightDiff, diff);
                    if (calculation.isPushed == Boolean.FALSE) continue;
                    if (calculation.isPushed == null) {
                        boolean isPushed = this.isPushedByFluid(type);
                        calculation.isPushed = isPushed;
                        if (!isPushed) continue;
                    }
                    calculation.totalPushes += 1.0;
                    Vec3 flow = fluidState.getFlow((BlockGetter)world, (BlockPos)mutablePos);
                    calculation.pushVector = maxHeightDiff < 0.4 ? calculation.pushVector.add(flow.scale(maxHeightDiff)) : calculation.pushVector.add(flow);
                }
            }
        }
        if (calculations.isEmpty()) {
            return;
        }
        ObjectIterator iterator = calculations.reference2ReferenceEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Vec3 pushVector;
            Reference2ReferenceMap.Entry entry = (Reference2ReferenceMap.Entry)iterator.next();
            FluidType type = (FluidType)entry.getKey();
            FluidPushCalculation calculation = (FluidPushCalculation)entry.getValue();
            this.setFluidTypeHeight(type, calculation.maxHeightDiff);
            if (!doFluidPushing || (pushVector = calculation.pushVector) == Vec3.ZERO) continue;
            pushVector = pushVector.scale(1.0 / calculation.totalPushes);
            Vec3 currMovement = this.getDeltaMovement();
            if (!((Entity)this instanceof Player)) {
                pushVector = pushVector.normalize();
            }
            pushVector = pushVector.scale(this.getFluidMotionScale(type));
            if (Math.abs(currMovement.x) < 0.003 && Math.abs(currMovement.z) < 0.003 && pushVector.length() < 0.0045000000000000005) {
                pushVector = pushVector.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(currMovement.add(pushVector));
        }
    }
}

