/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.profiler.client;

import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.thread.BalancedPrioritisedThreadPool;
import ca.spottedleaf.moonrise.patches.profiler.LProfileGraph;
import ca.spottedleaf.moonrise.patches.profiler.LProfilerRegistry;
import ca.spottedleaf.moonrise.patches.profiler.LeafProfiler;
import ca.spottedleaf.moonrise.patches.profiler.TickTime;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import org.slf4j.Logger;

public final class ClientProfilerInstance
implements ProfilerFiller {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final boolean MEASURE_CPU_TIME = THREAD_MX_BEAN.isThreadCpuTimeSupported();
    private final Path root;
    private final BalancedPrioritisedThreadPool.OrderedStreamGroup.Queue dumpPool;
    private final LProfilerRegistry registry = new LProfilerRegistry();
    public final int clientFrame = this.registry.createType(LProfilerRegistry.ProfileType.TIMER, "Client Frame");
    public final int clientTick = this.registry.createType(LProfilerRegistry.ProfileType.TIMER, "Client Tick");
    private long previousTickStart = Long.MIN_VALUE;
    private long tickStart = Long.MIN_VALUE;
    private long tickStartCPU = Long.MIN_VALUE;
    private LeafProfiler delayedFrameProfiler;
    private LeafProfiler frameProfiler;
    private long tick;
    private Path sessionPath;
    private long averageThreshold;
    private long recordThreshold;
    private final List<RecordedTick> recordedTicks = new ArrayList<RecordedTick>();

    public ClientProfilerInstance() {
        this.root = Path.of("moonrise", "profiler", "large_ticks");
        this.dumpPool = MoonriseCommon.CLIENT_IO_GROUP.createExecutor();
    }

    private void reset() {
        this.previousTickStart = Long.MIN_VALUE;
        this.tickStart = Long.MIN_VALUE;
        this.tickStartCPU = Long.MIN_VALUE;
        this.tick = 0L;
        this.delayedFrameProfiler = null;
        this.sessionPath = null;
        this.averageThreshold = 0L;
        this.recordThreshold = 0L;
        this.recordedTicks.clear();
    }

    public boolean startSession(long averageThresholdNS, long recordThresholdNS) {
        if (this.sessionPath != null) {
            return false;
        }
        String sessionId = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now());
        this.sessionPath = this.root.resolve(sessionId);
        this.averageThreshold = averageThresholdNS < 0L ? Long.MAX_VALUE : averageThresholdNS;
        this.recordThreshold = recordThresholdNS < 0L ? Long.MAX_VALUE : recordThresholdNS;
        this.delayedFrameProfiler = new LeafProfiler(this.registry, new LProfileGraph());
        LOGGER.info("Starting client profiler with avg_threshold=" + averageThresholdNS + "rec_threshold=" + recordThresholdNS + ",sessionId=" + sessionId);
        return true;
    }

    public boolean endSession() {
        if (this.sessionPath == null) {
            return false;
        }
        LOGGER.info("Ending client profiler session");
        this.write();
        this.reset();
        return true;
    }

    private void writeTick(RecordedTick recordedTick) {
        Path path = this.sessionPath.resolve(recordedTick.tickNum + ".txt");
        this.dumpPool.queueTask(() -> {
            try {
                if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                Files.write(path, recordedTick.profilingData().dumpToString(), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to write tick " + String.valueOf(recordedTick), ex);
            }
        });
    }

    private void writeAverages() {
        Path path = this.sessionPath.resolve("averages.txt");
        LeafProfiler.ProfilingData profilingData = this.delayedFrameProfiler.copyAccumulated();
        this.dumpPool.queueTask(() -> {
            try {
                if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                Files.write(path, profilingData.dumpToString(), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to write averages", ex);
            }
        });
    }

    private void write() {
        for (RecordedTick tick : this.recordedTicks) {
            this.writeTick(tick);
        }
        this.writeAverages();
    }

    public boolean isActive() {
        return this.delayedFrameProfiler != null;
    }

    public void startTick() {
        long time = System.nanoTime();
        long cpuTime = MEASURE_CPU_TIME ? THREAD_MX_BEAN.getCurrentThreadCpuTime() : 0L;
        this.previousTickStart = this.tickStart;
        this.tickStart = time;
        this.tickStartCPU = cpuTime;
        this.frameProfiler = this.delayedFrameProfiler;
        if (this.frameProfiler != null) {
            this.frameProfiler.startTimer(this.clientFrame, time);
        }
    }

    public void endTick() {
        long cpuTime = MEASURE_CPU_TIME ? THREAD_MX_BEAN.getCurrentThreadCpuTime() : 0L;
        long time = System.nanoTime();
        TickTime tickTime = new TickTime(this.previousTickStart, this.tickStart, this.tickStart, this.tickStartCPU, time, cpuTime, MEASURE_CPU_TIME);
        if (this.frameProfiler != null) {
            this.frameProfiler.stopTimer(this.clientFrame, time);
            if (tickTime.tickLength() >= this.recordThreshold) {
                this.recordedTicks.add(new RecordedTick(tickTime, this.tick, this.frameProfiler.copyCurrent()));
            }
            if (tickTime.tickLength() >= this.averageThreshold) {
                this.frameProfiler.accumulate();
            } else {
                this.frameProfiler.clearCurrent();
            }
        }
        this.frameProfiler = null;
        ++this.tick;
    }

    public void startRealClientTick() {
        if (this.frameProfiler != null) {
            this.frameProfiler.startTimer(this.clientTick, System.nanoTime());
        }
    }

    public void endRealClientTick() {
        if (this.frameProfiler != null) {
            this.frameProfiler.stopTimer(this.clientTick, System.nanoTime());
        }
    }

    public void push(String string) {
        LeafProfiler frameProfiler = this.frameProfiler;
        if (frameProfiler == null) {
            return;
        }
        long time = System.nanoTime();
        int timerId = frameProfiler.registry.getOrCreateTimer(string);
        frameProfiler.startTimer(timerId, time);
    }

    public void push(Supplier<String> supplier) {
        LeafProfiler frameProfiler = this.frameProfiler;
        if (frameProfiler == null) {
            return;
        }
        long time = System.nanoTime();
        int timerId = frameProfiler.registry.getOrCreateTimer(supplier.get());
        frameProfiler.startTimer(timerId, time);
    }

    public void pop() {
        LeafProfiler frameProfiler = this.frameProfiler;
        if (frameProfiler == null) {
            return;
        }
        long time = System.nanoTime();
        frameProfiler.stopLastTimer(time);
    }

    public void popPush(String string) {
        this.pop();
        this.push(string);
    }

    public void popPush(Supplier<String> supplier) {
        this.pop();
        this.push(supplier);
    }

    public void markForCharting(MetricCategory metricCategory) {
    }

    public void incrementCounter(String string) {
        this.incrementCounter(string, 1);
    }

    public void incrementCounter(String string, int i) {
        LeafProfiler frameProfiler = this.frameProfiler;
        if (frameProfiler == null) {
            return;
        }
        int timerId = frameProfiler.registry.getOrCreateCounter(string);
        frameProfiler.incrementCounter(timerId, i);
    }

    public void incrementCounter(Supplier<String> supplier) {
        this.incrementCounter(supplier, 1);
    }

    public void incrementCounter(Supplier<String> supplier, int i) {
        LeafProfiler frameProfiler = this.frameProfiler;
        if (frameProfiler == null) {
            return;
        }
        int timerId = frameProfiler.registry.getOrCreateCounter(supplier.get());
        frameProfiler.incrementCounter(timerId, i);
    }

    static {
        if (MEASURE_CPU_TIME) {
            THREAD_MX_BEAN.setThreadCpuTimeEnabled(true);
        } else {
            LOGGER.warn("ClientProfilerInstance CPU time measurement is not available");
        }
    }

    private record RecordedTick(TickTime tickTime, long tickNum, LeafProfiler.ProfilingData profilingData) {
    }
}

