/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.config.ui;

import ca.spottedleaf.moonrise.common.config.ui.ClothConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ConfigWalker {
    private ConfigWalker() {
    }

    public static <T> void walk(T dfl, T instance, ConfigBuilder builder) throws Exception {
        for (Field field : dfl.getClass().getDeclaredFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            try {
                field.setAccessible(true);
            }
            catch (Exception exception) {
                continue;
            }
            Object dflField = field.get(dfl);
            Object instanceField = field.get(instance);
            for (Annotation annotation : field.getAnnotations()) {
                if (!(annotation instanceof ClothConfig)) {
                    ConfigWalker.walk(dflField, instanceField, builder);
                    continue;
                }
                ClothConfig config = (ClothConfig)annotation;
                ConfigWalker.createFieldBuilder(builder, config, field, dfl, instance);
            }
        }
    }

    private static void createFieldBuilder(ConfigBuilder builder, ClothConfig config, Field field, Object dfl, Object dst) {
        BooleanToggleBuilder ret;
        ConfigCategory category;
        block7: {
            ConfigEntryBuilder configEntryBuilder = builder.entryBuilder();
            category = builder.getOrCreateCategory((Component)Component.translatable((String)config.section()));
            MutableComponent name = Component.translatable((String)config.fieldKeyName());
            Class<?> clazz = field.getType();
            try {
                if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    ret = configEntryBuilder.startBooleanToggle((Component)name, ((Boolean)field.get(dst)).booleanValue());
                    break block7;
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    ret = configEntryBuilder.startDoubleField((Component)name, ((Double)field.get(dst)).doubleValue());
                    break block7;
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    ret = configEntryBuilder.startLongField((Component)name, ((Long)field.get(dst)).longValue());
                    break block7;
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    ret = configEntryBuilder.startIntField((Component)name, ((Integer)field.get(dst)).intValue());
                    break block7;
                }
                if (clazz == String.class) {
                    ret = configEntryBuilder.startStrField((Component)name, (String)field.get(dst));
                    break block7;
                }
                throw new IllegalArgumentException("Unknown type: " + String.valueOf(clazz));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        ConfigWalker.updateFields(ret, config, field, dfl, dst);
        category.addEntry(ret.build());
    }

    private static <E> void updateFields(AbstractFieldBuilder<E, ?, ?> builder, ClothConfig config, Field field, Object dfl, Object dst) {
        try {
            builder.setDefaultValue(field.get(dfl));
            builder.setTooltip(new Component[]{Component.translatable((String)config.tooltip())});
            builder.setSaveConsumer(element -> {
                try {
                    field.set(dst, element);
                }
                catch (Exception ex) {
                    throw new RuntimeException();
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

