/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.list;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class COWArrayList<E> {
    private volatile E[] array;

    public COWArrayList(Class<E> clazz) {
        this.array = (Object[])Array.newInstance(clazz, 0);
    }

    public E[] getArray() {
        return this.array;
    }

    public boolean contains(E test) {
        for (E elem : this.array) {
            if (elem != test) continue;
            return true;
        }
        return false;
    }

    public E getFirst() {
        E[] array = this.array;
        return array.length == 0 ? null : (E)array[0];
    }

    public E getLast() {
        E[] array = this.array;
        return array.length == 0 ? null : (E)array[array.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E element) {
        COWArrayList cOWArrayList = this;
        synchronized (cOWArrayList) {
            E[] array = this.array;
            E[] copy = Arrays.copyOf(array, array.length + 1);
            copy[array.length] = element;
            this.array = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(E element) {
        COWArrayList cOWArrayList = this;
        synchronized (cOWArrayList) {
            E[] array = this.array;
            int index = -1;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (array[i] != element) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return false;
            }
            Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
            System.arraycopy(array, 0, copy, 0, index);
            System.arraycopy(array, index + 1, copy, index, array.length - 1 - index);
            this.array = copy;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLast(E element) {
        COWArrayList cOWArrayList = this;
        synchronized (cOWArrayList) {
            E[] array = this.array;
            int index = -1;
            for (int i = array.length - 1; i >= 0; --i) {
                if (array[i] != element) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return false;
            }
            Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
            System.arraycopy(array, 0, copy, 0, index);
            System.arraycopy(array, index + 1, copy, index, array.length - 1 - index);
            this.array = copy;
        }
        return true;
    }
}

