/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkHolder.class})
abstract class ChunkHolderMixin
extends GenerationChunkHolder
implements ChunkSystemChunkHolder {
    @Shadow
    @Final
    private ChunkHolder.PlayerProvider playerProvider;
    @Shadow
    private volatile CompletableFuture<ChunkResult<LevelChunk>> fullChunkFuture;
    @Shadow
    private volatile CompletableFuture<ChunkResult<LevelChunk>> tickingChunkFuture;
    @Shadow
    private volatile CompletableFuture<ChunkResult<LevelChunk>> entityTickingChunkFuture;
    @Shadow
    private CompletableFuture<?> pendingFullStateConfirmation;
    @Shadow
    private CompletableFuture<?> sendSync;
    @Shadow
    private CompletableFuture<?> saveSync;
    @Unique
    private NewChunkHolder newChunkHolder;
    @Unique
    private final ReferenceList<ServerPlayer> playersSentChunkTo = new ReferenceList<ServerPlayer>(EMPTY_PLAYER_ARRAY);
    @Unique
    private static final ServerPlayer[] EMPTY_PLAYER_ARRAY = new ServerPlayer[0];

    public ChunkHolderMixin(ChunkPos chunkPos) {
        super(chunkPos);
    }

    @Unique
    private ChunkMap getChunkMap() {
        return (ChunkMap)this.playerProvider;
    }

    @Override
    public final NewChunkHolder moonrise$getRealChunkHolder() {
        return this.newChunkHolder;
    }

    @Override
    public final void moonrise$setRealChunkHolder(NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
    }

    @Override
    public final void moonrise$addReceivedChunk(ServerPlayer player) {
        if (!this.playersSentChunkTo.add(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.pos) + " in world '" + WorldUtil.getWorldName((Level)this.getChunkMap().level) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final void moonrise$removeReceivedChunk(ServerPlayer player) {
        if (!this.playersSentChunkTo.remove(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.pos) + " in world '" + WorldUtil.getWorldName((Level)this.getChunkMap().level) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent() {
        return this.playersSentChunkTo.size() != 0;
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent(ServerPlayer to) {
        return this.playersSentChunkTo.contains(to);
    }

    @Override
    public final List<ServerPlayer> moonrise$getPlayers(boolean onlyOnWatchDistanceEdge) {
        ArrayList<ServerPlayer> ret = new ArrayList<ServerPlayer>();
        ServerPlayer[] raw = this.playersSentChunkTo.getRawDataUnchecked();
        int len = this.playersSentChunkTo.size();
        for (int i = 0; i < len; ++i) {
            ServerPlayer player = raw[i];
            if (onlyOnWatchDistanceEdge && !((ChunkSystemServerLevel)this.getChunkMap().level).moonrise$getPlayerChunkLoader().isChunkSent(player, this.pos.x, this.pos.z, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initFields(CallbackInfo ci) {
        this.fullChunkFuture = null;
        this.tickingChunkFuture = null;
        this.entityTickingChunkFuture = null;
        this.pendingFullStateConfirmation = null;
        this.sendSync = null;
        this.saveSync = null;
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> getTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> getEntityTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> getFullChunkFuture() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public LevelChunk getTickingChunk() {
        ChunkAccess chunkAccess;
        if (this.newChunkHolder.isTickingReady() && (chunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            return levelChunk;
        }
        return null;
    }

    @Overwrite
    public CompletableFuture<?> getSendSyncFuture() {
        throw new UnsupportedOperationException();
    }

    @Unique
    private boolean isRadiusLoaded(int radius) {
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.getChunkMap().level).moonrise$getChunkTaskScheduler().chunkHolderManager;
        ChunkPos pos = this.pos;
        int chunkX = pos.x;
        int chunkZ = pos.z;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                NewChunkHolder holder;
                if ((dx | dz) == 0 || (holder = manager.getChunkHolder(dx + chunkX, dz + chunkZ)) != null && holder.isFullChunkReady()) continue;
                return false;
            }
        }
        return true;
    }

    @Overwrite
    public LevelChunk getChunkToSend() {
        LevelChunk ret = this.moonrise$getFullChunk();
        if (ret != null && this.isRadiusLoaded(1)) {
            return ret;
        }
        return null;
    }

    @Override
    public final LevelChunk moonrise$getFullChunk() {
        ChunkAccess chunkAccess;
        if (this.newChunkHolder.isFullChunkReady() && (chunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            return levelChunk;
        }
        return null;
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> getSaveSyncFuture() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean isReadyForSaving() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void addSaveDependency(CompletableFuture<?> completableFuture) {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"blockChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkHolder;getTickingChunk()Lnet/minecraft/world/level/chunk/LevelChunk;"))
    private LevelChunk redirectBlockUpdate(ChunkHolder instance) {
        if (this.playersSentChunkTo.size() == 0) {
            return null;
        }
        return this.getChunkToSend();
    }

    @Redirect(method={"sectionLightChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkHolder;getTickingChunk()Lnet/minecraft/world/level/chunk/LevelChunk;"))
    private LevelChunk redirectLightUpdate(ChunkHolder instance) {
        if (this.playersSentChunkTo.size() == 0) {
            return null;
        }
        return this.getChunkToSend();
    }

    @Redirect(method={"broadcastChanges"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkHolder$PlayerProvider;getPlayers(Lnet/minecraft/world/level/ChunkPos;Z)Ljava/util/List;"))
    private List<ServerPlayer> redirectPlayerRetrieval(ChunkHolder.PlayerProvider instance, ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge) {
        return this.moonrise$getPlayers(onlyOnWatchDistanceEdge);
    }

    @Overwrite
    public void addSendDependency(CompletableFuture<?> completableFuture) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public int getTicketLevel() {
        return this.newChunkHolder.getTicketLevel();
    }

    @Overwrite
    public int getQueueLevel() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void setQueueLevel(int i) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void setTicketLevel(int i) {
    }

    @Overwrite
    public void scheduleFullChunkPromotion(ChunkMap chunkMap, CompletableFuture<ChunkResult<LevelChunk>> completableFuture, Executor executor, FullChunkStatus fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void demoteFullChunk(ChunkMap chunkMap, FullChunkStatus fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Inject(method={"updateFutures"}, at={@At(value="HEAD")})
    public void clobberUpdateFutures(ChunkMap chunkMap, Executor executor, CallbackInfo ci) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean wasAccessibleSinceLastSave() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void refreshAccessibility() {
        throw new UnsupportedOperationException();
    }
}

