/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
abstract class ServerLevelMixin
extends Level
implements ChunkSystemServerLevel,
ChunkSystemLevelReader,
WorldGenLevel {
    @Shadow
    private PersistentEntitySectionManager<Entity> entityManager;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    private ServerChunkCache chunkSource;
    @Unique
    private boolean markedClosing;
    @Unique
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    @Unique
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader((ServerLevel)this);
    @Unique
    private EntityDataController entityDataController;
    @Unique
    private PoiDataController poiDataController;
    @Unique
    private ChunkDataController chunkDataController;
    @Unique
    private ChunkTaskScheduler chunkTaskScheduler;
    @Unique
    private long lastMidTickFailure;
    @Unique
    private long tickedBlocksOrFluids;
    @Unique
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers((ServerLevel)this);
    @Unique
    private static final LevelChunk[] EMPTY_LEVEL_CHUNKS = new LevelChunk[0];
    @Unique
    private final ReferenceList<LevelChunk> loadedChunks = new ReferenceList<LevelChunk>(EMPTY_LEVEL_CHUNKS);
    @Unique
    private final ReferenceList<LevelChunk> tickingChunks = new ReferenceList<LevelChunk>(EMPTY_LEVEL_CHUNKS);
    @Unique
    private final ReferenceList<LevelChunk> entityTickingChunks = new ReferenceList<LevelChunk>(EMPTY_LEVEL_CHUNKS);

    protected ServerLevelMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, bl, bl2, l, i);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(MinecraftServer minecraftServer, Executor executor, LevelStorageSource.LevelStorageAccess levelStorageAccess, ServerLevelData serverLevelData, ResourceKey<Level> resourceKey, LevelStem levelStem, boolean bl, long l, List<CustomSpawner> list, boolean bl2, RandomSequences randomSequences, CallbackInfo ci) {
        this.entityManager = null;
        this.moonrise$setEntityLookup(new ServerEntityLookup((ServerLevel)this, (LevelCallback<Entity>)new ServerLevel.EntityCallbacks((ServerLevel)this)));
        this.chunkTaskScheduler = new ChunkTaskScheduler((ServerLevel)this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(levelStorageAccess.getLevelId(), resourceKey, "entities"), levelStorageAccess.getDimensionPath(resourceKey).resolve("entities"), minecraftServer.forceSynchronousWrites()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController((ServerLevel)this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController((ServerLevel)this, this.chunkTaskScheduler);
    }

    @Override
    public final LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.chunkSource.getChunkNow(chunkX, chunkZ);
    }

    @Override
    public final ChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final ChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        ((ChunkSystemMinecraftServer)this.server).moonrise$executeMidTickTasks();
    }

    @Override
    public final ChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return 6;
    }

    @Override
    public final boolean moonrise$isMarkedClosing() {
        return this.markedClosing;
    }

    @Override
    public final void moonrise$setMarkedClosing(boolean value) {
        this.markedClosing = value;
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPos pos, int radiusBlocks, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.getX() - radiusBlocks >> 4, pos.getX() + radiusBlocks >> 4, pos.getZ() - radiusBlocks >> 4, pos.getZ() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPos pos, int radiusBlocks, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.getX() - radiusBlocks >> 4, pos.getX() + radiusBlocks >> 4, pos.getZ() - radiusBlocks >> 4, pos.getZ() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.FULL, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, chunkStatus, priority, onLoad, null);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad, Consumer<ChunkAccess> onEachLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<ChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.getPos(), ticketLevel, holderIdentifier);
            }
            if (onEachLoad != null) {
                onEachLoad.accept((ChunkAccess)chunk);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    if (onLoad != null) {
                        onLoad.accept(Collections.unmodifiableList(ret));
                    }
                }
                finally {
                    int len = ret.size();
                    for (int i = 0; i < len; ++i) {
                        ChunkPos chunkPos = ((ChunkAccess)ret.get(i)).getPos();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunkTaskScheduler.scheduleChunkLoad(cx, cz, chunkStatus, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<LevelChunk> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<LevelChunk> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<LevelChunk> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ServerChunkCache chunkSource = this.chunkSource;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.hasChunk(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasChunk(int x, int z) {
        return this.moonrise$getFullChunkIfLoaded(x, z) != null;
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus status, boolean load) {
        return this.chunkSource.getChunk(x, z, status, load);
    }

    public LevelChunk getChunk(int x, int z) {
        return (LevelChunk)this.chunkSource.getChunk(x, z, ChunkStatus.FULL, true);
    }

    @Redirect(method={"method_31420", "*(Lnet/minecraft/world/TickRateManager;Lnet/minecraft/util/profiling/ProfilerFiller;Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;inEntityTickingRange(J)Z"))
    private boolean shortCircuitTickCheck(DistanceManager instance, long chunk) {
        return true;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;tick()V"))
    private void redirectEntityManagerTick(PersistentEntitySectionManager<Entity> instance) {
    }

    @Overwrite
    public boolean shouldTickBlocksAt(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;saveAll()V"))
    private void redirectSaveAll(PersistentEntitySectionManager<Entity> instance) {
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;autoSave()V"))
    private void redirectAutoSave(PersistentEntitySectionManager<Entity> instance) {
    }

    @Redirect(method={"addEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;addNewEntity(Lnet/minecraft/world/level/entity/EntityAccess;)Z"))
    private <T extends EntityAccess> boolean redirectAddEntityEntity(PersistentEntitySectionManager<T> instance, T entity) {
        return this.moonrise$getEntityLookup().addNewEntity((Entity)entity);
    }

    @Overwrite
    public boolean tryAddFreshEntityWithPassengers(Entity entity) {
        Stream<UUID> stream = entity.getSelfAndPassengers().map(Entity::getUUID);
        if (stream.anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity);
        return true;
    }

    @Redirect(method={"saveDebugReport"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;gatherStats()Ljava/lang/String;"))
    private String redirectDebugStats(PersistentEntitySectionManager<Entity> instance) {
        return this.moonrise$getEntityLookup().getDebugInfo();
    }

    @Redirect(method={"saveDebugReport"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;dumpChunks(Ljava/io/Writer;)V"))
    private void redirectChunkMapDebug(ChunkMap instance, Writer writer) {
    }

    @Redirect(method={"saveDebugReport"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;dumpSections(Ljava/io/Writer;)V"))
    private void redirectEntityManagerDebug(PersistentEntitySectionManager<Entity> instance, Writer writer) {
    }

    @Redirect(method={"getWatchdogStats"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;gatherStats()Ljava/lang/String;"))
    private String redirectWatchdogStats1(PersistentEntitySectionManager<Entity> instance) {
        return this.moonrise$getEntityLookup().getDebugInfo();
    }

    @Redirect(method={"getWatchdogStats"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;getEntityGetter()Lnet/minecraft/world/level/entity/LevelEntityGetter;"))
    private LevelEntityGetter<Entity> redirectWatchdogStats2(PersistentEntitySectionManager<Entity> instance) {
        return this.moonrise$getEntityLookup();
    }

    @Redirect(method={"getEntities()Lnet/minecraft/world/level/entity/LevelEntityGetter;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;getEntityGetter()Lnet/minecraft/world/level/entity/LevelEntityGetter;"))
    private LevelEntityGetter<Entity> redirectGetEntities(PersistentEntitySectionManager<Entity> instance) {
        return this.moonrise$getEntityLookup();
    }

    @Redirect(method={"addLegacyChunkEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;addLegacyChunkEntities(Ljava/util/stream/Stream;)V"))
    private void redirectLegacyChunkEntities(PersistentEntitySectionManager<Entity> instance, Stream<Entity> stream) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(stream.toList(), null);
    }

    @Redirect(method={"addWorldGenChunkEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;addWorldGenChunkEntities(Ljava/util/stream/Stream;)V"))
    private void redirectWorldGenChunkEntities(PersistentEntitySectionManager<Entity> instance, Stream<Entity> stream) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(stream.toList(), null);
    }

    @Inject(method={"waitForEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectWaitForEntities(ChunkPos chunkPos, int radius, CallbackInfo ci) {
        List chunks = ChunkPos.rangeClosed((ChunkPos)chunkPos, (int)radius).toList();
        this.server.managedBlock(() -> {
            for (ChunkPos chunkpos : chunks) {
                if (this.areEntitiesLoaded(chunkpos.toLong())) continue;
                return false;
            }
            return true;
        });
        ci.cancel();
    }

    @Redirect(method={"close"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;close()V"))
    private void redirectClose(PersistentEntitySectionManager<Entity> instance) {
    }

    @Redirect(method={"gatherChunkSourceStats"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;gatherStats()Ljava/lang/String;"))
    private String redirectGatherChunkSourceStats(PersistentEntitySectionManager<Entity> instance) {
        return this.moonrise$getEntityLookup().getDebugInfo();
    }

    @Overwrite
    public boolean areEntitiesLoaded(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    @Overwrite
    public boolean isPositionTickingWithEntitiesLoaded(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    @Overwrite
    public boolean isPositionEntityTicking(BlockPos pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Overwrite
    public boolean areEntitiesActuallyLoadedAndTicking(ChunkPos pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Redirect(method={"canSpawnEntitiesInChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;canPositionTick(Lnet/minecraft/world/level/ChunkPos;)Z"))
    private <T extends EntityAccess> boolean redirectCanEntitiesSpawnTickCheck(PersistentEntitySectionManager<T> instance, ChunkPos pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @WrapOperation(method={"fillReportDetails"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReportCategory;setDetail(Ljava/lang/String;Lnet/minecraft/CrashReportDetail;)Lnet/minecraft/CrashReportCategory;")})
    private CrashReportCategory redirectCrashCount(CrashReportCategory instance, String s, CrashReportDetail<String> string, Operation<CrashReportCategory> original) {
        return (CrashReportCategory)original.call(new Object[]{instance, s, () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount())});
    }

    @Inject(method={"tickFluid"}, at={@At(value="RETURN")})
    private void midTickFluids(CallbackInfo ci) {
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            return;
        }
        ((ChunkSystemMinecraftServer)this.server).moonrise$executeMidTickTasks();
    }

    @Inject(method={"tickBlock"}, at={@At(value="RETURN")})
    private void midTickBlock(CallbackInfo ci) {
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            return;
        }
        ((ChunkSystemMinecraftServer)this.server).moonrise$executeMidTickTasks();
    }
}

