/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Particle.class})
abstract class ParticleMixin {
    @Shadow
    protected double x;
    @Shadow
    protected double y;
    @Shadow
    protected double z;
    @Shadow
    @Final
    protected ClientLevel level;

    ParticleMixin() {
    }

    @Redirect(method={"move(DDD)V"}, at=@At(target="Lnet/minecraft/world/entity/Entity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;", value="INVOKE"))
    private Vec3 optimiseParticleCollisions(Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> list) {
        boolean zEmpty;
        boolean yEmpty;
        boolean xEmpty = Math.abs(movement.x) < 1.0E-7;
        AABB collisionBox = !xEmpty & ((yEmpty = Math.abs(movement.y) < 1.0E-7) | (zEmpty = Math.abs(movement.z) < 1.0E-7)) ? (movement.x < 0.0 ? CollisionUtil.cutLeft(entityBoundingBox, movement.x) : CollisionUtil.cutRight(entityBoundingBox, movement.x)) : (!yEmpty & (xEmpty | zEmpty) ? (movement.y < 0.0 ? CollisionUtil.cutDownwards(entityBoundingBox, movement.y) : CollisionUtil.cutUpwards(entityBoundingBox, movement.y)) : (!zEmpty & (xEmpty | yEmpty) ? (movement.z < 0.0 ? CollisionUtil.cutBackwards(entityBoundingBox, movement.z) : CollisionUtil.cutForwards(entityBoundingBox, movement.z)) : entityBoundingBox.expandTowards(movement.x, movement.y, movement.z)));
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        ArrayList<VoxelShape> voxels = new ArrayList<VoxelShape>();
        boolean collided = CollisionUtil.getCollisionsForBlocksOrWorldBorder(world, entity, collisionBox, voxels, boxes, 0, null);
        if (!collided) {
            return movement;
        }
        return CollisionUtil.performCollisions(movement, entityBoundingBox, voxels, boxes);
    }
}

