/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.neoforge;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.BaseChunkSystemHooks;
import ca.spottedleaf.moonrise.common.util.ConfigHolder;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import org.slf4j.Logger;

public final class NeoForgeHooks
extends BaseChunkSystemHooks
implements PlatformHooks {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getBrand() {
        return "Moonrise";
    }

    @Override
    public int getLightEmission(BlockState blockState, BlockGetter world, BlockPos pos) {
        return blockState.getLightEmission(world, pos);
    }

    @Override
    public Predicate<BlockState> maybeHasLightEmission() {
        return state -> state.hasDynamicLightEmission() || state.getLightEmission((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO) != 0;
    }

    @Override
    public boolean hasCurrentlyLoadingChunk() {
        return true;
    }

    @Override
    public LevelChunk getCurrentlyLoadingChunk(GenerationChunkHolder holder) {
        return holder.currentlyLoading;
    }

    @Override
    public void setCurrentlyLoading(GenerationChunkHolder holder, LevelChunk levelChunk) {
        holder.currentlyLoading = levelChunk;
    }

    @Override
    public void chunkFullStatusComplete(LevelChunk newChunk, ProtoChunk original) {
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Load(newChunk, !(original instanceof ImposterProtoChunk)));
    }

    @Override
    public boolean allowAsyncTicketUpdates() {
        return false;
    }

    @Override
    public void onChunkHolderTicketChange(ServerLevel world, ChunkHolder holder, int oldLevel, int newLevel) {
        ChunkPos pos = holder.getPos();
        EventHooks.fireChunkTicketLevelUpdated((ServerLevel)world, (long)CoordinateUtils.getChunkKey(pos.x, pos.z), (int)oldLevel, (int)newLevel, (ChunkHolder)holder);
    }

    @Override
    public void chunkUnloadFromWorld(LevelChunk chunk) {
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Unload(chunk));
    }

    @Override
    public void chunkSyncSave(ServerLevel world, ChunkAccess chunk, SerializableChunkData data) {
        NeoForge.EVENT_BUS.post((Event)new ChunkDataEvent.Save(chunk, (LevelAccessor)world, data));
    }

    @Override
    public void onChunkWatch(ServerLevel world, LevelChunk chunk, ServerPlayer player) {
        EventHooks.fireChunkWatch((ServerPlayer)player, (LevelChunk)chunk, (ServerLevel)world);
    }

    @Override
    public void onChunkUnWatch(ServerLevel world, ChunkPos chunk, ServerPlayer player) {
        EventHooks.fireChunkUnWatch((ServerPlayer)player, (ChunkPos)chunk, (ServerLevel)world);
    }

    @Override
    public void addToGetEntities(Level world, Entity entity, AABB boundingBox, Predicate<? super Entity> predicate, List<Entity> into) {
        Collection parts = world.dragonParts();
        if (parts.isEmpty()) {
            return;
        }
        for (PartEntity part : parts) {
            if (part == entity || !part.getBoundingBox().intersects(boundingBox) || predicate != null && !predicate.test((Entity)part)) continue;
            into.add((Entity)part);
        }
    }

    @Override
    public <T extends Entity> void addToGetEntities(Level world, EntityTypeTest<Entity, T> entityTypeTest, AABB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        if (into.size() >= maxCount) {
            return;
        }
        Collection parts = world.dragonParts();
        if (parts.isEmpty()) {
            return;
        }
        for (PartEntity part : parts) {
            Entity casted;
            if (!part.getBoundingBox().intersects(boundingBox) || (casted = (Entity)entityTypeTest.tryCast((Object)part)) == null || predicate != null && !predicate.test(casted)) continue;
            into.add(casted);
            if (into.size() < maxCount) continue;
            break;
        }
    }

    @Override
    public void entityMove(Entity entity, long oldSection, long newSection) {
        CommonHooks.onEntityEnterSection((Entity)entity, (long)oldSection, (long)newSection);
    }

    @Override
    public boolean screenEntity(ServerLevel world, Entity entity, boolean fromDisk, boolean event) {
        return !event || !((EntityJoinLevelEvent)NeoForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, entity.level(), fromDisk))).isCanceled();
    }

    @Override
    public boolean configFixMC224294() {
        return ConfigHolder.getConfig().bugFixes.fixMC224294;
    }

    @Override
    public boolean configAutoConfigSendDistance() {
        return ConfigHolder.getConfig().chunkLoading.advanced.autoConfigSendDistance;
    }

    @Override
    public double configPlayerMaxLoadRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxLoadRate;
    }

    @Override
    public double configPlayerMaxGenRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxGenRate;
    }

    @Override
    public double configPlayerMaxSendRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxSendRate;
    }

    @Override
    public int configPlayerMaxConcurrentLoads() {
        return ConfigHolder.getConfig().chunkLoading.advanced.playerMaxConcurrentChunkLoads;
    }

    @Override
    public int configPlayerMaxConcurrentGens() {
        return ConfigHolder.getConfig().chunkLoading.advanced.playerMaxConcurrentChunkGenerates;
    }

    @Override
    public long configAutoSaveInterval(ServerLevel world) {
        return ConfigHolder.getConfig().chunkSaving.autoSaveInterval.getTimeTicks();
    }

    @Override
    public int configMaxAutoSavePerTick(ServerLevel world) {
        return ConfigHolder.getConfig().chunkSaving.maxAutoSaveChunksPerTick;
    }

    @Override
    public boolean configFixMC159283() {
        return ConfigHolder.getConfig().bugFixes.fixMC159283;
    }

    @Override
    public boolean forceNoSave(ChunkAccess chunk) {
        return false;
    }

    @Override
    public CompoundTag convertNBT(DSL.TypeReference type, DataFixer dataFixer, CompoundTag nbt, int fromVersion, int toVersion) {
        return (CompoundTag)dataFixer.update(type, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbt), fromVersion, toVersion).getValue();
    }

    @Override
    public boolean hasMainChunkLoadHook() {
        return true;
    }

    @Override
    public void mainChunkLoad(ChunkAccess chunk, SerializableChunkData chunkData) {
        NeoForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(chunk, chunkData));
    }

    @Override
    public List<Entity> modifySavedEntities(ServerLevel world, int chunkX, int chunkZ, List<Entity> entities) {
        return entities;
    }

    @Override
    public void unloadEntity(Entity entity) {
        entity.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK);
    }

    @Override
    public void postLoadProtoChunk(ServerLevel world, ProtoChunk chunk) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(chunk.problemPath(), LOGGER);){
            ChunkStatusTasks.postLoadProtoChunk((ServerLevel)world, (ValueInput.ValueInputList)TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)world.registryAccess(), (List)chunk.getEntities()));
        }
    }

    @Override
    public int modifyEntityTrackingRange(Entity entity, int currentRange) {
        return currentRange;
    }

    @Override
    public long[] getCounterTypesUncached(TicketType type) {
        LongArrayList ret = new LongArrayList();
        if (type == TicketType.FORCED) {
            ret.add(0L);
        }
        if (type.forceNaturalSpawning()) {
            ret.add(2L);
        }
        if (type.shouldKeepDimensionActive()) {
            ret.add(1L);
        }
        return ret.toLongArray();
    }

    @Override
    public boolean addTicketForEnderPearls(ServerLevel world) {
        return true;
    }
}

