/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.command;

import ca.spottedleaf.moonrise.common.time.TickData;
import ca.spottedleaf.moonrise.common.util.ConfigHolder;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.JsonUtil;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.command.CommandClientCommandSource;
import ca.spottedleaf.moonrise.patches.profiler.client.ProfilerMinecraft;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopMinecraftServer;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class MoonriseCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadLocal<DecimalFormat> ONE_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.0"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"moonrise").requires(src -> src.hasPermission(src.getServer().operatorUserPermissionLevel()) || !(src.getServer() instanceof DedicatedServer))).then(Commands.literal((String)"holderinfo").executes(MoonriseCommand::holderInfo))).then(Commands.literal((String)"chunkinfo").executes(MoonriseCommand::chunkInfo))).then(Commands.literal((String)"reload").executes(MoonriseCommand::reload))).then(((LiteralArgumentBuilder)Commands.literal((String)"relight").executes(ctx -> MoonriseCommand.relight((CommandContext<CommandSourceStack>)ctx, 10))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)MoonriseConstants.MAX_VIEW_DISTANCE)).executes(ctx -> MoonriseCommand.relight((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))))).then(Commands.literal((String)"debug").then(Commands.literal((String)"chunks").executes(MoonriseCommand::debugChunks)))).then(Commands.literal((String)"tps").executes(MoonriseCommand::tps)));
    }

    public static void registerClient(CommandDispatcher<CommandClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"moonrisec").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"profiler").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"start").executes(ctx -> MoonriseCommand.startClientProfiler((CommandContext<CommandClientCommandSource>)ctx, -1.0))).then(RequiredArgumentBuilder.argument((String)"record_threshold", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10000.0)).executes(ctx -> MoonriseCommand.startClientProfiler((CommandContext<CommandClientCommandSource>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"record_threshold")))))).then(LiteralArgumentBuilder.literal((String)"stop").executes(MoonriseCommand::stopClientProfiler))));
    }

    private static int startClientProfiler(CommandContext<CommandClientCommandSource> ctx, double recordThreshold) {
        boolean started = ((ProfilerMinecraft)Minecraft.getInstance()).moonrise$profilerInstance().startSession(0L, recordThreshold < 0.0 ? -1L : Math.round(recordThreshold * 1000000.0));
        if (!started) {
            ((CommandClientCommandSource)ctx.getSource()).moonrise$sendFailure((Component)Component.literal((String)"Profiler is already running").withStyle(ChatFormatting.RED));
            return 0;
        }
        ((CommandClientCommandSource)ctx.getSource()).moonrise$sendSuccess((Component)Component.literal((String)"Started client profiler").withStyle(ChatFormatting.BLUE));
        return 1;
    }

    private static int stopClientProfiler(CommandContext<CommandClientCommandSource> ctx) {
        boolean ended = ((ProfilerMinecraft)Minecraft.getInstance()).moonrise$profilerInstance().endSession();
        if (!ended) {
            ((CommandClientCommandSource)ctx.getSource()).moonrise$sendFailure((Component)Component.literal((String)"Profiler is not running").withStyle(ChatFormatting.RED));
            return 0;
        }
        ((CommandClientCommandSource)ctx.getSource()).moonrise$sendSuccess((Component)Component.literal((String)"Stopped client profiler").withStyle(ChatFormatting.BLUE));
        return 1;
    }

    public static int holderInfo(CommandContext<CommandSourceStack> ctx) {
        int total = 0;
        int canUnload = 0;
        int nullChunks = 0;
        int readOnly = 0;
        int protoChunk = 0;
        int fullChunk = 0;
        for (NewChunkHolder holder : ((ChunkSystemServerLevel)((CommandSourceStack)ctx.getSource()).getLevel()).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolders()) {
            NewChunkHolder.ChunkCompletion completion = holder.getLastChunkCompletion();
            ChunkAccess chunk = completion == null ? null : completion.chunk();
            ++total;
            if (chunk == null) {
                ++nullChunks;
            } else if (chunk instanceof ImposterProtoChunk) {
                ++readOnly;
            } else if (chunk instanceof ProtoChunk) {
                ++protoChunk;
            } else if (chunk instanceof LevelChunk) {
                ++fullChunk;
            }
            if (holder.isSafeToUnload() != null) continue;
            ++canUnload;
        }
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Total: ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)Integer.toString(total)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Unloadable: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(canUnload)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Null: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(nullChunks)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" ReadOnly: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(readOnly)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Proto: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(protoChunk)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Full: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(fullChunk)).withStyle(ChatFormatting.DARK_AQUA)));
        return total;
    }

    public static int chunkInfo(CommandContext<CommandSourceStack> ctx) {
        int total = 0;
        int inactive = 0;
        int full = 0;
        int blockTicking = 0;
        int entityTicking = 0;
        for (NewChunkHolder holder : ((ChunkSystemServerLevel)((CommandSourceStack)ctx.getSource()).getLevel()).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolders()) {
            NewChunkHolder.ChunkCompletion completion = holder.getLastChunkCompletion();
            ChunkAccess chunk = completion == null ? null : completion.chunk();
            if (!(chunk instanceof LevelChunk)) continue;
            LevelChunk fullChunk = (LevelChunk)chunk;
            ++total;
            switch (holder.getChunkStatus()) {
                case INACCESSIBLE: {
                    ++inactive;
                    break;
                }
                case FULL: {
                    ++full;
                    break;
                }
                case BLOCK_TICKING: {
                    ++blockTicking;
                    break;
                }
                case ENTITY_TICKING: {
                    ++entityTicking;
                }
            }
        }
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Total: ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)Integer.toString(total)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Inactive: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(inactive)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Full: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(full)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Block Ticking: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(blockTicking)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" Entity Ticking: ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)Integer.toString(entityTicking)).withStyle(ChatFormatting.DARK_AQUA)));
        return total;
    }

    public static int reload(CommandContext<CommandSourceStack> ctx) {
        if (ConfigHolder.reloadConfig()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Reloaded Moonrise config.").withStyle(ChatFormatting.BLUE), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to reload Moonrise config, see logs.").withStyle(ChatFormatting.RED));
        return 0;
    }

    public static int relight(CommandContext<CommandSourceStack> ctx, int radius) {
        Vec3 center = ((CommandSourceStack)ctx.getSource()).getPosition();
        int centerChunkX = Mth.floor((double)center.x) >> 4;
        int centerChunkZ = Mth.floor((double)center.z) >> 4;
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        LongOpenHashSet seen = new LongOpenHashSet();
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        long zero = CoordinateUtils.getChunkKey(0, 0);
        seen.add(zero);
        queue.enqueue(zero);
        chunks.add(new ChunkPos(centerChunkX, centerChunkZ));
        int[][] offsets = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        while (!queue.isEmpty()) {
            long chunk = queue.dequeueLong();
            int chunkX = CoordinateUtils.getChunkX(chunk);
            int chunkZ = CoordinateUtils.getChunkZ(chunk);
            for (int[] offset : offsets) {
                int neighbourX = chunkX + offset[0];
                int neighbourZ = chunkZ + offset[1];
                long neighbour = CoordinateUtils.getChunkKey(neighbourX, neighbourZ);
                int dist = Math.max(Math.abs(neighbourX), Math.abs(neighbourZ));
                if (dist > radius || !seen.add(neighbour)) continue;
                queue.enqueue(neighbour);
                chunks.add(new ChunkPos(neighbourX + centerChunkX, neighbourZ + centerChunkZ));
            }
        }
        int ret = ((StarLightLightingProvider)((CommandSourceStack)ctx.getSource()).getLevel().getLightEngine()).starlight$serverRelightChunks(chunks, null, null);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Relighting ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)Integer.toString(ret)).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" chunks").withStyle(ChatFormatting.BLUE)), true);
        return ret;
    }

    public static int debugChunks(CommandContext<CommandSourceStack> ctx) {
        File file = ChunkTaskScheduler.getChunkDebugFile();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Writing chunk information dump to '").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)file.toString()).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"'").withStyle(ChatFormatting.BLUE)), true);
        try {
            JsonUtil.writeJson((JsonElement)ChunkTaskScheduler.debugAllWorlds(((CommandSourceStack)ctx.getSource()).getServer()), file);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Wrote chunk information dump to '").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)file.toString()).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"'").withStyle(ChatFormatting.BLUE)), true);
            return 1;
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to dump chunk information to file '" + file.getAbsolutePath() + "'", throwable);
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to dump chunk information, see console").withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    private static int colorFromHSV(double h, double s, double v) {
        double b;
        double g;
        double r;
        double c = v * s;
        double hh = h / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = v - c;
        double cm = c + m;
        double xm = x + m;
        if (hh >= 0.0 && hh < 1.0) {
            r = cm;
            g = xm;
            b = m;
        } else if (hh >= 1.0 && hh < 2.0) {
            r = xm;
            g = cm;
            b = m;
        } else if (hh >= 2.0 && hh < 3.0) {
            r = m;
            g = cm;
            b = xm;
        } else if (hh >= 3.0 && hh < 4.0) {
            r = m;
            g = xm;
            b = cm;
        } else if (hh >= 4.0 && hh < 5.0) {
            r = xm;
            g = m;
            b = cm;
        } else if (hh >= 5.0 && hh < 6.0) {
            r = cm;
            g = m;
            b = xm;
        } else {
            g = b = m;
            r = b;
        }
        return Math.toIntExact(Math.round(r * 255.0)) << 16 | Math.toIntExact(Math.round(g * 255.0)) << 8 | Math.toIntExact(Math.round(b * 255.0));
    }

    private static int getColourForTPS(double tps) {
        double difference = Math.min(Math.abs(20.0 - tps), 20.0);
        double coordinate = difference <= 2.0 ? 70.0 + -35.0 * (difference - 2.0) : (difference <= 5.0 ? 30.0 + -13.333333333333334 * (difference - 5.0) : (difference <= 10.0 ? 10.0 + -4.0 * (difference - 10.0) : 0.0 + -1.0 * (difference - 20.0)));
        return MoonriseCommand.colorFromHSV(coordinate, 0.85, 0.8);
    }

    private static int getTPSColour(double tps, double expectedTps) {
        return MoonriseCommand.getColourForTPS(tps * (20.0 / expectedTps));
    }

    private static int getColourForMSPT(double mspt) {
        double clamped = Math.min(Math.abs(mspt), 50.0);
        double coordinate = clamped <= 15.0 ? 130.0 + -0.6666666666666666 * (clamped - 15.0) : (clamped <= 25.0 ? 90.0 + -4.0 * (clamped - 25.0) : (clamped <= 35.0 ? 30.0 + -6.0 * (clamped - 35.0) : (clamped <= 40.0 ? 15.0 + -3.0 * (clamped - 40.0) : 0.0 + -1.5 * (clamped - 50.0))));
        return MoonriseCommand.colorFromHSV(coordinate, 0.85, 0.8);
    }

    private static int getMSPTColour(double mspt, double expectedMaxMSPT) {
        return MoonriseCommand.getColourForMSPT(mspt * (50.0 / expectedMaxMSPT));
    }

    private static MutableComponent formatMSPTReport(TickData.TickReportData report, long tickIntervalNS) {
        TickData.SegmentedAverage timePerTickData = report.timePerTickData();
        TickData.SegmentData all = timePerTickData.segmentAll();
        TickData.SegmentData percentile = timePerTickData.segment5PercentWorst();
        double minMS = all.least() / 1000000.0;
        double medMS = all.median() / 1000000.0;
        double avgMS = all.average() / 1000000.0;
        double percent = percentile.least() / 1000000.0;
        double max = all.greatest() / 1000000.0;
        double expectedMSPT = (double)tickIntervalNS / 1000000.0;
        return Component.literal((String)"").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(minMS)).withColor(MoonriseCommand.getMSPTColour(minMS, expectedMSPT))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(medMS)).withColor(MoonriseCommand.getMSPTColour(medMS, expectedMSPT))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(avgMS)).withColor(MoonriseCommand.getMSPTColour(avgMS, expectedMSPT))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(percent)).withColor(MoonriseCommand.getMSPTColour(percent, expectedMSPT))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(max)).withColor(MoonriseCommand.getMSPTColour(max, expectedMSPT)));
    }

    public static int tps(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        TickData tickTimes5s = ((TickLoopMinecraftServer)server).moonrise$getTickData5s();
        TickData tickTimes10s = ((TickLoopMinecraftServer)server).moonrise$getTickData10s();
        TickData tickTimes1m = ((TickLoopMinecraftServer)server).moonrise$getTickData1m();
        TickData tickTimes5m = ((TickLoopMinecraftServer)server).moonrise$getTickData5m();
        TickData tickTimes15m = ((TickLoopMinecraftServer)server).moonrise$getTickData15m();
        long now = Util.getNanos();
        long tickIntervalNS = server.tickRateManager().nanosecondsPerTick();
        TickData.TickReportData report5s = tickTimes5s.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report10s = tickTimes10s.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report1m = tickTimes1m.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report5m = tickTimes5m.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report15m = tickTimes15m.generateTickReport(null, now, tickIntervalNS);
        if (report5s == null || report10s == null || report1m == null || report5m == null || report15m == null) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"No tick data to report").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"TPS ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)"5s").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"10s").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"1m").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"5m").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"15m").withStyle(ChatFormatting.DARK_AQUA)), false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> {
            double tps5s = report5s.tpsData().segmentAll().average();
            double tps10s = report10s.tpsData().segmentAll().average();
            double tps1m = report1m.tpsData().segmentAll().average();
            double tps5m = report5m.tpsData().segmentAll().average();
            double tps15m = report15m.tpsData().segmentAll().average();
            double expectedTps = 1.0 / (double)tickIntervalNS * 1.0E9;
            return Component.literal((String)" ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(tps5s)).withColor(MoonriseCommand.getTPSColour(tps5s, expectedTps))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(tps10s)).withColor(MoonriseCommand.getTPSColour(tps10s, expectedTps))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(tps1m)).withColor(MoonriseCommand.getTPSColour(tps1m, expectedTps))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(tps5m)).withColor(MoonriseCommand.getTPSColour(tps5m, expectedTps))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)ONE_DECIMAL_PLACES.get().format(tps15m)).withColor(MoonriseCommand.getTPSColour(tps15m, expectedTps)));
        }, false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)""), false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"MSPT ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)"min").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"med").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"avg").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"95%ile").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"max").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" for ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"10s").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)"; ").withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)"1m").withStyle(ChatFormatting.DARK_AQUA)), false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)" ").withStyle(ChatFormatting.BLUE).append((Component)MoonriseCommand.formatMSPTReport(report10s, tickIntervalNS)).append((Component)Component.literal((String)";  ").withStyle(ChatFormatting.BLUE)).append((Component)MoonriseCommand.formatMSPTReport(report1m, tickIntervalNS)), false);
        return 0;
    }
}

