/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.light;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.patches.starlight.blockstate.StarlightAbstractBlockState;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockStarLightEngine
extends StarLightEngine {
    protected final BlockPos.MutableBlockPos recalcCenterPos = new BlockPos.MutableBlockPos();

    public BlockStarLightEngine(Level world) {
        super(false, world);
    }

    @Override
    protected boolean[] getEmptinessMap(ChunkAccess chunk) {
        return ((StarlightChunk)chunk).starlight$getBlockEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(ChunkAccess chunk, boolean[] to) {
        ((StarlightChunk)chunk).starlight$setBlockEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(ChunkAccess chunk) {
        return ((StarlightChunk)chunk).starlight$getBlockNibbles();
    }

    @Override
    protected void setNibbles(ChunkAccess chunk, SWMRNibbleArray[] to) {
        ((StarlightChunk)chunk).starlight$setBlockNibbles(to);
    }

    @Override
    protected boolean canUseChunk(ChunkAccess chunk) {
        return chunk.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT) && (this.isClientSide || chunk.isLightCorrect());
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setHidden();
        }
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            this.setNibbleInCache(chunkX, chunkY, chunkZ, new SWMRNibbleArray());
        } else {
            nibble.setNonNull();
        }
    }

    @Override
    protected final void checkBlock(LightChunkGetter lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int emittedMask = this.emittedLightMask;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        BlockState blockState = this.getBlockState(worldX, worldY, worldZ);
        int emittedLevel = PlatformHooks.get().getLightEmission(blockState, lightAccess.getLevel(), (BlockPos)this.lightEmissionPos.set(worldX, worldY, worldZ)) & emittedMask;
        this.setLightLevel(worldX, worldY, worldZ, emittedLevel);
        if (emittedLevel != 0) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLevel & 0xFL) << 28 | 0x3F00000000L | (((StarlightAbstractBlockState)blockState).starlight$isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(LightChunkGetter lightAccess, int worldX, int worldY, int worldZ, int expect) {
        this.recalcCenterPos.set(worldX, worldY, worldZ);
        BlockState centerState = this.getBlockState(worldX, worldY, worldZ);
        BlockGetter world = lightAccess.getLevel();
        int level = PlatformHooks.get().getLightEmission(centerState, world, (BlockPos)this.recalcCenterPos) & this.emittedLightMask;
        if (level >= 14 || level > expect) {
            return level;
        }
        int opacity = Math.max(1, centerState.getLightBlock());
        if (opacity >= 15) {
            return level;
        }
        Object conditionallyOpaqueState = ((StarlightAbstractBlockState)centerState).starlight$isConditionallyFullOpaque() ? centerState : null;
        int sectionOffset = this.chunkSectionIndexOffset;
        for (StarLightEngine.AxisDirection direction : AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            BlockState neighbourState = this.getBlockState(offX, offY, offZ);
            if (((StarlightAbstractBlockState)neighbourState).starlight$isConditionallyFullOpaque()) {
                VoxelShape thisFace;
                VoxelShape neighbourFace = neighbourState.getFaceOcclusionShape(direction.opposite.nms);
                VoxelShape voxelShape = thisFace = conditionallyOpaqueState == null ? Shapes.empty() : conditionallyOpaqueState.getFaceOcclusionShape(direction.nms);
                if (Shapes.faceShapeOccludes((VoxelShape)thisFace, (VoxelShape)neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(LightChunkGetter lightAccess, ChunkAccess atChunk, Set<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.checkBlock(lightAccess, pos.getX(), pos.getY(), pos.getZ());
        }
        this.performLightDecrease(lightAccess);
    }

    protected List<BlockPos> getSources(LightChunkGetter lightAccess, ChunkAccess chunk) {
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        int offX = chunk.getPos().x << 4;
        int offZ = chunk.getPos().z << 4;
        PlatformHooks platformHooks = PlatformHooks.get();
        BlockGetter world = lightAccess.getLevel();
        LevelChunkSection[] sections = chunk.getSections();
        for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
            LevelChunkSection section = sections[sectionY - this.minSection];
            if (section.hasOnlyAir() || !section.maybeHas(platformHooks.maybeHasLightEmission())) continue;
            PalettedContainer states = section.states;
            int offY = sectionY << 4;
            BlockPos.MutableBlockPos mutablePos = this.lightEmissionPos;
            for (int index = 0; index < 4096; ++index) {
                BlockState state = (BlockState)states.get(index);
                mutablePos.set(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF);
                if (platformHooks.getLightEmission(state, world, (BlockPos)mutablePos) == 0) continue;
                sources.add(mutablePos.immutable());
            }
        }
        return sources;
    }

    @Override
    public void lightChunk(LightChunkGetter lightAccess, ChunkAccess chunk, boolean needsEdgeChecks) {
        BlockGetter world = lightAccess.getLevel();
        PlatformHooks platformHooks = PlatformHooks.get();
        int emittedMask = this.emittedLightMask;
        List<BlockPos> positions = this.getSources(lightAccess, chunk);
        int len = positions.size();
        for (int i = 0; i < len; ++i) {
            BlockPos pos = positions.get(i);
            BlockState blockState = this.getBlockState(pos.getX(), pos.getY(), pos.getZ());
            int emittedLight = platformHooks.getLightEmission(blockState, world, pos) & emittedMask;
            if (emittedLight <= this.getLightLevel(pos.getX(), pos.getY(), pos.getZ())) continue;
            this.appendToIncreaseQueue((long)(pos.getX() + (pos.getZ() << 6) + (pos.getY() << 12) + this.coordinateOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (((StarlightAbstractBlockState)blockState).starlight$isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
            this.setLightLevel(pos.getX(), pos.getY(), pos.getZ(), emittedLight);
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            this.checkChunkEdges(lightAccess, chunk, this.minLightSection, this.maxLightSection);
        } else {
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, this.maxLightSection);
            this.performLightIncrease(lightAccess);
        }
    }
}

