/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.collection;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ListTypeAdapter
extends TypeAdapter<List<Object>, List<Object>> {
    public static final ListTypeAdapter INSTANCE = new ListTypeAdapter();

    @Override
    public List<Object> deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Collection field must specify generic type");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type elementType = parameterizedType.getActualTypeArguments()[0];
        if (input instanceof Collection) {
            Collection collection = (Collection)input;
            ArrayList<Object> ret = new ArrayList<Object>(collection.size());
            for (Object v : collection) {
                ret.add(registry.deserialize(v, elementType));
            }
            return ret;
        }
        throw new IllegalArgumentException("Not a collection type: " + String.valueOf(input.getClass()));
    }

    @Override
    public List<Object> serialize(TypeAdapterRegistry registry, List<Object> value, Type type) {
        Type type2;
        ArrayList<Object> ret = new ArrayList<Object>(value.size());
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            type2 = parameterizedType.getActualTypeArguments()[0];
        } else {
            type2 = null;
        }
        Type elementType = type2;
        for (Object v : value) {
            ret.add(registry.serialize(v, elementType));
        }
        return ret;
    }
}

