/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2LongChainedHashTable;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketStorage;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.saveddata.SavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TicketStorage.class})
abstract class TicketStorageMixin
extends SavedData
implements ChunkSystemTicketStorage {
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets;
    @Shadow
    private Long2ObjectOpenHashMap<List<Ticket>> tickets;
    @Shadow
    private LongSet chunksWithForcedTickets;
    @Unique
    private ChunkMap chunkMap;

    TicketStorageMixin() {
    }

    @Override
    public final ChunkMap moonrise$getChunkMap() {
        return this.chunkMap;
    }

    @Override
    public final void moonrise$setChunkMap(ChunkMap chunkMap) {
        this.chunkMap = chunkMap;
    }

    @Inject(method={"<init>(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V"}, at={@At(value="RETURN")})
    private void destroyFields(Long2ObjectOpenHashMap p_393873_, Long2ObjectOpenHashMap p_394615_, CallbackInfo ci) {
        if (!this.tickets.isEmpty()) {
            throw new IllegalStateException("Expect tickets to be empty here!");
        }
        this.tickets = null;
        this.chunksWithForcedTickets = null;
    }

    @Redirect(method={"<init>(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/TicketStorage;updateForcedChunks()V"))
    private void avoidUpdatingForcedChunks(TicketStorage instance) {
    }

    @Redirect(method={"forEachTicket(Ljava/util/function/BiConsumer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/TicketStorage;forEachTicket(Ljava/util/function/BiConsumer;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", ordinal=0))
    private void redirectRegularTickets(BiConsumer<ChunkPos, Ticket> consumer, Long2ObjectOpenHashMap<List<Ticket>> ticketsParam) {
        if (ticketsParam != null) {
            throw new IllegalStateException("Bad injection point");
        }
        Long2ObjectOpenHashMap<Collection<Ticket>> tickets = ((ChunkSystemServerLevel)this.chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsCopy();
        ObjectIterator iterator = tickets.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long pos = entry.getLongKey();
            Collection chunkTickets = (Collection)entry.getValue();
            ChunkPos chunkPos = new ChunkPos(pos);
            for (Ticket ticket : chunkTickets) {
                consumer.accept(chunkPos, ticket);
            }
        }
    }

    @Overwrite
    public boolean shouldKeepDimensionActive() {
        ConcurrentLong2LongChainedHashTable ticketCounters = ((ChunkSystemServerLevel)this.chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketCounters(1L);
        return ticketCounters != null && !ticketCounters.isEmpty();
    }

    @Overwrite
    public void setLoadingChunkUpdatedListener(TicketStorage.ChunkUpdated callback) {
    }

    @Overwrite
    public void setSimulationChunkUpdatedListener(TicketStorage.ChunkUpdated callback) {
    }

    @Overwrite
    public boolean hasTickets() {
        return ((ChunkSystemServerLevel)this.chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.hasTickets();
    }

    @Overwrite
    public List<Ticket> getTickets(long pos) {
        return ((ChunkSystemServerLevel)this.chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsAt(CoordinateUtils.getChunkX(pos), CoordinateUtils.getChunkZ(pos));
    }

    @Overwrite
    public boolean addTicket(long pos, Ticket ticket) {
        boolean ret = ((ChunkSystemServerLevel)this.chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(ticket.getType(), pos, ticket.getTicketLevel(), ((ChunkSystemTicket)ticket).moonrise$getIdentifier());
        this.setDirty();
        return ret;
    }

    @Overwrite
    public boolean removeTicket(long pos, Ticket ticket) {
        boolean ret = ((ChunkSystemServerLevel)this.chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ticket.getType(), pos, ticket.getTicketLevel(), ((ChunkSystemTicket)ticket).moonrise$getIdentifier());
        if (ret) {
            this.setDirty();
        }
        return ret;
    }

    @Overwrite
    public void purgeStaleTickets(ChunkMap chunkMap) {
        ((ChunkSystemServerLevel)chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.tick();
        this.setDirty();
    }

    @Redirect(method={"deactivateTicketsOnClosing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/TicketStorage;removeTicketIf(Lnet/minecraft/world/level/TicketStorage$TicketPredicate;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V"))
    private void avoidRemovingTicketsOnShutdown(TicketStorage instance, TicketStorage.TicketPredicate predicate, Long2ObjectOpenHashMap<List<Ticket>> tickets) {
    }

    @Overwrite
    public void removeTicketIf(TicketStorage.TicketPredicate predicate, Long2ObjectOpenHashMap<List<Ticket>> into) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void replaceTicketLevelOfType(int newLevel, TicketType forType) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public LongSet getForceLoadedChunks() {
        ConcurrentLong2LongChainedHashTable forced = ((ChunkSystemServerLevel)this.chunkMap.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketCounters(0L);
        if (forced == null) {
            return new LongLinkedOpenHashSet();
        }
        LongLinkedOpenHashSet ret = new LongLinkedOpenHashSet(forced.size(), forced.getLoadFactor());
        PrimitiveIterator.OfLong iterator = forced.keyIterator();
        while (iterator.hasNext()) {
            ret.add(iterator.nextLong());
        }
        return ret;
    }

    @Overwrite
    public LongSet getAllChunksWithTicketThat(Predicate<Ticket> predicate) {
        throw new UnsupportedOperationException();
    }
}

