/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import it.unimi.dsi.fastutil.HashCommon;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Direction.class})
abstract class DirectionMixin
implements CollisionDirection {
    @Unique
    private static final int RANDOM_OFFSET = 2017601568;
    @Shadow
    @Final
    private static Direction[] VALUES;
    @Shadow
    @Final
    private Vec3i normal;
    @Shadow
    @Final
    private int oppositeIndex;
    @Unique
    private Direction opposite;
    @Unique
    private Quaternionf rotation;
    @Unique
    private int id;
    @Unique
    private int stepX;
    @Unique
    private int stepY;
    @Unique
    private int stepZ;

    DirectionMixin() {
    }

    @Shadow
    public static Direction from3DDataValue(int i) {
        return null;
    }

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    private static void initCaches(CallbackInfo ci) {
        for (Direction direction : VALUES) {
            ((DirectionMixin)direction).opposite = DirectionMixin.from3DDataValue(((DirectionMixin)direction).oppositeIndex);
            ((DirectionMixin)direction).rotation = ((DirectionMixin)direction).getRotationUncached();
            ((DirectionMixin)direction).id = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(direction.ordinal() + 2017601568)) + 2017601568));
            ((DirectionMixin)direction).stepX = ((DirectionMixin)direction).normal.getX();
            ((DirectionMixin)direction).stepY = ((DirectionMixin)direction).normal.getY();
            ((DirectionMixin)direction).stepZ = ((DirectionMixin)direction).normal.getZ();
        }
    }

    @Overwrite
    public Direction getOpposite() {
        return this.opposite;
    }

    @Unique
    private Quaternionf getRotationUncached() {
        switch ((Direction)this) {
            case DOWN: {
                return new Quaternionf().rotationX((float)Math.PI);
            }
            case UP: {
                return new Quaternionf();
            }
            case NORTH: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            }
            case SOUTH: {
                return new Quaternionf().rotationX(1.5707964f);
            }
            case WEST: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            }
            case EAST: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
            }
        }
        throw new IllegalStateException();
    }

    @Overwrite
    public Quaternionf getRotation() {
        try {
            return (Quaternionf)this.rotation.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    @Overwrite
    public int getStepX() {
        return this.stepX;
    }

    @Overwrite
    public int getStepY() {
        return this.stepY;
    }

    @Overwrite
    public int getStepZ() {
        return this.stepZ;
    }

    @Override
    public final int moonrise$uniqueId() {
        return this.id;
    }
}

