/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public final class MoonriseChunkLoadCounter
extends ChunkLoadCounter {
    private int expected;
    private final AtomicInteger loaded = new AtomicInteger(0);

    public void track(ServerLevel level, Runnable task) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> trackLoadWithRadius(ServerLevel level, ChunkPos chunkPos, int chunkRadius, ChunkStatus status, Priority priority, Runnable done) {
        this.expected = (chunkRadius * 2 + 1) * (chunkRadius * 2 + 1);
        CompletableFuture ret = new CompletableFuture();
        ((ChunkSystemServerLevel)level).moonrise$loadChunksAsync(chunkPos.x - chunkRadius, chunkPos.x + chunkRadius, chunkPos.z - chunkRadius, chunkPos.z + chunkRadius, status, priority, chunks -> {
            if (done != null) {
                done.run();
            }
            ret.complete(null);
        }, chunk -> this.loaded.incrementAndGet());
        return ret;
    }

    public int totalChunks() {
        return this.expected;
    }

    public int pendingChunks() {
        return this.expected - this.loaded.get();
    }

    public int readyChunks() {
        return this.loaded.get();
    }
}

