/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.map;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.function.BiFunction;

public final class SynchronisedLong2ObjectMap<V> {
    private final Long2ObjectLinkedOpenHashMap<V> map = new Long2ObjectLinkedOpenHashMap();
    private final int limit;

    public SynchronisedLong2ObjectMap(int limit) {
        this.limit = limit;
    }

    private void purgeEntries() {
        while (this.map.size() > this.limit) {
            this.map.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long key) {
        Long2ObjectLinkedOpenHashMap<V> long2ObjectLinkedOpenHashMap = this.map;
        synchronized (long2ObjectLinkedOpenHashMap) {
            return (V)this.map.getAndMoveToFirst(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(long key, V value) {
        Long2ObjectLinkedOpenHashMap<V> long2ObjectLinkedOpenHashMap = this.map;
        synchronized (long2ObjectLinkedOpenHashMap) {
            Object ret = this.map.putAndMoveToFirst(key, value);
            this.purgeEntries();
            return (V)ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V compute(long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        Long2ObjectLinkedOpenHashMap<V> long2ObjectLinkedOpenHashMap = this.map;
        synchronized (long2ObjectLinkedOpenHashMap) {
            this.map.compute(key, remappingFunction);
            Object ret = this.map.getAndMoveToFirst(key);
            this.purgeEntries();
            return (V)ret;
        }
    }
}

