/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.io.ChunkSystemRegionFileStorage;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemRegionFile;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2861;
import net.minecraft.class_2867;
import net.minecraft.class_4239;
import net.minecraft.class_5127;
import net.minecraft.class_6836;
import net.minecraft.class_9240;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2867.class})
abstract class RegionFileStorageMixin
implements ChunkSystemRegionFileStorage,
AutoCloseable {
    @Shadow
    @Final
    private Long2ObjectLinkedOpenHashMap<class_2861> field_17657;
    @Shadow
    @Final
    private static int field_31426;
    @Shadow
    @Final
    private Path field_18690;
    @Shadow
    @Final
    private boolean field_23748;
    @Shadow
    @Final
    private class_9240 field_49103;
    @Unique
    private static final int REGION_SHIFT = 5;
    @Unique
    private static final int MAX_NON_EXISTING_CACHE = 4096;
    @Unique
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();

    RegionFileStorageMixin() {
    }

    @Unique
    private static String getRegionFileName(int chunkX, int chunkZ) {
        return "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + ".mca";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private boolean doesRegionFilePossiblyExist(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.contains(position)) {
                this.nonExistingRegionFiles.addAndMoveToFirst(position);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void createRegionFile(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            this.nonExistingRegionFiles.remove(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void markNonExisting(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
                while (this.nonExistingRegionFiles.size() >= 4096) {
                    this.nonExistingRegionFiles.removeLastLong();
                }
            }
        }
    }

    @Override
    public final boolean moonrise$doesRegionFileNotExistNoIO(int chunkX, int chunkZ) {
        return !this.doesRegionFilePossiblyExist(class_1923.method_8331((int)(chunkX >> 5), (int)(chunkZ >> 5)));
    }

    @Override
    public final synchronized class_2861 moonrise$getRegionFileIfLoaded(int chunkX, int chunkZ) {
        return (class_2861)this.field_17657.getAndMoveToFirst(class_1923.method_8331((int)(chunkX >> 5), (int)(chunkZ >> 5)));
    }

    @Override
    public final synchronized class_2861 moonrise$getRegionFileIfExists(int chunkX, int chunkZ) throws IOException {
        Path regionPath;
        long key = class_1923.method_8331((int)(chunkX >> 5), (int)(chunkZ >> 5));
        class_2861 ret = (class_2861)this.field_17657.getAndMoveToFirst(key);
        if (ret != null) {
            return ret;
        }
        if (!this.doesRegionFilePossiblyExist(key)) {
            return null;
        }
        if (this.field_17657.size() >= field_31426) {
            ((class_2861)this.field_17657.removeLast()).close();
        }
        if (!Files.exists(regionPath = this.field_18690.resolve(RegionFileStorageMixin.getRegionFileName(chunkX, chunkZ)), new LinkOption[0])) {
            this.markNonExisting(key);
            return null;
        }
        this.createRegionFile(key);
        class_4239.method_47525((Path)this.field_18690);
        ret = new class_2861(this.field_49103, regionPath, this.field_18690, this.field_23748);
        this.field_17657.putAndMoveToFirst(key, (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public final class_2861 method_12440(class_1923 chunkPos) throws IOException {
        RegionFileStorageMixin regionFileStorageMixin = this;
        synchronized (regionFileStorageMixin) {
            long key = class_1923.method_8331((int)(chunkPos.field_9181 >> 5), (int)(chunkPos.field_9180 >> 5));
            class_2861 ret = (class_2861)this.field_17657.getAndMoveToFirst(key);
            if (ret != null) {
                return ret;
            }
            if (this.field_17657.size() >= field_31426) {
                ((class_2861)this.field_17657.removeLast()).close();
            }
            Path regionPath = this.field_18690.resolve(RegionFileStorageMixin.getRegionFileName(chunkPos.field_9181, chunkPos.field_9180));
            this.createRegionFile(key);
            class_4239.method_47525((Path)this.field_18690);
            ret = new class_2861(this.field_49103, regionPath, this.field_18690, this.field_23748);
            this.field_17657.putAndMoveToFirst(key, (Object)ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(int chunkX, int chunkZ, class_2487 compound) throws IOException {
        if (compound == null) {
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        class_1923 pos = new class_1923(chunkX, chunkZ);
        class_2861 regionFile = this.method_12440(pos);
        MoonriseRegionFileIO.RegionDataController.WriteData writeData = ((ChunkSystemRegionFile)regionFile).moonrise$startWrite(compound, pos);
        try {
            class_2507.method_10628((class_2487)compound, (DataOutput)writeData.output());
        }
        finally {
            writeData.output().close();
        }
        return writeData;
    }

    @Override
    public final void moonrise$finishWrite(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.WriteData writeData) throws IOException {
        class_1923 pos = new class_1923(chunkX, chunkZ);
        if (writeData.result() == MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE) {
            class_2861 regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
            if (regionFile != null) {
                regionFile.method_31740(pos);
            }
            return;
        }
        writeData.write().run(this.method_12440(pos));
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.ReadData moonrise$readData(int chunkX, int chunkZ) throws IOException {
        DataInputStream input;
        class_2861 regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
        DataInputStream dataInputStream = input = regionFile == null ? null : regionFile.method_21873(new class_1923(chunkX, chunkZ));
        if (input == null) {
            return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.NO_DATA, null, null);
        }
        MoonriseRegionFileIO.RegionDataController.ReadData ret = new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.HAS_DATA, input, null);
        if (!(input instanceof ExternalChunkStreamMarker)) {
            return ret;
        }
        class_2487 syncRead = this.moonrise$finishRead(chunkX, chunkZ, ret);
        if (syncRead == null) {
            return this.moonrise$readData(chunkX, chunkZ);
        }
        return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.SYNC_READ, null, syncRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final class_2487 moonrise$finishRead(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.ReadData readData) throws IOException {
        try {
            class_2487 class_24872 = class_2507.method_10627((DataInput)readData.input());
            return class_24872;
        }
        finally {
            readData.input().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Overwrite
    public void close() throws IOException {
        RegionFileStorageMixin regionFileStorageMixin = this;
        synchronized (regionFileStorageMixin) {
            class_5127 exceptionCollector = new class_5127();
            for (class_2861 regionFile : this.field_17657.values()) {
                try {
                    regionFile.close();
                }
                catch (IOException ex) {
                    exceptionCollector.method_26807((Throwable)ex);
                }
            }
            exceptionCollector.method_26806();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void method_26982() throws IOException {
        RegionFileStorageMixin regionFileStorageMixin = this;
        synchronized (regionFileStorageMixin) {
            class_5127 exceptionCollector = new class_5127();
            for (class_2861 regionFile : this.field_17657.values()) {
                try {
                    regionFile.method_26981();
                }
                catch (IOException ex) {
                    exceptionCollector.method_26807((Throwable)ex);
                }
            }
            exceptionCollector.method_26806();
        }
    }

    @Redirect(method={"method_17911(Lnet/minecraft/class_1923;)Lnet/minecraft/class_2487;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2867;method_12440(Lnet/minecraft/class_1923;)Lnet/minecraft/class_2861;"))
    private class_2861 avoidCreatingReadRegionFile(class_2867 instance, class_1923 chunkPos) throws IOException {
        return ((RegionFileStorageMixin)instance).moonrise$getRegionFileIfExists(chunkPos.field_9181, chunkPos.field_9180);
    }

    @Inject(method={"method_17911(Lnet/minecraft/class_1923;)Lnet/minecraft/class_2487;"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/class_2861;method_21873(Lnet/minecraft/class_1923;)Ljava/io/DataInputStream;")})
    private void avoidCreatingReadRegionFileExit(class_1923 chunkPos, CallbackInfoReturnable<class_2487> cir, class_2861 regionFile) {
        if (regionFile == null) {
            cir.setReturnValue(null);
            return;
        }
    }

    @Redirect(method={"method_39802(Lnet/minecraft/class_1923;Lnet/minecraft/class_6836;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2867;method_12440(Lnet/minecraft/class_1923;)Lnet/minecraft/class_2861;"))
    private class_2861 avoidCreatingScanRegionFile(class_2867 instance, class_1923 chunkPos) throws IOException {
        return ((RegionFileStorageMixin)instance).moonrise$getRegionFileIfExists(chunkPos.field_9181, chunkPos.field_9180);
    }

    @Inject(method={"method_39802(Lnet/minecraft/class_1923;Lnet/minecraft/class_6836;)V"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/class_2861;method_21873(Lnet/minecraft/class_1923;)Ljava/io/DataInputStream;")})
    private void avoidCreatingScanRegionFileExit(class_1923 chunkPos, class_6836 streamTagVisitor, CallbackInfo ci, class_2861 regionFile) {
        if (regionFile == null) {
            ci.cancel();
            return;
        }
    }

    @Inject(method={"method_23726(Lnet/minecraft/class_1923;Lnet/minecraft/class_2487;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void avoidCreatingWriteRegionFile(class_1923 chunkPos, class_2487 compoundTag, CallbackInfo ci) throws IOException {
        if (compoundTag == null && this.moonrise$getRegionFileIfExists(chunkPos.field_9181, chunkPos.field_9180) == null) {
            ci.cancel();
            return;
        }
    }
}

