/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_tick_iteration;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2LongChainedHashTable;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import net.minecraft.class_1923;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_5568;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3898.class})
abstract class ChunkMapMixin {
    @Shadow
    @Final
    private class_3898.class_3216 field_17228;
    @Shadow
    @Final
    public class_3218 field_17214;

    ChunkMapMixin() {
    }

    @Shadow
    public abstract boolean method_38782(class_3222 var1, class_1923 var2);

    @Inject(method={"method_18713(Lnet/minecraft/class_3222;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3898;method_20726(Lnet/minecraft/class_3222;)V")})
    private void updateSpawnTracker(class_3222 player, CallbackInfo ci, @Local(ordinal=0) class_4076 oldPos, @Local(ordinal=1) class_4076 newPos, @Local(ordinal=0) boolean oldIgnore, @Local(ordinal=1) boolean newIgnore) {
        ((ChunkTickDistanceManager)this.field_17228).moonrise$updatePlayer(player, oldPos, newPos, oldIgnore, newIgnore);
    }

    @Inject(method={"method_18714(Lnet/minecraft/class_3222;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3898$class_3216;method_14048(Lnet/minecraft/class_4076;Lnet/minecraft/class_3222;)V")})
    private void addPlayerToSpawnTracker(class_3222 player, boolean add, CallbackInfo ci) {
        ((ChunkTickDistanceManager)this.field_17228).moonrise$addPlayer(player, class_4076.method_42614((class_5568)player));
    }

    @Inject(method={"method_18714(Lnet/minecraft/class_3222;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3898$class_3216;method_14051(Lnet/minecraft/class_4076;Lnet/minecraft/class_3222;)V")})
    private void removePlayerFromSpawnTracker(class_3222 player, boolean add, CallbackInfo ci) {
        ((ChunkTickDistanceManager)this.field_17228).moonrise$removePlayer(player, class_4076.method_42614((class_5568)player));
    }

    @Overwrite
    public boolean method_38783(class_1923 pos) {
        if (((ChunkTickDistanceManager)this.field_17228).moonrise$hasAnyNearbyNarrow(pos.field_9181, pos.field_9180)) {
            return true;
        }
        return this.method_61261(pos);
    }

    @Overwrite
    public boolean method_61261(class_1923 pos) {
        ReferenceList<class_3222> players = ((ChunkSystemServerLevel)this.field_17214).moonrise$getNearbyPlayers().getPlayers(pos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        class_3222[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            if (!this.method_38782(raw[i], pos)) continue;
            return true;
        }
        return false;
    }

    @Overwrite
    public List<class_3222> method_37907(class_1923 pos) {
        ReferenceList<class_3222> players = ((ChunkSystemServerLevel)this.field_17214).moonrise$getNearbyPlayers().getPlayers(pos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return new ArrayList<class_3222>();
        }
        ArrayList<class_3222> ret = null;
        class_3222[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            class_3222 player = raw[i];
            if (!this.method_38782(player, pos)) continue;
            if (ret == null) {
                ret = new ArrayList(len - i);
                ret.add(player);
                continue;
            }
            ret.add(player);
        }
        return ret == null ? new ArrayList<class_3222>() : ret;
    }

    @Unique
    private boolean isChunkNearPlayer(class_3898 chunkMap, class_1923 chunkPos, class_2818 levelChunk) {
        ChunkData chunkData = ((ChunkSystemLevelChunk)levelChunk).moonrise$getChunkHolder().holderData;
        NearbyPlayers.TrackedChunk nearbyPlayers = chunkData.nearbyPlayers;
        if (nearbyPlayers == null) {
            return false;
        }
        if (((ChunkTickDistanceManager)this.field_17228).moonrise$hasAnyNearbyNarrow(chunkPos.field_9181, chunkPos.field_9180)) {
            return true;
        }
        ReferenceList<class_3222> players = nearbyPlayers.getPlayers(NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        class_3222[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            if (!chunkMap.method_38782(raw[i], chunkPos)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"method_67497(Ljava/util/List;)V"}, cancellable=true, at={@At(value="HEAD")})
    public void collectSpawningChunks(List<class_2818> list, CallbackInfo ci) {
        ReferenceList<class_2818> tickingChunks = ((ChunkTickServerLevel)this.field_17214).moonrise$getPlayerTickingChunks();
        ConcurrentLong2LongChainedHashTable forceSpawningChunks = ((ChunkSystemServerLevel)this.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketCounters(2L);
        class_2818[] raw = tickingChunks.getRawDataUnchecked();
        int size = tickingChunks.size();
        Objects.checkFromToIndex(0, size, raw.length);
        if (forceSpawningChunks != null && !forceSpawningChunks.isEmpty()) {
            LongOpenHashSet seen = new LongOpenHashSet(forceSpawningChunks.size());
            ChunkHolderManager chunkHolderManager = ((ChunkSystemServerLevel)this.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager;
            PrimitiveIterator.OfLong iterator = forceSpawningChunks.keyIterator();
            while (iterator.hasNext()) {
                long pos = iterator.nextLong();
                NewChunkHolder holder = chunkHolderManager.getChunkHolder(pos);
                if (holder == null || !holder.isEntityTickingReady()) continue;
                seen.add(pos);
                list.add((class_2818)holder.getCurrentChunk());
            }
            for (int i = 0; i < size; ++i) {
                class_2818 levelChunk = raw[i];
                if (seen.contains(CoordinateUtils.getChunkKey(levelChunk.method_12004())) || !this.isChunkNearPlayer((class_3898)this, levelChunk.method_12004(), levelChunk)) continue;
                list.add(levelChunk);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                class_2818 levelChunk = raw[i];
                if (!this.isChunkNearPlayer((class_3898)this, levelChunk.method_12004(), levelChunk)) continue;
                list.add(levelChunk);
            }
        }
        ci.cancel();
    }
}

