/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.entity_tracker;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerTrackedEntity;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_3898.class_3208.class})
abstract class TrackedEntityMixin
implements EntityTrackerTrackedEntity {
    @Shadow
    @Final
    private Set<class_5629> field_18250;
    @Shadow
    @Final
    private int field_18248;
    @Shadow
    @Final
    class_1297 field_18247;
    @Unique
    private long lastChunkUpdate = -1L;
    @Unique
    private NearbyPlayers.TrackedChunk lastTrackedChunk;

    TrackedEntityMixin() {
    }

    @Shadow
    public abstract void method_18736(class_3222 var1);

    @Shadow
    public abstract void method_18733(class_3222 var1);

    @Shadow
    protected abstract int method_27906(int var1);

    @Override
    public final void moonrise$tick(NearbyPlayers.TrackedChunk chunk) {
        class_3222 player;
        if (chunk == null) {
            this.moonrise$clearPlayers();
            return;
        }
        ReferenceList<class_3222> players = chunk.getPlayers(NearbyPlayers.NearbyMapType.VIEW_DISTANCE);
        if (players == null) {
            this.moonrise$clearPlayers();
            return;
        }
        long lastChunkUpdate = this.lastChunkUpdate;
        long currChunkUpdate = chunk.getUpdateCount();
        NearbyPlayers.TrackedChunk lastTrackedChunk = this.lastTrackedChunk;
        this.lastChunkUpdate = currChunkUpdate;
        this.lastTrackedChunk = chunk;
        class_3222[] playersRaw = players.getRawDataUnchecked();
        int len = players.size();
        for (int i = 0; i < len; ++i) {
            player = playersRaw[i];
            this.method_18736(player);
        }
        if (lastChunkUpdate != currChunkUpdate || lastTrackedChunk != chunk) {
            for (class_5629 conn : new ArrayList<class_5629>(this.field_18250)) {
                player = conn.method_32311();
                if (players.contains(player)) continue;
                this.method_18733(player);
            }
        }
    }

    @Override
    public final void moonrise$removeNonTickThreadPlayers() {
        boolean foundToRemove = false;
        for (class_5629 conn : this.field_18250) {
            if (TickThread.isTickThreadFor((class_1297)conn.method_32311())) continue;
            foundToRemove = true;
            break;
        }
        if (!foundToRemove) {
            return;
        }
        for (class_5629 conn : new ArrayList<class_5629>(this.field_18250)) {
            class_3222 player = conn.method_32311();
            if (TickThread.isTickThreadFor((class_1297)player)) continue;
            this.method_18733(player);
        }
    }

    @Override
    public final void moonrise$clearPlayers() {
        this.lastChunkUpdate = -1L;
        this.lastTrackedChunk = null;
        if (this.field_18250.isEmpty()) {
            return;
        }
        for (class_5629 conn : new ArrayList<class_5629>(this.field_18250)) {
            class_3222 player = conn.method_32311();
            this.method_18733(player);
        }
    }

    @Override
    public final boolean moonrise$hasPlayers() {
        return !this.field_18250.isEmpty();
    }

    @Redirect(method={"<init>(Lnet/minecraft/class_3898;Lnet/minecraft/class_1297;IIZ)V"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Sets;newIdentityHashSet()Ljava/util/Set;"))
    private <E> Set<E> useBetterIdentitySet() {
        return new ReferenceOpenHashSet();
    }

    @Overwrite
    public int method_22844() {
        class_1297 entity = this.field_18247;
        int range = this.field_18248;
        if (entity.method_5685() == ImmutableList.of()) {
            return this.method_27906(range);
        }
        List passengers = (List)entity.method_5736();
        int len = passengers.size();
        for (int i = 0; i < len; ++i) {
            class_1297 passenger = (class_1297)passengers.get(i);
            range = Math.max(range, PlatformHooks.get().modifyEntityTrackingRange(passenger, passenger.method_5864().method_18387() << 4));
        }
        return this.method_27906(range);
    }
}

