/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkStatus;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkProgressionTask;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.class_9312;
import net.minecraft.class_9761;
import net.minecraft.class_9762;
import net.minecraft.class_9768;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkUpgradeGenericStatusTask
extends ChunkProgressionTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkUpgradeGenericStatusTask.class);
    private final class_2791 fromChunk;
    private final class_2806 fromStatus;
    private final class_2806 toStatus;
    private final class_9762<class_9761> neighbours;
    private final PrioritisedExecutor.PrioritisedTask generateTask;
    private volatile boolean scheduled;
    private static final VarHandle SCHEDULED_HANDLE = ConcurrentUtil.getVarHandle(ChunkUpgradeGenericStatusTask.class, "scheduled", Boolean.TYPE);

    public ChunkUpgradeGenericStatusTask(ChunkTaskScheduler scheduler, class_3218 world, int chunkX, int chunkZ, class_2791 chunk, class_9762<class_9761> neighbours, class_2806 toStatus, Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.fromChunk = chunk;
        this.fromStatus = chunk.method_12009();
        this.toStatus = toStatus;
        this.neighbours = neighbours;
        if (((ChunkSystemChunkStatus)this.toStatus).moonrise$isParallelCapable()) {
            this.generateTask = this.scheduler.parallelGenExecutor.createTask(this, priority);
        } else {
            int writeRadius = ((ChunkSystemChunkStatus)this.toStatus).moonrise$getWriteRadius();
            if (writeRadius < 0) {
                throw new IllegalStateException("Infinite write radius is not supported");
            }
            this.generateTask = this.scheduler.radiusAwareScheduler.createTask(chunkX, chunkZ, writeRadius, this, priority);
        }
    }

    @Override
    public class_2806 getTargetStatus() {
        return this.toStatus;
    }

    private boolean isEmptyTask() {
        boolean generation = !this.fromStatus.method_12165(this.toStatus);
        return generation && ((ChunkSystemChunkStatus)this.toStatus).moonrise$isEmptyGenStatus() || !generation && ((ChunkSystemChunkStatus)this.toStatus).moonrise$isEmptyLoadStatus();
    }

    @Override
    public void run() {
        class_2791 newChunk;
        CompletionStage completeFuture;
        boolean generation;
        class_2791 chunk = this.fromChunk;
        class_3215 serverChunkCache = this.world.method_14178();
        class_3898 chunkMap = serverChunkCache.field_17254;
        boolean completing = false;
        class_9312 ctx = chunkMap.field_51861;
        try {
            boolean bl = generation = !chunk.method_12009().method_12165(this.toStatus);
            if (generation) {
                if (((ChunkSystemChunkStatus)this.toStatus).moonrise$isEmptyGenStatus()) {
                    if (chunk instanceof class_2839) {
                        ((class_2839)chunk).method_12308(this.toStatus);
                    }
                    completing = true;
                    this.complete(chunk, null);
                    return;
                }
                completeFuture = class_9768.field_51900.method_60518(this.toStatus).method_60560(ctx, this.neighbours, this.fromChunk).whenComplete((either, throwable) -> {
                    if (either instanceof class_2839) {
                        class_2839 proto = (class_2839)either;
                        proto.method_12308(this.toStatus);
                    }
                });
            } else {
                if (((ChunkSystemChunkStatus)this.toStatus).moonrise$isEmptyLoadStatus()) {
                    completing = true;
                    this.complete(chunk, null);
                    return;
                }
                completeFuture = class_9768.field_51901.method_60518(this.toStatus).method_60560(ctx, this.neighbours, this.fromChunk);
            }
        }
        catch (Throwable throwable2) {
            if (!completing) {
                this.complete(null, throwable2);
                return;
            }
            this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Target status", ChunkTaskScheduler.stringIfNull(this.toStatus), "From status", ChunkTaskScheduler.stringIfNull(this.fromStatus), "Generation task", this), throwable2);
            LOGGER.error("Failed to complete status for chunk: status:" + String.valueOf(this.toStatus) + ", chunk: (" + this.chunkX + "," + this.chunkZ + "), world: " + WorldUtil.getWorldName((class_1937)this.world), throwable2);
            return;
        }
        if (!((CompletableFuture)completeFuture).isDone() && !((ChunkSystemChunkStatus)this.toStatus).moonrise$getWarnedAboutNoImmediateComplete().getAndSet(true)) {
            LOGGER.warn("Future status not complete after scheduling: " + this.toStatus.toString() + ", generate: " + generation);
        }
        try {
            newChunk = (class_2791)((CompletableFuture)completeFuture).join();
        }
        catch (Throwable throwable3) {
            this.complete(null, throwable3);
            return;
        }
        if (newChunk == null) {
            this.complete(null, new IllegalStateException("Chunk for status: " + this.toStatus.toString() + ", generation: " + generation + " should not be null! Future: " + String.valueOf(completeFuture)).fillInStackTrace());
            return;
        }
        this.complete(newChunk, null);
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        if (SCHEDULED_HANDLE.getAndSet(this, true)) {
            throw new IllegalStateException("Cannot double call schedule()");
        }
        if (this.isEmptyTask()) {
            if (this.generateTask.cancel()) {
                this.run();
            }
        } else {
            this.generateTask.queue();
        }
    }

    @Override
    public void cancel() {
        if (this.generateTask.cancel()) {
            this.complete(null, null);
        }
    }

    @Override
    public Priority getPriority() {
        return this.generateTask.getPriority();
    }

    @Override
    public void lowerPriority(Priority priority) {
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.generateTask.lowerPriority(priority);
    }

    @Override
    public void setPriority(Priority priority) {
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.generateTask.setPriority(priority);
    }

    @Override
    public void raisePriority(Priority priority) {
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.generateTask.raisePriority(priority);
    }
}

