/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.util;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import com.mojang.logging.LogUtils;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import org.slf4j.Logger;

public final class SaveUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int STARLIGHT_LIGHT_VERSION = 10;
    public static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    public static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    public static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    public static int getLightVersion() {
        return 10;
    }

    public static void saveLightHook(class_1937 world, class_2791 chunk, class_2487 nbt) {
        try {
            SaveUtil.saveLightHookReal(world, chunk, nbt);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to inject light data into save data for chunk " + String.valueOf(chunk.method_12004()) + ", chunk light will be recalculated on its next load", ex);
        }
    }

    private static void saveLightHookReal(class_1937 world, class_2791 chunk, class_2487 tag) {
        int i;
        boolean lit;
        if (tag == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection((class_5539)world);
        int maxSection = WorldUtil.getMaxLightSection((class_5539)world);
        SWMRNibbleArray[] blockNibbles = ((StarlightChunk)chunk).starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = ((StarlightChunk)chunk).starlight$getSkyNibbles();
        boolean bl = lit = chunk.method_12038() || !(world instanceof class_3218);
        if (lit) {
            tag.method_10556("isLightOn", false);
        }
        class_2806 status = tag.method_67491("Status", class_2806.field_56676).orElse(class_2806.field_12798);
        class_2487[] sections = new class_2487[maxSection - minSection + 1];
        class_2499 sectionsStored = tag.method_68569("sections");
        for (i = 0; i < sectionsStored.size(); ++i) {
            class_2487 sectionStored = sectionsStored.method_10602(i).orElse(null);
            if (sectionStored == null) continue;
            byte k = sectionStored.method_68562("Y", (byte)0);
            sectionStored.method_10551("BlockLight");
            sectionStored.method_10551("SkyLight");
            if (sectionStored.method_33133()) continue;
            sections[k - minSection] = sectionStored;
        }
        if (lit && status.method_12165(class_2806.field_12805)) {
            for (i = minSection; i <= maxSection; ++i) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i - minSection].getSaveState();
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i - minSection].getSaveState();
                if (blockNibble == null && skyNibble == null) continue;
                class_2487 section = sections[i - minSection];
                if (section == null) {
                    section = new class_2487();
                    section.method_10567("Y", (byte)i);
                    sections[i - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.method_10570("BlockLight", blockNibble.data);
                    }
                    section.method_10569(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.method_10570("SkyLight", skyNibble.data);
                }
                section.method_10569(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (class_2487 section : sections) {
            if (section == null) continue;
            sectionsStored.add((Object)section);
        }
        tag.method_10566("sections", (class_2520)sectionsStored);
        if (lit) {
            tag.method_10569(STARLIGHT_VERSION_TAG, 10);
        }
    }

    public static void loadLightHook(class_1937 world, class_1923 pos, class_2487 tag, class_2791 into) {
        try {
            SaveUtil.loadLightHookReal(world, pos, tag, into);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to load light for chunk " + String.valueOf(pos) + ", light will be recalculated", ex);
        }
    }

    private static void loadLightHookReal(class_1937 world, class_1923 pos, class_2487 tag, class_2791 into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection((class_5539)world);
        int maxSection = WorldUtil.getMaxLightSection((class_5539)world);
        into.method_12020(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight((class_5539)world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight((class_5539)world);
        boolean lit = tag.method_10580("isLightOn") != null && tag.method_68083(STARLIGHT_VERSION_TAG, -1) == 10;
        boolean canReadSky = world.method_8597().comp_642();
        class_2806 status = tag.method_67491("Status", class_2806.field_56676).orElse(class_2806.field_12798);
        if (lit && status.method_12165(class_2806.field_12805)) {
            class_2499 sections = tag.method_68569("sections");
            for (int i = 0; i < sections.size(); ++i) {
                class_2487 sectionData = sections.method_10602(i).orElse(null);
                if (sectionData == null) continue;
                byte y = sectionData.method_68562("Y", (byte)0);
                byte[] blockLight = sectionData.method_10547("BlockLight").orElse(null);
                blockNibbles[y - minSection] = blockLight != null ? new SWMRNibbleArray((byte[])blockLight.clone(), sectionData.method_68083(BLOCKLIGHT_STATE_TAG, 0)) : new SWMRNibbleArray(null, sectionData.method_68083(BLOCKLIGHT_STATE_TAG, 0));
                if (!canReadSky) continue;
                byte[] skyLight = sectionData.method_10547("SkyLight").orElse(null);
                skyNibbles[y - minSection] = skyLight != null ? new SWMRNibbleArray((byte[])skyLight.clone(), sectionData.method_68083(SKYLIGHT_STATE_TAG, 0)) : new SWMRNibbleArray(null, sectionData.method_68083(SKYLIGHT_STATE_TAG, 0));
            }
        }
        ((StarlightChunk)into).starlight$setBlockNibbles(blockNibbles);
        ((StarlightChunk)into).starlight$setSkyNibbles(skyNibbles);
        into.method_12020(lit);
    }

    private SaveUtil() {
    }
}

