/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.time;

import ca.spottedleaf.moonrise.common.time.TickTime;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.TimeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class TickData {
    private final long interval;
    private final ArrayDeque<TickTime> timeData = new ArrayDeque();

    public TickData(long intervalNS) {
        this.interval = intervalNS;
    }

    public void addDataFrom(TickTime time) {
        TickTime first;
        long start = time.tickStart();
        while ((first = this.timeData.peekFirst()) != null && start - first.tickEnd() > this.interval) {
            this.timeData.pollFirst();
        }
        this.timeData.add(time);
    }

    private static double median(long[] arr, int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        int middle = fromIndex + (len >>> 1);
        if ((len & 1) == 0) {
            return (double)(arr[middle - 1] + arr[middle]) / 2.0;
        }
        return arr[middle];
    }

    private static SegmentData computeSegmentData(long[] arr, int fromIndex, int toIndex, boolean inverse) {
        int len = toIndex - fromIndex;
        long sum = 0L;
        double median = TickData.median(arr, fromIndex, toIndex);
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = fromIndex; i < toIndex; ++i) {
            long val = arr[i];
            sum += val;
            min = Math.min(min, val);
            max = Math.max(max, val);
        }
        if (inverse) {
            return new SegmentData(len, (double)len / ((double)sum / 1.0E9), 1.0E9 / median, 1.0E9 / (double)max, 1.0E9 / (double)min);
        }
        return new SegmentData(len, (double)sum / (double)len, median, min, max);
    }

    private static SegmentedAverage computeSegmentedAverage(long[] data, int allStart, int allEnd, int percent99BestStart, int percent99BestEnd, int percent95BestStart, int percent95BestEnd, int percent1WorstStart, int percent1WorstEnd, int percent5WorstStart, int percent5WorstEnd, boolean inverse) {
        return new SegmentedAverage(TickData.computeSegmentData(data, allStart, allEnd, inverse), TickData.computeSegmentData(data, percent99BestStart, percent99BestEnd, inverse), TickData.computeSegmentData(data, percent95BestStart, percent95BestEnd, inverse), TickData.computeSegmentData(data, percent1WorstStart, percent1WorstEnd, inverse), TickData.computeSegmentData(data, percent5WorstStart, percent5WorstEnd, inverse), data);
    }

    public Double getTPSAverage(TickTime inProgress, long tickInterval) {
        return this.getTPSAverage(inProgress, tickInterval, false);
    }

    public Double getTPSAverage(TickTime inProgress, long tickInterval, boolean createFakeTick) {
        List<TickInformation> collapsedData;
        if (this.timeData.isEmpty() && inProgress == null) {
            return null;
        }
        ArrayList<TickTime> allData = new ArrayList<TickTime>(this.timeData);
        if (inProgress != null) {
            allData.add(inProgress);
        }
        if ((collapsedData = TickData.collapseData(allData, tickInterval, createFakeTick)).isEmpty()) {
            return null;
        }
        long totalTimeBetweenTicks = 0L;
        int collectedTicks = 0;
        for (TickInformation time : collapsedData) {
            totalTimeBetweenTicks += time.differenceFromLastTick();
            ++collectedTicks;
        }
        return (double)collectedTicks / ((double)totalTimeBetweenTicks / 1.0E9);
    }

    public MSPTData getMSPTData(TickTime inProgress, long tickInterval) {
        return this.getMSPTData(inProgress, tickInterval, false);
    }

    public MSPTData getMSPTData(TickTime inProgress, long tickInterval, boolean createFakeTick) {
        List<TickInformation> collapsedData;
        if (this.timeData.isEmpty() && inProgress == null) {
            return null;
        }
        ArrayList<TickTime> allData = new ArrayList<TickTime>(this.timeData);
        if (inProgress != null) {
            allData.add(inProgress);
        }
        if ((collapsedData = TickData.collapseData(allData, tickInterval, createFakeTick)).isEmpty()) {
            return null;
        }
        long totalTimeTicking = 0L;
        int collectedTicks = 0;
        long[] timePerTickDataRaw = new long[collapsedData.size()];
        for (int i = 0; i < collapsedData.size(); ++i) {
            TickInformation time = collapsedData.get(i);
            totalTimeTicking += time.tickTime();
            timePerTickDataRaw[i] = time.tickTime();
            ++collectedTicks;
        }
        return new MSPTData((double)totalTimeTicking / (double)collectedTicks * 1.0E-6, timePerTickDataRaw);
    }

    public TickReportData generateTickReport(TickTime inProgress, long endTime, long tickInterval) {
        return this.generateTickReport(inProgress, endTime, tickInterval, false);
    }

    public TickReportData generateTickReport(TickTime inProgress, long endTime, long tickInterval, boolean createFakeTick) {
        List<TickInformation> collapsedData;
        if (this.timeData.isEmpty() && inProgress == null) {
            return null;
        }
        ArrayList<TickTime> allData = new ArrayList<TickTime>(this.timeData);
        if (inProgress != null) {
            allData.add(inProgress);
        }
        if ((collapsedData = TickData.collapseData(allData, tickInterval, createFakeTick)).isEmpty()) {
            return null;
        }
        long intervalStart = ((TickTime)allData.get(0)).tickStart();
        long intervalEnd = ((TickTime)allData.get(allData.size() - 1)).tickEnd();
        long totalTimeOverInterval = 0L;
        long measureStart = endTime - this.interval;
        int len = allData.size();
        for (int i = 0; i < len; ++i) {
            TickTime time = (TickTime)allData.get(i);
            if (TimeUtil.compareTimes(time.tickStart(), measureStart) < 0) {
                long diff = time.tickEnd() - measureStart;
                if (diff <= 0L) continue;
                totalTimeOverInterval += diff;
                continue;
            }
            totalTimeOverInterval += time.tickLength();
        }
        int collectedTicks = collapsedData.size();
        long[] tickStartToStartDifferences = new long[collectedTicks];
        long[] timePerTickDataRaw = new long[collectedTicks];
        long[] missingCPUTimeDataRaw = new long[collectedTicks];
        long totalTimeTicking = 0L;
        int i = 0;
        for (TickInformation time : collapsedData) {
            tickStartToStartDifferences[i] = time.differenceFromLastTick();
            long timePerTick = timePerTickDataRaw[i] = time.tickTime();
            missingCPUTimeDataRaw[i] = Math.max(0L, timePerTick - time.tickTimeCPU());
            ++i;
            totalTimeTicking += timePerTick;
        }
        Arrays.sort(tickStartToStartDifferences);
        Arrays.sort(timePerTickDataRaw);
        Arrays.sort(missingCPUTimeDataRaw);
        boolean allStart = false;
        int allEnd = collectedTicks;
        boolean percent95BestStart = false;
        int percent95BestEnd = collectedTicks == 1 ? 1 : (int)(0.95 * (double)collectedTicks);
        boolean percent99BestStart = false;
        int percent99BestEnd = collectedTicks == 1 ? 1 : (int)(0.99 * (double)collectedTicks);
        int percent1WorstStart = (int)(0.99 * (double)collectedTicks);
        int percent1WorstEnd = collectedTicks;
        int percent5WorstStart = (int)(0.95 * (double)collectedTicks);
        int percent5WorstEnd = collectedTicks;
        SegmentedAverage tpsData = TickData.computeSegmentedAverage(tickStartToStartDifferences, 0, allEnd, 0, percent99BestEnd, 0, percent95BestEnd, percent1WorstStart, percent1WorstEnd, percent5WorstStart, percent5WorstEnd, true);
        SegmentedAverage timePerTickData = TickData.computeSegmentedAverage(timePerTickDataRaw, 0, allEnd, 0, percent99BestEnd, 0, percent95BestEnd, percent1WorstStart, percent1WorstEnd, percent5WorstStart, percent5WorstEnd, false);
        SegmentedAverage missingCPUTimeData = TickData.computeSegmentedAverage(missingCPUTimeDataRaw, 0, allEnd, 0, percent99BestEnd, 0, percent95BestEnd, percent1WorstStart, percent1WorstEnd, percent5WorstStart, percent5WorstEnd, false);
        double utilisation = (double)totalTimeOverInterval / (double)this.interval;
        return new TickReportData(collectedTicks, intervalStart, intervalEnd, totalTimeTicking, utilisation, tpsData, timePerTickData, missingCPUTimeData);
    }

    private static List<TickInformation> collapseData(List<TickTime> allData, long tickInterval, boolean createFakeTick) {
        ArrayList<TickInformation> collapsedData = new ArrayList<TickInformation>();
        int len = allData.size();
        for (int i = 0; i < len; ++i) {
            ArrayList<TickTime> toCollapse = new ArrayList<TickTime>();
            TickTime lastTick = null;
            while (i < len) {
                TickTime time = allData.get(i);
                if (time.isTickExecution()) {
                    lastTick = time;
                    break;
                }
                toCollapse.add(time);
                ++i;
            }
            if (toCollapse.isEmpty()) {
                TickTime last = allData.get(i);
                collapsedData.add(new TickInformation(last.differenceFromLastTick(tickInterval), last.tickLength(), last.supportCPUTime() ? last.tickCpuTime() : 0L));
                continue;
            }
            long totalTickTime = 0L;
            long totalCpuTime = 0L;
            int len2 = toCollapse.size();
            for (int k = 0; k < len2; ++k) {
                TickTime time = (TickTime)toCollapse.get(k);
                totalTickTime += time.tickLength();
                totalCpuTime += time.supportCPUTime() ? time.tickCpuTime() : 0L;
            }
            if (i < len) {
                TickTime last = allData.get(i);
                collapsedData.add(new TickInformation(last.differenceFromLastTick(tickInterval), last.tickLength() + totalTickTime, (last.supportCPUTime() ? last.tickCpuTime() : 0L) + totalCpuTime));
                continue;
            }
            if (!createFakeTick) continue;
            long differenceBetweenTicks = lastTick != null ? lastTick.tickStart() : Math.max(tickInterval, totalTickTime);
            collapsedData.add(new TickInformation(differenceBetweenTicks, totalTickTime, totalCpuTime));
        }
        return collapsedData;
    }

    public record SegmentData(int count, double average, double median, double least, double greatest) {
    }

    public record SegmentedAverage(SegmentData segmentAll, SegmentData segment99PercentBest, SegmentData segment95PercentBest, SegmentData segment5PercentWorst, SegmentData segment1PercentWorst, long[] rawData) {
    }

    private record TickInformation(long differenceFromLastTick, long tickTime, long tickTimeCPU) {
    }

    public record MSPTData(double avg, long[] rawData) {
    }

    public record TickReportData(int collectedTicks, long collectedTickIntervalStart, long collectedTickIntervalEnd, long totalTimeTicking, double utilisation, SegmentedAverage tpsData, SegmentedAverage timePerTickData, SegmentedAverage missingCPUTimeData) {
    }
}

